/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.darkutilities.features.flatblocks;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class BlockFlatTile
extends Block
implements SimpleWaterloggedBlock {
    public static final BooleanProperty HIDDEN = BooleanProperty.create((String)"hidden");
    public static final BooleanProperty LOCKED = BooleanProperty.create((String)"locked");
    public static final BlockBehaviour.Properties BLOCK_PROPERTIES = BlockBehaviour.Properties.of().mapColor(MapColor.DEEPSLATE).strength(3.0f, 10.0f).noCollission().sound(SoundType.DEEPSLATE_TILES);
    public static final VoxelShape BOUNDS = Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)1.0, (double)16.0);
    private final CollisionEffect collisionEffect;

    public BlockFlatTile(CollisionEffect collisionEffect) {
        this(BLOCK_PROPERTIES, collisionEffect);
    }

    public BlockFlatTile(BlockBehaviour.Properties properties, CollisionEffect collisionEffect) {
        super(properties);
        this.collisionEffect = collisionEffect;
        BlockState defaultState = this.defaultBlockState();
        defaultState = (BlockState)defaultState.setValue((Property)BlockStateProperties.POWERED, (Comparable)Boolean.valueOf(false));
        defaultState = (BlockState)defaultState.setValue((Property)BlockStateProperties.WATERLOGGED, (Comparable)Boolean.valueOf(false));
        defaultState = (BlockState)defaultState.setValue((Property)HIDDEN, (Comparable)Boolean.valueOf(false));
        defaultState = (BlockState)defaultState.setValue((Property)LOCKED, (Comparable)Boolean.valueOf(false));
        this.registerDefaultState(defaultState);
    }

    public void entityInside(BlockState state, Level world, BlockPos pos, Entity entity) {
        if (this.collisionEffect != null && !((Boolean)state.getValue((Property)BlockStateProperties.POWERED)).booleanValue() && entity.getY() <= (double)pos.getY() + 0.4) {
            this.collisionEffect.onCollision(state, world, pos, entity);
            if (((Boolean)state.getValue((Property)HIDDEN)).booleanValue()) {
                world.levelEvent(3002, pos, -1);
                world.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)HIDDEN, (Comparable)Boolean.valueOf(false)));
            }
        }
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{BlockStateProperties.POWERED, BlockStateProperties.WATERLOGGED, HIDDEN, LOCKED});
    }

    public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return BOUNDS;
    }

    public boolean isPossibleToRespawnInThis(BlockState state) {
        return true;
    }

    public InteractionResult use(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        if (player.getItemInHand(hand).is(Items.REDSTONE_TORCH)) {
            boolean oldValue = (Boolean)state.getValue((Property)LOCKED);
            level.setBlock(pos, (BlockState)state.setValue((Property)LOCKED, (Comparable)Boolean.valueOf(!oldValue)), 2);
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                serverLevel.sendParticles((ParticleOptions)(!oldValue ? DustParticleOptions.REDSTONE : ParticleTypes.SMOKE), (double)pos.getX() + 0.5, (double)((float)pos.getY() + 0.075f), (double)pos.getZ() + 0.5, 16, 0.25, 0.0, 0.25, 0.0);
                serverLevel.playSound(null, pos, SoundEvents.LEVER_CLICK, SoundSource.BLOCKS, 0.3f, !oldValue ? 0.6f : 0.5f);
            }
            return InteractionResult.SUCCESS;
        }
        return super.use(state, level, pos, player, hand, hitResult);
    }

    public FluidState getFluidState(BlockState state) {
        return (Boolean)state.getValue((Property)BlockStateProperties.WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(state);
    }

    public BlockState updateShape(BlockState state, Direction facing, BlockState facingState, LevelAccessor world, BlockPos currentPos, BlockPos facingPos) {
        if (((Boolean)state.getValue((Property)BlockStateProperties.WATERLOGGED)).booleanValue()) {
            world.scheduleTick(currentPos, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay((LevelReader)world));
        }
        return super.updateShape(state, facing, facingState, world, currentPos, facingPos);
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        FluidState preExistingFluidState = context.getLevel().getFluidState(context.getClickedPos());
        BlockState placedState = super.getStateForPlacement(context);
        if (placedState != null) {
            placedState = (BlockState)placedState.setValue((Property)BlockStateProperties.WATERLOGGED, (Comparable)Boolean.valueOf(preExistingFluidState.is((Fluid)Fluids.WATER)));
            placedState = (BlockState)placedState.setValue((Property)BlockStateProperties.POWERED, (Comparable)Boolean.valueOf(context.getLevel().hasNeighborSignal(context.getClickedPos())));
        }
        return placedState;
    }

    public void neighborChanged(BlockState state, Level world, BlockPos pos, Block block, BlockPos fromPos, boolean isMoving) {
        if (!world.isClientSide && !((Boolean)state.getValue((Property)LOCKED)).booleanValue()) {
            world.setBlock(pos, (BlockState)state.setValue((Property)BlockStateProperties.POWERED, (Comparable)Boolean.valueOf(world.hasNeighborSignal(pos))), 2);
        }
        super.neighborChanged(state, world, pos, block, fromPos, isMoving);
    }

    @FunctionalInterface
    public static interface CollisionEffect {
        public void onCollision(BlockState var1, Level var2, BlockPos var3, Entity var4);
    }
}

