/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.darkutilities.features.redstone;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;

public class BlockRedstoneRandomizer
extends Block {
    public BlockRedstoneRandomizer() {
        super(BlockBehaviour.Properties.of().mapColor(MapColor.DEEPSLATE).strength(3.5f).randomTicks());
        this.registerDefaultState((BlockState)((BlockState)this.defaultBlockState().setValue((Property)BlockStateProperties.ENABLED, (Comparable)Boolean.valueOf(false))).setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.NORTH));
    }

    public void tick(BlockState state, ServerLevel world, BlockPos pos, RandomSource random) {
        world.setBlockAndUpdate(pos, (BlockState)state.cycle((Property)BlockStateProperties.ENABLED));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{BlockStateProperties.ENABLED, BlockStateProperties.HORIZONTAL_FACING});
    }

    public boolean isSignalSource(BlockState state) {
        return (Boolean)state.getValue((Property)BlockStateProperties.ENABLED);
    }

    public int getSignal(BlockState state, BlockGetter world, BlockPos pos, Direction side) {
        return (Boolean)state.getValue((Property)BlockStateProperties.ENABLED) != false && side.getOpposite() == state.getValue((Property)BlockStateProperties.HORIZONTAL_FACING) ? 15 : 0;
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        BlockState placedState = super.getStateForPlacement(context);
        if (placedState != null) {
            for (Direction facing : context.getNearestLookingDirections()) {
                if (!facing.getAxis().isHorizontal()) continue;
                return (BlockState)placedState.setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)facing.getOpposite());
            }
        }
        return placedState;
    }
}

