/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.coins;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import net.darkhax.bookshelf.Constants;
import net.darkhax.bookshelf.api.Services;
import net.darkhax.bookshelf.api.registry.RegistryDataProvider;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.BannerPatternItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.level.block.entity.BannerPattern;
import org.apache.commons.lang3.StringUtils;

public final class CoinsContent
extends RegistryDataProvider {
    public static final String MOD_ID = "coinsje";
    private final TagKey<BannerPattern> bannerTag = TagKey.m_203882_((ResourceKey)Registries.f_256969_, (ResourceLocation)new ResourceLocation("coinsje", "pattern_item/coin_patterns"));

    public static void init() {
        Services.REGISTRIES.loadContent((RegistryDataProvider)new CoinsContent());
    }

    private CoinsContent() {
        super(MOD_ID);
        this.withItemTab(() -> ((Item)BuiltInRegistries.f_257033_.m_7745_(new ResourceLocation(MOD_ID, "gold_coin_pile"))).m_7968_());
        this.registerCoinTier("copper");
        this.registerCoinTier("iron");
        this.registerCoinTier("gold");
        this.registerCoinTier("diamond");
        this.registerCoinTier("netherite");
        this.items.add(() -> new BannerPatternItem(this.bannerTag, new Item.Properties().m_41487_(1).m_41497_(Rarity.UNCOMMON)), "coin_pattern");
        this.bannerPatterns.add(() -> new BannerPattern("coinsje_greyscale_coin_pile"), "greyscale_coin_pile");
        this.registerAltCoinTier("zinc");
        this.registerAltCoinTier("brass");
        this.registerAltCoinTier("amethyst");
        this.registerAltCoinTier("redstone");
        this.registerAltCoinTier("lapis");
        this.registerAltCoinTier("emerald");
        this.registerAltCoinTier("ender");
        this.registerAltCoinTier("blazing");
        this.registerAltCoinTier("echo");
        this.registerAltCoinTier("prismarine");
        this.registerAltCoinTier("quartz");
    }

    private void registerCoinTier(String tierName) {
        this.items.add(() -> new Item(new Item.Properties()), tierName + "_coin");
        this.items.add(() -> new Item(new Item.Properties()), tierName + "_coin_pile");
        this.bannerPatterns.add(() -> new BannerPattern("coinsje_" + tierName + "_coin_pile"), tierName + "_coin_pile");
    }

    private void registerAltCoinTier(String tierName) {
        FileWriter writer;
        FileWriter writer2;
        this.items.add(() -> new Item(new Item.Properties()), tierName + "_coin");
        this.items.add(() -> new Item(new Item.Properties()), tierName + "_coin_pile");
        File output = new File("output");
        output.mkdir();
        File recipes = new File(output, "recipes");
        recipes.mkdir();
        try {
            writer2 = new FileWriter(new File(recipes, "stack_" + tierName + "_pile.json"));
            try {
                writer2.append("{\n  \"type\": \"minecraft:crafting_shaped\",\n  \"group\": \"coin_pile\",\n  \"pattern\": [\n    \"XXX\",\n    \"XXX\",\n    \"XXX\"\n  ],\n  \"key\": {\n    \"X\": {\n      \"item\": \"coinsje:" + tierName + "_coin\"\n    }\n  },\n  \"result\": {\n    \"item\": \"coinsje:" + tierName + "_coin_pile\"\n  }\n}");
            }
            finally {
                writer2.close();
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        try {
            writer2 = new FileWriter(new File(recipes, "deconstruct_" + tierName + "_pile.json"));
            try {
                writer2.append("{\n  \"type\": \"minecraft:crafting_shapeless\",\n  \"group\": \"coins\",\n  \"ingredients\": [\n    {\n      \"item\": \"coinsje:" + tierName + "_coin_pile\"\n    }\n  ],\n  \"result\": {\n    \"item\": \"coinsje:" + tierName + "_coin\",\n    \"count\": 9\n  }\n}");
            }
            finally {
                writer2.close();
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        File models = new File(output, "models");
        models.mkdir();
        try {
            writer = new FileWriter(new File(models, tierName + "_coin.json"));
            try {
                writer.append("{\n    \"parent\": \"item/generated\",\n    \"textures\": {\n        \"layer0\": \"coinsje:item/" + tierName + "_coin\"\n    }\n}");
            }
            finally {
                writer.close();
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        try {
            writer = new FileWriter(new File(models, tierName + "_coin_pile.json"));
            try {
                writer.append("{\n    \"parent\": \"item/generated\",\n    \"textures\": {\n        \"layer0\": \"coinsje:item/" + tierName + "_coin_pile\"\n    }\n}");
            }
            finally {
                writer.close();
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        Constants.LOG.info("  \"item.coinsje." + tierName + "_coin\": \"" + StringUtils.capitalize((String)tierName) + " Coin\",");
        Constants.LOG.info("  \"item.coinsje." + tierName + "_coin_pile\": \"" + StringUtils.capitalize((String)tierName) + " Coin Pile\",");
    }
}

