/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.botanypotsmystical.common.impl.data.recipe.crop;

import com.blakebr0.mysticalagriculture.api.MysticalAgricultureAPI;
import com.blakebr0.mysticalagriculture.api.crop.Crop;
import com.blakebr0.mysticalagriculture.api.crop.CropTier;
import com.google.gson.JsonParseException;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import net.darkhax.bookshelf.common.api.function.CachedSupplier;
import net.darkhax.bookshelf.common.api.service.Services;
import net.darkhax.bookshelf.common.api.util.DataHelper;
import net.darkhax.botanypots.common.api.data.itemdrops.ItemDropProvider;
import net.darkhax.botanypots.common.impl.data.display.types.AgingDisplayState;
import net.darkhax.botanypots.common.impl.data.display.types.BasicOptions;
import net.darkhax.botanypots.common.impl.data.itemdrops.SimpleDropProvider;
import net.darkhax.botanypots.common.impl.data.recipe.crop.BasicCrop;
import net.darkhax.botanypotsmystical.common.impl.BotanyPotsMysticalMod;
import net.darkhax.botanypotsmystical.common.impl.config.Config;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;

public class MysticalCrop
extends BasicCrop {
    public static final MapCodec<MysticalCrop> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)ResourceLocation.CODEC.fieldOf("crop_id").forGetter(c -> c.mysticalCropId)).apply((Applicative)instance, MysticalCrop::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, MysticalCrop> STREAM = StreamCodec.of((buf, val) -> {
        buf.writeResourceLocation(val.mysticalCropId);
        BasicCrop.Properties.STREAM.encode(buf, (Object)val.getBasicProperties());
    }, buf -> {
        ResourceLocation id = buf.readResourceLocation();
        BasicCrop.Properties properties = (BasicCrop.Properties)BasicCrop.Properties.STREAM.decode(buf);
        return new MysticalCrop(id, properties);
    });
    public static final RecipeSerializer<MysticalCrop> SERIALIZER = DataHelper.recipeSerializer(CODEC, STREAM);
    public static final Supplier<Map<ResourceLocation, Ingredient>> SOIL_TIERS = CachedSupplier.cache(() -> {
        HashMap<ResourceLocation, Ingredient> tiers = new HashMap<ResourceLocation, Ingredient>();
        tiers.put(CropTier.ELEMENTAL.getId(), Ingredient.of((TagKey)TagKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)BotanyPotsMysticalMod.id("soil/elemental"))));
        tiers.put(CropTier.ONE.getId(), Ingredient.of((TagKey)TagKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)BotanyPotsMysticalMod.id("soil/inferium"))));
        tiers.put(CropTier.TWO.getId(), Ingredient.of((TagKey)TagKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)BotanyPotsMysticalMod.id("soil/prudentium"))));
        tiers.put(CropTier.THREE.getId(), Ingredient.of((TagKey)TagKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)BotanyPotsMysticalMod.id("soil/tertium"))));
        tiers.put(CropTier.FOUR.getId(), Ingredient.of((TagKey)TagKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)BotanyPotsMysticalMod.id("soil/imperium"))));
        tiers.put(CropTier.FIVE.getId(), Ingredient.of((TagKey)TagKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)BotanyPotsMysticalMod.id("soil/supremium"))));
        if (Services.PLATFORM.isModLoaded("mysticalagradditions")) {
            tiers.put(ResourceLocation.fromNamespaceAndPath((String)"mysticalagradditions", (String)"6"), Ingredient.of((TagKey)TagKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)BotanyPotsMysticalMod.id("soil/insanium"))));
        }
        return tiers;
    });
    private final ResourceLocation mysticalCropId;

    public MysticalCrop(ResourceLocation mysticalCropId) {
        this(mysticalCropId, MysticalCrop.makeProperties(mysticalCropId));
    }

    public MysticalCrop(ResourceLocation mysticalCropId, BasicCrop.Properties properties) {
        super(properties);
        this.mysticalCropId = mysticalCropId;
    }

    private static BasicCrop.Properties makeProperties(ResourceLocation mysticalCropId) {
        Crop mysticalCrop = MysticalAgricultureAPI.getCropRegistry().getCropById(mysticalCropId);
        if (mysticalCrop == null) {
            throw new JsonParseException("Crop ID '" + String.valueOf(mysticalCropId) + "' not found in registry!");
        }
        Ingredient soil = SOIL_TIERS.get().get(mysticalCrop.getTier().getId());
        if (soil == null) {
            soil = Ingredient.of((ItemLike[])new ItemLike[]{mysticalCrop.getTier().getFarmland().asItem()});
        }
        if (mysticalCrop.getCruxBlock() != null) {
            soil = BotanyPotsMysticalMod.COMBO.apply(List.of(soil, Ingredient.of((ItemLike[])new ItemLike[]{mysticalCrop.getCruxBlock().asItem()})));
        }
        int growTime = Config.getTierConfig((CropTier)mysticalCrop.getTier()).tier_tick_rate;
        List<AgingDisplayState> display = List.of(new AgingDisplayState((Block)mysticalCrop.getCropBlock(), BasicOptions.ofDefault()));
        List<ItemDropProvider> drops = List.of(MysticalCrop.getDrops(mysticalCrop));
        return new BasicCrop.Properties(Ingredient.of((ItemLike[])new ItemLike[]{mysticalCrop.getSeedsItem()}), soil, growTime, display, 0, drops, Optional.empty(), Optional.empty(), 1.0f, 1.0f);
    }

    private static ItemDropProvider getDrops(Crop crop) {
        ArrayList<SimpleDropProvider.SimpleDrop> drops = new ArrayList<SimpleDropProvider.SimpleDrop>();
        float secondaryChance = (float)crop.getSecondaryChance(BotanyPotsMysticalMod.INFERIUM_FARMLAND.get());
        drops.add(new SimpleDropProvider.SimpleDrop(crop.getSeedsItem().getDefaultInstance(), 1.0f));
        if (BotanyPotsMysticalMod.CFG_SECOND_SEED.get().booleanValue() && secondaryChance > 0.0f) {
            drops.add(new SimpleDropProvider.SimpleDrop(crop.getSeedsItem().getDefaultInstance(), secondaryChance));
        }
        drops.add(new SimpleDropProvider.SimpleDrop(crop.getEssenceItem().getDefaultInstance(), 1.0f));
        if (secondaryChance > 0.0f) {
            drops.add(new SimpleDropProvider.SimpleDrop(crop.getEssenceItem().getDefaultInstance(), secondaryChance));
        }
        if (BotanyPotsMysticalMod.CFG_ESSENCE_CHANCE.get() > 0.0) {
            drops.add(new SimpleDropProvider.SimpleDrop(new ItemStack((ItemLike)BotanyPotsMysticalMod.FERTILIZED_ESSENCE.get()), BotanyPotsMysticalMod.CFG_ESSENCE_CHANCE.get().floatValue()));
        }
        return new SimpleDropProvider(drops);
    }
}

