/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.botanypots.common.impl.command.generator;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import net.darkhax.botanypots.common.api.command.generator.DataHelper;
import net.darkhax.botanypots.common.api.command.generator.crop.CropGenerator;
import net.darkhax.botanypots.common.impl.BotanyPotsMod;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.BaseCoralPlantTypeBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.BushBlock;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.GrowingPlantBlock;
import net.minecraft.world.level.block.MushroomBlock;
import net.minecraft.world.level.block.SaplingBlock;
import net.minecraft.world.level.block.SporeBlossomBlock;

public class MissingCropGenerator
implements CropGenerator {
    private static final TagKey<Item> FLOWERS = TagKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"flowers"));
    private static final TagKey<Item> FORGE_SEEDS = TagKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"forge", (String)"seeds"));
    private static final TagKey<Item> COMMON_SEEDS = TagKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"c", (String)"seeds"));
    private static final TagKey<Item> IGNORED_ITEMS = TagKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)BotanyPotsMod.id("crop_generator_ignores"));

    @Override
    public boolean canGenerateCrop(ServerLevel level, ItemStack stack) {
        if (stack.is(IGNORED_ITEMS)) {
            return false;
        }
        Item item = stack.getItem();
        if (item instanceof BlockItem) {
            BlockItem blockItem = (BlockItem)item;
            if (stack.is(FORGE_SEEDS) || stack.is(COMMON_SEEDS) || stack.is(FLOWERS)) {
                return true;
            }
            Block placedBlock = blockItem.getBlock();
            ResourceLocation blockId = BuiltInRegistries.BLOCK.getKey((Object)placedBlock);
            if (placedBlock instanceof CropBlock || placedBlock instanceof GrowingPlantBlock || placedBlock instanceof BonemealableBlock || placedBlock instanceof SaplingBlock || placedBlock instanceof BushBlock || placedBlock instanceof SporeBlossomBlock || placedBlock instanceof BaseCoralPlantTypeBlock && !blockId.getPath().startsWith("dead_")) {
                return true;
            }
        }
        return false;
    }

    @Override
    public JsonObject generateData(ServerLevel level, ItemStack stack) {
        JsonObject output = new JsonObject();
        Block block = ((BlockItem)stack.getItem()).getBlock();
        output.add("bookshelf:load_conditions", (JsonElement)DataHelper.array(new JsonElement[]{DataHelper.requiresBlock(block)}));
        output.addProperty("type", "botanypots:block_derived_crop");
        output.addProperty("block", BuiltInRegistries.BLOCK.getKey((Object)block).toString());
        if (block instanceof BaseCoralPlantTypeBlock) {
            output.add("soil", (JsonElement)DataHelper.tag(BotanyPotsMod.id("soil/water")));
        }
        if (block instanceof MushroomBlock) {
            JsonObject blockTag = DataHelper.blockTag(ResourceLocation.withDefaultNamespace((String)"mushroom_grow_block"));
            JsonObject itemTag = DataHelper.tag(BotanyPotsMod.id("soil/mushroom"));
            output.add("soil", (JsonElement)DataHelper.ingredients(blockTag, itemTag));
        }
        return output;
    }
}

