/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.botanypots.common.api.command.generator.soil;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Objects;
import net.darkhax.botanypots.common.api.command.generator.DataHelper;
import net.darkhax.botanypots.common.api.command.generator.soil.SoilGenerator;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public class TaggedSoilGenerator
implements SoilGenerator {
    private final TagKey<Item> tag;
    private final JsonObject display;

    public TaggedSoilGenerator(String tag, JsonObject display) {
        this((TagKey<Item>)TagKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)Objects.requireNonNull(ResourceLocation.tryParse((String)tag))), display);
    }

    public TaggedSoilGenerator(TagKey<Item> tag, JsonObject display) {
        this.tag = tag;
        this.display = display;
    }

    @Override
    public boolean canGenerateSoil(Level level, ItemStack stack) {
        return stack.is(this.tag);
    }

    @Override
    public JsonObject generateData(Level level, ItemStack stack) {
        JsonObject output = new JsonObject();
        output.add("bookshelf:load_conditions", (JsonElement)DataHelper.array(new JsonElement[]{DataHelper.requiresItem(stack.getItem())}));
        output.addProperty("type", "botanypots:soil");
        output.add("input", (JsonElement)DataHelper.item(stack.getItem()));
        output.add("display", (JsonElement)this.display);
        return output;
    }
}

