/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.botanypots.common.impl.commands;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.StringJoiner;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.darkhax.bookshelf.common.api.function.ReloadableCache;
import net.darkhax.bookshelf.common.api.util.CommandHelper;
import net.darkhax.botanypots.common.api.data.recipes.RecipeCache;
import net.darkhax.botanypots.common.api.data.recipes.crop.Crop;
import net.darkhax.botanypots.common.api.data.recipes.fertilizer.Fertilizer;
import net.darkhax.botanypots.common.api.data.recipes.soil.Soil;
import net.darkhax.botanypots.common.impl.BotanyPotsMod;
import net.darkhax.botanypots.common.impl.commands.BotanyPotsCommands;
import net.darkhax.botanypots.common.impl.data.recipe.crop.BasicCrop;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.core.DefaultedRegistry;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseCoralPlantTypeBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.BushBlock;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.GrowingPlantBlock;
import net.minecraft.world.level.block.SaplingBlock;
import net.minecraft.world.level.block.SporeBlossomBlock;
import net.minecraft.world.level.block.state.properties.Property;
import org.apache.commons.io.FileUtils;

public class MissingCommand {
    private static final TagKey<Item> SOIL_WATER = TagKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"botanypots", (String)"soil/water"));
    private static final TagKey<Item> SOIL_LAVA = TagKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"botanypots", (String)"soil/lava"));
    private static final TagKey<Item> SOIL_SNOW = TagKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"botanypots", (String)"soil/snow"));
    private static final Comparator<ResourceLocation> ID_COMPARE = Comparator.comparing(ResourceLocation::toString);
    private static final TagKey<Item> FORGE_SEEDS = TagKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"forge", (String)"seeds"));
    private static final TagKey<Item> COMMON_SEEDS = TagKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"c", (String)"seeds"));
    private static final ReloadableCache<Set<Item>> IGNORED_ITEMS = ReloadableCache.of(() -> {
        HashSet<Item> items = new HashSet<Item>();
        items.add(Items.DEAD_BUSH);
        items.add(Items.MANGROVE_LEAVES);
        items.add(Items.NETHERRACK);
        items.add(Items.ROOTED_DIRT);
        items.add(Items.GRASS_BLOCK);
        items.add(Items.WARPED_NYLIUM);
        items.add(Items.CRIMSON_NYLIUM);
        return items;
    });
    public static final String SEED_TEMPLATE = "{\n  \"bookshelf:load_conditions\": [\n    {\n      \"type\": \"bookshelf:block_exists\",\n      \"values\": [\n        \"$block_id$\"\n      ]\n    }\n  ],\n  \"type\": \"botanypots:block_derived_crop\",\n  \"block\": \"$block_id$\"\n}\n";
    public static final String WATER_SOIL = "{\n  \"bookshelf:load_conditions\": [\n    {\n      \"type\": \"bookshelf:item_exists\",\n      \"values\": [\n        \"$item_id$\"\n      ]\n    }\n  ],\n  \"type\": \"botanypots:soil\",\n  \"input\": {\n    \"item\": \"$item_id$\"\n  },\n  \"display\": {\n    \"type\": \"botanypots:simple\",\n    \"block_state\": {\n      \"block\": \"minecraft:water\"\n    },\n    \"options\": {\n      \"render_fluid\": true\n    }\n  }\n}\n";
    public static final String SNOW_SOIL = "{\n  \"bookshelf:load_conditions\": [\n    {\n      \"type\": \"bookshelf:item_exists\",\n      \"values\": [\n        \"$item_id$\"\n      ]\n    }\n  ],\n  \"type\": \"botanypots:soil\",\n  \"input\": {\n    \"item\": \"$item_id$\"\n  },\n  \"display\": {\n    \"type\": \"botanypots:simple\",\n    \"block_state\": {\n      \"block\": \"minecraft:snow_block\"\n    }\n  }\n}\n";
    public static final String BLOCK_SOIL = "{\n  \"bookshelf:load_conditions\": [\n    {\n      \"type\": \"bookshelf:block_exists\",\n      \"values\": [\n        \"$block_id$\"\n      ]\n    }\n  ],\n  \"type\": \"botanypots:block_derived_soil\",\n  \"block\": \"$block_id$\"\n}\n";

    public static void build(LiteralArgumentBuilder<CommandSourceStack> parent) {
        LiteralArgumentBuilder cmd = Commands.literal((String)"missing");
        LiteralArgumentBuilder seeds = Commands.literal((String)"seeds");
        seeds.executes(MissingCommand::dumpMissingCrops);
        seeds.then(((RequiredArgumentBuilder)Commands.argument((String)"include_saplings", (ArgumentType)BoolArgumentType.bool()).executes(MissingCommand::dumpMissingCrops)).then(Commands.argument((String)"generate", (ArgumentType)BoolArgumentType.bool()).executes(MissingCommand::dumpMissingCrops)));
        cmd.then((ArgumentBuilder)seeds);
        LiteralArgumentBuilder soils = Commands.literal((String)"soils");
        soils.executes(MissingCommand::dumpMissingSoils);
        soils.then(Commands.argument((String)"generate", (ArgumentType)BoolArgumentType.bool()).executes(MissingCommand::dumpMissingSoils));
        cmd.then((ArgumentBuilder)soils);
        parent.then((ArgumentBuilder)cmd);
    }

    private static int dumpMissingSoils(CommandContext<CommandSourceStack> ctx) {
        ServerLevel level = ((CommandSourceStack)ctx.getSource()).getLevel();
        boolean generate = CommandHelper.getBooleanArg((String)"generate", ctx, () -> false);
        HashSet<Item> missing = new HashSet<Item>();
        for (Item item : BuiltInRegistries.ITEM) {
            ItemStack stack = item.getDefaultInstance();
            if (MissingCommand.isSoil(stack, (Level)level)) continue;
            for (RecipeHolder crop : Objects.requireNonNull((Map)Crop.RECIPES.apply((Level)level)).values()) {
                BasicCrop basic;
                Recipe recipe = crop.value();
                if (!(recipe instanceof BasicCrop) || !(basic = (BasicCrop)recipe).isValidSoil(stack)) continue;
                missing.add(item);
            }
        }
        MissingCommand.addMissingSoils(level, SOIL_WATER, missing);
        MissingCommand.addMissingSoils(level, SOIL_LAVA, missing);
        MissingCommand.addMissingSoils(level, SOIL_SNOW, missing);
        if (missing.isEmpty()) {
            ((CommandSourceStack)ctx.getSource()).sendSuccess(() -> BotanyPotsCommands.modMessage((Component)Component.translatable((String)"commands.botanypots.dump.no_results")), false);
            return 0;
        }
        if (generate) {
            MissingCommand.generateMissingSoils(level, missing);
        }
        StringJoiner entries = new StringJoiner(System.lineSeparator());
        entries.add("Potential missing soil IDs");
        missing.stream().map(arg_0 -> ((DefaultedRegistry)BuiltInRegistries.ITEM).getKey(arg_0)).sorted(Comparator.comparing(ResourceLocation::toString)).forEach(entry -> entries.add(entry.toString()));
        ((CommandSourceStack)ctx.getSource()).sendSuccess(() -> BotanyPotsCommands.modMessage((Component)Component.translatable((String)"commands.botanypots.dump.missing_soils", (Object[])new Object[]{Component.literal((String)Integer.toString(missing.size())).withStyle(style -> style.withColor(ChatFormatting.RED))}).withStyle(style -> style.withClickEvent(new ClickEvent(ClickEvent.Action.COPY_TO_CLIPBOARD, entries.toString())))), false);
        return 0;
    }

    private static void generateMissingSoils(ServerLevel level, Set<Item> missing) {
        File outDir = MissingCommand.setupDir("botanypots/generated/soils");
        for (Item item : missing) {
            ResourceLocation itemId = BuiltInRegistries.ITEM.getKey((Object)item);
            File soilFile = new File(outDir, itemId.getNamespace() + "/" + itemId.getPath() + ".json");
            ItemStack stack = item.getDefaultInstance();
            if (stack.is(SOIL_WATER)) {
                MissingCommand.writeFile(soilFile, WATER_SOIL.replace("$item_id$", itemId.toString()));
                continue;
            }
            if (stack.is(SOIL_SNOW)) {
                MissingCommand.writeFile(soilFile, SNOW_SOIL.replace("$item_id$", itemId.toString()));
                continue;
            }
            if (!(item instanceof BlockItem)) continue;
            BlockItem blockItem = (BlockItem)item;
            MissingCommand.writeFile(soilFile, BLOCK_SOIL.replace("$item_id$", itemId.toString()).replace("$block_id$", BuiltInRegistries.BLOCK.getKey((Object)blockItem.getBlock()).toString()));
        }
    }

    private static int dumpMissingCrops(CommandContext<CommandSourceStack> ctx) {
        boolean includeSaplings = CommandHelper.getBooleanArg((String)"include_saplings", ctx, () -> false);
        boolean generate = CommandHelper.getBooleanArg((String)"generate", ctx, () -> false);
        Set<ResourceLocation> missingCrops = MissingCommand.getMissingCrops((Level)((CommandSourceStack)ctx.getSource()).getLevel(), includeSaplings);
        if (missingCrops.isEmpty()) {
            ((CommandSourceStack)ctx.getSource()).sendSuccess(() -> BotanyPotsCommands.modMessage((Component)Component.translatable((String)"commands.botanypots.dump.no_results")), false);
            return 0;
        }
        if (generate) {
            File outdir = MissingCommand.setupDir("botanypots/generated/crops");
            for (ResourceLocation itemId : missingCrops) {
                Item item = (Item)BuiltInRegistries.ITEM.get(itemId);
                if (!(item instanceof BlockItem)) continue;
                BlockItem blockItem = (BlockItem)item;
                ResourceLocation blockId = BuiltInRegistries.BLOCK.getKey((Object)blockItem.getBlock());
                try (FileWriter writer = new FileWriter(new File(outdir, blockId.getPath() + ".json"));){
                    writer.append(SEED_TEMPLATE.replace("$block_id$", blockId.toString()));
                }
                catch (IOException e) {
                    BotanyPotsMod.LOG.error("Failed to generate crop for item {}.", (Object)itemId, (Object)e);
                }
            }
            ((CommandSourceStack)ctx.getSource()).sendSuccess(() -> Component.translatable((String)"commands.botanypots.dump.generated").withStyle(style -> style.withClickEvent(new ClickEvent(ClickEvent.Action.OPEN_FILE, outdir.getAbsolutePath()))), false);
        } else {
            StringJoiner entries = new StringJoiner(System.lineSeparator());
            entries.add("Potential missing crop IDs");
            missingCrops.forEach(entry -> entries.add(entry.toString()));
            ((CommandSourceStack)ctx.getSource()).sendSuccess(() -> BotanyPotsCommands.modMessage((Component)Component.translatable((String)"commands.botanypots.dump.missing_crops", (Object[])new Object[]{Component.literal((String)Integer.toString(missingCrops.size())).withStyle(style -> style.withColor(ChatFormatting.RED))}).withStyle(style -> style.withClickEvent(new ClickEvent(ClickEvent.Action.COPY_TO_CLIPBOARD, entries.toString())))), false);
        }
        return 0;
    }

    private static Set<ResourceLocation> getMissingCrops(Level level, boolean includeSaplings) {
        HashSet<Item> missingSeedItems = new HashSet<Item>();
        block0: for (Item item2 : BuiltInRegistries.ITEM) {
            if (MissingCommand.isCrop(item2.getDefaultInstance(), level) || MissingCommand.isSoil(item2.getDefaultInstance(), level) || !(item2 instanceof BlockItem)) continue;
            BlockItem itemBlock = (BlockItem)item2;
            Block placedBlock = itemBlock.getBlock();
            ResourceLocation blockId = BuiltInRegistries.BLOCK.getKey((Object)placedBlock);
            if (placedBlock instanceof CropBlock || placedBlock instanceof GrowingPlantBlock || placedBlock instanceof BonemealableBlock || placedBlock instanceof SaplingBlock || placedBlock instanceof BushBlock || placedBlock instanceof SporeBlossomBlock || placedBlock instanceof BaseCoralPlantTypeBlock && !blockId.getPath().startsWith("dead_")) {
                missingSeedItems.add(item2);
                continue;
            }
            for (Property property : placedBlock.getStateDefinition().getProperties()) {
                if (!property.getName().equalsIgnoreCase("age")) continue;
                missingSeedItems.add(item2);
                continue block0;
            }
        }
        Consumer<Item> tagProcessor = item -> {
            if (!MissingCommand.isCrop(item.getDefaultInstance(), level) && !MissingCommand.isSoil(item.getDefaultInstance(), level)) {
                missingSeedItems.add((Item)item);
            }
        };
        MissingCommand.processTag(FORGE_SEEDS, tagProcessor);
        MissingCommand.processTag(COMMON_SEEDS, tagProcessor);
        return missingSeedItems.stream().filter(item -> (includeSaplings || !MissingCommand.isSapling(item)) && !Objects.requireNonNull((Set)IGNORED_ITEMS.apply(level)).contains(item)).map(arg_0 -> ((DefaultedRegistry)BuiltInRegistries.ITEM).getKey(arg_0)).sorted(ID_COMPARE).collect(Collectors.toCollection(LinkedHashSet::new));
    }

    private static void processTag(TagKey<Item> key, Consumer<Item> consumer) {
        BuiltInRegistries.ITEM.getTag(key).ifPresent(named -> named.forEach(entry -> consumer.accept((Item)entry.value())));
    }

    private static boolean isCrop(ItemStack stack, Level level) {
        return Objects.requireNonNull((RecipeCache)Crop.CACHE.apply(level)).isCached(stack);
    }

    private static boolean isSoil(ItemStack stack, Level level) {
        return Objects.requireNonNull((RecipeCache)Soil.CACHE.apply(level)).isCached(stack);
    }

    private static boolean isFertilizer(ItemStack stack, Level level) {
        return Objects.requireNonNull((RecipeCache)Fertilizer.CACHE.apply(level)).isCached(stack);
    }

    private static boolean isSapling(Item item) {
        BlockItem blockItem;
        return item instanceof BlockItem && (blockItem = (BlockItem)item).getBlock() instanceof SaplingBlock;
    }

    private static void addMissingSoils(ServerLevel level, TagKey<Item> tag, Collection<Item> items) {
        MissingCommand.addFromTag(tag, items, item -> !MissingCommand.isSoil(item.getDefaultInstance(), (Level)level));
    }

    private static void addFromTag(TagKey<Item> tag, Collection<Item> items, Predicate<Item> test) {
        for (Holder entry : BuiltInRegistries.ITEM.getTagOrEmpty(tag)) {
            if (!test.test((Item)entry.value())) continue;
            items.add((Item)entry.value());
        }
    }

    private static void writeFile(File file, String text) {
        if (!file.getParentFile().exists()) {
            file.getParentFile().mkdirs();
        }
        try (FileWriter writer = new FileWriter(file);){
            writer.append(text);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static File setupDir(String dir) {
        File file = new File(dir);
        if (file.exists()) {
            try {
                FileUtils.deleteDirectory((File)file);
            }
            catch (Exception e) {
                BotanyPotsMod.LOG.error("Failed to setup dir {}.", (Object)dir, (Object)e);
            }
        }
        file.mkdirs();
        return file;
    }
}

