/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.botanypots.common.impl.block.menu;

import java.util.Objects;
import net.darkhax.bookshelf.common.api.function.CachedSupplier;
import net.darkhax.bookshelf.common.api.menu.data.BlockPosData;
import net.darkhax.bookshelf.common.api.menu.slot.InputSlot;
import net.darkhax.bookshelf.common.api.menu.slot.OutputSlot;
import net.darkhax.botanypots.common.api.data.context.BlockEntityContext;
import net.darkhax.botanypots.common.api.data.recipes.RecipeCache;
import net.darkhax.botanypots.common.api.data.recipes.crop.Crop;
import net.darkhax.botanypots.common.api.data.recipes.soil.Soil;
import net.darkhax.botanypots.common.impl.BotanyPotsMod;
import net.darkhax.botanypots.common.impl.block.entity.BotanyPotBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.SimpleContainerData;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BotanyPotMenu
extends AbstractContainerMenu {
    public static final ResourceLocation EMPTY_SLOT_SOIL = BotanyPotsMod.id("item/empty_slot_soil");
    public static final ResourceLocation EMPTY_SLOT_SEED = BotanyPotsMod.id("item/empty_slot_seed");
    public static final ResourceLocation EMPTY_SLOT_HOE = ResourceLocation.withDefaultNamespace((String)"item/empty_slot_hoe");
    public static final CachedSupplier<MenuType<BotanyPotMenu>> BASIC_MENU = CachedSupplier.cache(() -> (MenuType)BuiltInRegistries.MENU.get(BotanyPotsMod.id("basic_pot_menu"))).cast();
    public static final CachedSupplier<MenuType<BotanyPotMenu>> HOPPER_MENU = CachedSupplier.cache(() -> (MenuType)BuiltInRegistries.MENU.get(BotanyPotsMod.id("hopper_pot_menu"))).cast();
    public static final TagKey<Item> HARVEST_ITEM = TagKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)BotanyPotsMod.id("harvest_items"));
    private final Level level;
    private final Container potContainer;
    private final Inventory playerInv;
    private final ContainerData blockPos;
    protected final boolean isHopper;

    public static BotanyPotMenu basicMenuClient(int containerId, Inventory playerInv) {
        return new BotanyPotMenu((MenuType)BASIC_MENU.get(), containerId, playerInv, (Container)new SimpleContainer(2), false, (ContainerData)new SimpleContainerData(3));
    }

    public static BotanyPotMenu hopperMenuClient(int containerId, Inventory playerInv) {
        return new BotanyPotMenu((MenuType)HOPPER_MENU.get(), containerId, playerInv, (Container)new SimpleContainer(15), true, (ContainerData)new SimpleContainerData(3));
    }

    public static BotanyPotMenu potMenuServer(int containerId, Inventory playerInv, BotanyPotBlockEntity pot) {
        return new BotanyPotMenu(pot.isHopper() ? (MenuType)HOPPER_MENU.get() : (MenuType)BASIC_MENU.get(), containerId, playerInv, (Container)pot, pot.isHopper(), (ContainerData)new BlockPosData(pot.getBlockPos()));
    }

    public BotanyPotMenu(MenuType<?> menuType, int id, Inventory playerInv, Container potContainer, boolean isHopper, ContainerData data) {
        super(menuType, id);
        this.level = playerInv.player.level();
        this.playerInv = playerInv;
        this.potContainer = potContainer;
        this.isHopper = isHopper;
        this.blockPos = data;
        this.addDataSlots(this.blockPos);
        int slotXOffset = isHopper ? 44 : 80;
        this.addSlot((Slot)new InputSlot(potContainer, 0, slotXOffset, 48, EMPTY_SLOT_SOIL));
        this.addSlot((Slot)new InputSlot(potContainer, 1, slotXOffset, 22, EMPTY_SLOT_SEED));
        if (isHopper) {
            this.addSlot((Slot)new InputSlot(potContainer, 2, 18, 35, EMPTY_SLOT_HOE, stack -> stack.is(HARVEST_ITEM)));
        }
        if (isHopper) {
            for (int potOutputY = 0; potOutputY < 3; ++potOutputY) {
                for (int potOutputX = 0; potOutputX < 4; ++potOutputX) {
                    int slotId = 3 + (potOutputX + potOutputY * 4);
                    int slotX = 80 + potOutputX * 18;
                    int slotY = 17 + potOutputY * 18;
                    this.addSlot((Slot)new OutputSlot(potContainer, slotId, slotX, slotY));
                }
            }
        }
        for (int playerInvY = 0; playerInvY < 3; ++playerInvY) {
            for (int playerInvX = 0; playerInvX < 9; ++playerInvX) {
                this.addSlot(new Slot((Container)playerInv, playerInvX + playerInvY * 9 + 9, 8 + playerInvX * 18, 84 + playerInvY * 18));
            }
        }
        for (int hotbarX = 0; hotbarX < 9; ++hotbarX) {
            this.addSlot(new Slot((Container)playerInv, hotbarX, 8 + hotbarX * 18, 142));
        }
    }

    @NotNull
    public ItemStack quickMoveStack(@NotNull Player player, int slotId) {
        BlockEntityContext context = this.getContext();
        Slot slot = (Slot)this.slots.get(slotId);
        if (context == null) {
            return slot.hasItem() ? slot.getItem() : ItemStack.EMPTY;
        }
        int firstSlot = this.isHopper ? 14 : 2;
        int lastSlot = this.isHopper ? 50 : 38;
        ItemStack unmovedItems = ItemStack.EMPTY;
        if (slot.hasItem()) {
            ItemStack slotStack = slot.getItem();
            unmovedItems = slotStack.copy();
            if (this.isHopper && slotId > 2 && slotId <= 15) {
                if (!this.moveItemStackTo(slotStack, firstSlot, lastSlot, true)) {
                    return ItemStack.EMPTY;
                }
                slot.onQuickCraft(slotStack, unmovedItems);
            } else if (slotId == 0 || slotId == 1 || slotId == 2) {
                if (!this.moveItemStackTo(slotStack, firstSlot, lastSlot, true)) {
                    return ItemStack.EMPTY;
                }
            } else if (slotId >= firstSlot && slotId <= lastSlot) {
                Slot cropSlot;
                Slot soilSlot;
                Slot toolSlot = (Slot)this.slots.get(2);
                if (!toolSlot.hasItem() && slotStack.is(HARVEST_ITEM)) {
                    toolSlot.set(slotStack.split(1));
                    slot.set(slotStack);
                    if (slotStack.isEmpty()) {
                        return ItemStack.EMPTY;
                    }
                }
                if (!(soilSlot = (Slot)this.slots.get(0)).hasItem() && Objects.requireNonNull((RecipeCache)Soil.CACHE.apply(this.level)).lookup(slotStack, context, player.level()) != null) {
                    soilSlot.set(slotStack.split(1));
                    slot.set(slotStack);
                    if (slotStack.isEmpty()) {
                        return ItemStack.EMPTY;
                    }
                }
                if (!(cropSlot = (Slot)this.slots.get(1)).hasItem() && Objects.requireNonNull((RecipeCache)Crop.CACHE.apply(this.level)).lookup(slotStack, context, player.level()) != null) {
                    cropSlot.set(slotStack.split(1));
                    slot.set(slotStack);
                    if (slotStack.isEmpty()) {
                        return ItemStack.EMPTY;
                    }
                }
            }
            if (slotStack.isEmpty()) {
                slot.set(ItemStack.EMPTY);
            } else {
                slot.setChanged();
            }
            if (slotStack.getCount() == unmovedItems.getCount()) {
                return ItemStack.EMPTY;
            }
            slot.onTake(player, slotStack);
        }
        return unmovedItems;
    }

    public boolean stillValid(@NotNull Player player) {
        return this.potContainer.stillValid(player);
    }

    @Nullable
    public BlockEntityContext getContext() {
        BlockEntityContext blockEntityContext;
        BlockPos blockPos;
        ContainerData containerData = this.blockPos;
        if (containerData instanceof BlockPosData) {
            BlockPosData posData = (BlockPosData)containerData;
            blockPos = posData.getPos();
        } else {
            blockPos = BlockPosData.readPos((ContainerData)this.blockPos);
        }
        BlockPos pos = blockPos;
        containerData = this.playerInv.player.level().getBlockEntity(pos);
        if (containerData instanceof BotanyPotBlockEntity) {
            BotanyPotBlockEntity pot = (BotanyPotBlockEntity)containerData;
            blockEntityContext = pot.getRecipeContext();
        } else {
            blockEntityContext = null;
        }
        return blockEntityContext;
    }
}

