/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.botanypots.common.impl;

import com.mojang.serialization.Codec;
import io.netty.buffer.ByteBuf;
import java.util.Optional;
import net.darkhax.bookshelf.common.api.data.codecs.stream.StreamCodecs;
import net.darkhax.bookshelf.common.api.data.enchantment.EnchantmentLevel;
import net.darkhax.bookshelf.common.api.util.DataHelper;
import net.darkhax.bookshelf.common.api.util.MathsHelper;
import net.darkhax.botanypots.common.api.data.context.BotanyPotContext;
import net.darkhax.botanypots.common.api.data.recipes.crop.Crop;
import net.darkhax.botanypots.common.api.data.recipes.soil.Soil;
import net.darkhax.botanypots.common.impl.BotanyPotsMod;
import net.darkhax.botanypots.common.impl.config.Config;
import net.minecraft.ChatFormatting;
import net.minecraft.core.DefaultedRegistry;
import net.minecraft.core.IdMap;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

public class Helpers {
    public static final Codec<Block> BLOCK_CODEC = ResourceLocation.CODEC.xmap(arg_0 -> ((DefaultedRegistry)BuiltInRegistries.BLOCK).get(arg_0), arg_0 -> ((DefaultedRegistry)BuiltInRegistries.BLOCK).getKey(arg_0));
    public static final StreamCodec<ByteBuf, Block> BLOCK_STREAM = ResourceLocation.STREAM_CODEC.map(arg_0 -> ((DefaultedRegistry)BuiltInRegistries.BLOCK).get(arg_0), arg_0 -> ((DefaultedRegistry)BuiltInRegistries.BLOCK).getKey(arg_0));
    public static final Codec<Item> ITEM_CODEC = ResourceLocation.CODEC.xmap(arg_0 -> ((DefaultedRegistry)BuiltInRegistries.ITEM).get(arg_0), arg_0 -> ((DefaultedRegistry)BuiltInRegistries.ITEM).getKey(arg_0));
    public static final StreamCodec<ByteBuf, Item> ITEM_STREAM = ResourceLocation.STREAM_CODEC.map(arg_0 -> ((DefaultedRegistry)BuiltInRegistries.ITEM).get(arg_0), arg_0 -> ((DefaultedRegistry)BuiltInRegistries.ITEM).getKey(arg_0));
    public static final Codec<EntityType<?>> ENTITY_TYPE_CODEC = ResourceLocation.CODEC.xmap(arg_0 -> ((DefaultedRegistry)BuiltInRegistries.ENTITY_TYPE).get(arg_0), arg_0 -> ((DefaultedRegistry)BuiltInRegistries.ENTITY_TYPE).getKey(arg_0));
    public static final StreamCodec<ByteBuf, EntityType<?>> ENTITY_TYPE_STREAM = ResourceLocation.STREAM_CODEC.map(arg_0 -> ((DefaultedRegistry)BuiltInRegistries.ENTITY_TYPE).get(arg_0), arg_0 -> ((DefaultedRegistry)BuiltInRegistries.ENTITY_TYPE).getKey(arg_0));
    public static final StreamCodec<ByteBuf, BlockState> BLOCK_STATE_STREAM = ByteBufCodecs.idMapper((IdMap)Block.BLOCK_STATE_REGISTRY);
    public static final StreamCodec<RegistryFriendlyByteBuf, Optional<Ingredient>> OPTIONAL_INGREDIENT_STREAM = DataHelper.optionalStream((StreamCodec)StreamCodecs.INGREDIENT_NON_EMPTY);
    public static final StreamCodec<RegistryFriendlyByteBuf, Optional<ItemStack>> OPTIONAL_ITEMSTACK_STREAM = DataHelper.optionalStream((StreamCodec)ItemStack.STREAM_CODEC);
    public static final TagKey<Enchantment> INCREASE_POT_GROWTH_TAG = TagKey.create((ResourceKey)Registries.ENCHANTMENT, (ResourceLocation)BotanyPotsMod.id("increase_pot_growth"));
    public static final TagKey<Enchantment> NEGATE_HARVEST_DAMAGE_TAG = TagKey.create((ResourceKey)Registries.ENCHANTMENT, (ResourceLocation)BotanyPotsMod.id("negate_harvest_damage"));

    public static Component growthModifierComponent(float modifier) {
        if (modifier > 0.0f) {
            return Component.translatable((String)"tooltip.botanypots.growth_modifier", (Object[])new Object[]{"+" + MathsHelper.DECIMAL_2.format((double)modifier * 100.0) + "%"}).withStyle(ChatFormatting.BLUE);
        }
        return Component.translatable((String)"tooltip.botanypots.growth_modifier", (Object[])new Object[]{"-" + MathsHelper.DECIMAL_2.format((double)modifier * 100.0) + "%"}).withStyle(ChatFormatting.RED);
    }

    public static int getRequiredGrowthTicks(BotanyPotContext context, Level level, Crop crop, @Nullable Soil soil) {
        float cropTime = crop.getRequiredGrowthTicks(context, level);
        float growthModifier = ((Config)BotanyPotsMod.CONFIG.get()).gameplay.global_growth_modifier;
        growthModifier += soil != null ? soil.getGrowthModifier(context, level) : 0.0f;
        return Mth.floor((float)(cropTime / (growthModifier += Helpers.efficiencyModifier(level.registryAccess(), context.getHarvestItem()))));
    }

    public static float efficiencyModifier(RegistryAccess registryAccess, ItemStack stack) {
        return (float)EnchantmentLevel.HIGHEST.get(INCREASE_POT_GROWTH_TAG, stack) * ((Config)BotanyPotsMod.CONFIG.get()).gameplay.efficiency_growth_modifier;
    }
}

