/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.botanypots.common.api.data.display.render;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.HashMap;
import java.util.Map;
import net.darkhax.botanypots.common.api.data.display.types.Display;
import net.darkhax.botanypots.common.api.data.display.types.DisplayType;
import net.darkhax.botanypots.common.impl.BotanyPotsMod;
import net.darkhax.botanypots.common.impl.block.entity.BotanyPotBlockEntity;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.Level;

public abstract class DisplayRenderer<T extends Display> {
    private static final Map<DisplayType<?>, DisplayRenderer<?>> RENDERERS = new HashMap();

    public static DisplayRenderer<?> getRenderer(Display state) {
        DisplayRenderer<?> renderer = RENDERERS.get(state.getType());
        if (renderer == null) {
            throw new IllegalStateException("Display state " + String.valueOf(state.getType().typeId()) + " is not bound to a renderer.");
        }
        return renderer;
    }

    public static float renderState(BlockEntityRendererProvider.Context context, Display displayState, PoseStack stack, Level level, BlockPos pos, float tickDelta, MultiBufferSource bufferSource, int light, int overlay, BotanyPotBlockEntity pot, float progress, float growthScale, float heightOffset) {
        return DisplayRenderer.getRenderer(displayState).render(context, displayState, stack, level, pos, tickDelta, bufferSource, light, overlay, pot, progress, growthScale, heightOffset);
    }

    public abstract float render(BlockEntityRendererProvider.Context var1, T var2, PoseStack var3, Level var4, BlockPos var5, float var6, MultiBufferSource var7, int var8, int var9, BotanyPotBlockEntity var10, float var11, float var12, float var13);

    public static <T extends Display> void bind(DisplayType<T> type, DisplayRenderer<T> renderer) {
        if (RENDERERS.containsKey(type)) {
            BotanyPotsMod.LOG.warn("Renderer already bound for type " + String.valueOf(type.typeId()) + ". Replacing " + RENDERERS.get(type).toString() + " with " + renderer.toString());
        }
        RENDERERS.put(type, renderer);
    }
}

