/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.botanypots.common.impl.data.itemdrops;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.darkhax.bookshelf.common.api.function.CachedSupplier;
import net.darkhax.bookshelf.common.api.loot.LootPoolEntryDescriptions;
import net.darkhax.botanypots.common.api.context.BotanyPotContext;
import net.darkhax.botanypots.common.api.data.itemdrops.ItemDropProvider;
import net.darkhax.botanypots.common.api.data.itemdrops.ItemDropProviderType;
import net.darkhax.botanypots.common.impl.BotanyPotsMod;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;

public class LootTableDrops
implements ItemDropProvider {
    public static final Supplier<ItemDropProviderType<?>> TYPE = ItemDropProviderType.getLazy(BotanyPotsMod.id("loot_table"));
    public static final MapCodec<LootTableDrops> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)ResourceLocation.CODEC.fieldOf("table_id").forGetter(LootTableDrops::getTableId)).apply((Applicative)instance, LootTableDrops::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, LootTableDrops> STREAM = StreamCodec.of((buf, val) -> {
        buf.writeResourceLocation(val.tableId);
        ItemStack.OPTIONAL_LIST_STREAM_CODEC.encode(buf, (Object)((List)val.displayItems.get()));
    }, buf -> {
        ResourceLocation tableId = buf.readResourceLocation();
        List items = (List)ItemStack.OPTIONAL_LIST_STREAM_CODEC.decode(buf);
        return new LootTableDrops(tableId, items);
    });
    private final ResourceLocation tableId;
    private final CachedSupplier<LootTable> cachedTable;
    private final CachedSupplier<List<ItemStack>> displayItems;

    public LootTableDrops(ResourceLocation tableId) {
        this.tableId = tableId;
        this.cachedTable = CachedSupplier.cache(() -> (LootTable)Objects.requireNonNull((RegistryAccess)BotanyPotsMod.REGISTRY_ACCESS.get()).registryOrThrow(Registries.LOOT_TABLE).get(ResourceKey.create((ResourceKey)Registries.LOOT_TABLE, (ResourceLocation)tableId)));
        this.displayItems = CachedSupplier.cache(() -> LootPoolEntryDescriptions.getUniqueItems((RegistryAccess)Objects.requireNonNull((RegistryAccess)BotanyPotsMod.REGISTRY_ACCESS.get()), (LootTable)((LootTable)this.cachedTable.get())));
    }

    public LootTableDrops(ResourceLocation tableId, List<ItemStack> displayItems) {
        this.tableId = tableId;
        this.cachedTable = CachedSupplier.singleton(null);
        this.displayItems = CachedSupplier.singleton(displayItems);
    }

    public ResourceLocation getTableId() {
        return this.tableId;
    }

    protected LootParams getLootParams(BotanyPotContext context) {
        return context.createLootParams(null);
    }

    @Override
    public void apply(BotanyPotContext context, Level level, Consumer<ItemStack> drops) {
        if (this.hasTableDrops()) {
            ((LootTable)this.cachedTable.get()).getRandomItems(this.getLootParams(context), drops);
        } else {
            this.fallbackDrops(context, level, drops);
        }
    }

    public void fallbackDrops(BotanyPotContext context, Level level, Consumer<ItemStack> drops) {
    }

    public boolean hasTableDrops() {
        LootTable table = (LootTable)this.cachedTable.get();
        return table != null && table != LootTable.EMPTY;
    }

    @Override
    public ItemDropProviderType<?> getType() {
        return TYPE.get();
    }

    @Override
    public List<ItemStack> getDisplayItems() {
        return (List)this.displayItems.get();
    }
}

