/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.botanypots.common.impl.data.display.types;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import net.darkhax.bookshelf.common.api.data.codecs.map.MapCodecs;
import net.darkhax.botanypots.common.api.data.display.math.AxisAlignedRotation;
import net.darkhax.botanypots.common.api.data.display.math.TintColor;
import net.darkhax.botanypots.common.api.data.display.types.RenderOptions;
import net.minecraft.core.Direction;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.util.ExtraCodecs;
import org.jetbrains.annotations.NotNull;
import org.joml.Vector3f;

public class BasicOptions
implements RenderOptions {
    public static Set<Direction> DEFAULT_FACES = Set.of(Direction.values());
    public static Vector3f DEFAULT_SCALE = new Vector3f(0.625f, 0.625f, 0.625f);
    public static Vector3f DEFAULT_OFFSET = new Vector3f(0.0f, 0.0f, 0.0f);
    public static final Codec<BasicOptions> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ExtraCodecs.VECTOR3F.optionalFieldOf("scale", (Object)DEFAULT_SCALE).forGetter(BasicOptions::getScale), (App)ExtraCodecs.VECTOR3F.optionalFieldOf("offset", (Object)DEFAULT_OFFSET).forGetter(BasicOptions::getOffset), (App)AxisAlignedRotation.CODEC_HELPER.getList("rotation", BasicOptions::getRotations, new ArrayList()), (App)MapCodecs.BOOLEAN.get("render_fluid", BasicOptions::shouldRenderFluid, (Object)false), (App)TintColor.CODEC.optionalFieldOf("color").forGetter(BasicOptions::getColor), (App)MapCodecs.flexibleSet((Codec)Direction.CODEC).optionalFieldOf("faces", DEFAULT_FACES).forGetter(BasicOptions::getFaces)).apply((Applicative)instance, BasicOptions::new));
    public static final StreamCodec<FriendlyByteBuf, BasicOptions> STREAM = new StreamCodec<FriendlyByteBuf, BasicOptions>(){

        public void encode(@NotNull FriendlyByteBuf buf, @NotNull BasicOptions state) {
            ByteBufCodecs.VECTOR3F.encode((Object)buf, (Object)state.scale);
            ByteBufCodecs.VECTOR3F.encode((Object)buf, (Object)state.offset);
            buf.writeCollection(state.rotations, AxisAlignedRotation.STREAM);
            buf.writeBoolean(state.renderFluid);
            buf.writeOptional(state.tintColor, TintColor.STREAM);
            buf.writeInt(state.faces.size());
            for (Direction face : state.faces) {
                buf.writeEnum((Enum)face);
            }
        }

        @NotNull
        public BasicOptions decode(@NotNull FriendlyByteBuf buf) {
            Vector3f scale = (Vector3f)ByteBufCodecs.VECTOR3F.decode((Object)buf);
            Vector3f offset = (Vector3f)ByteBufCodecs.VECTOR3F.decode((Object)buf);
            List rotations = buf.readList(AxisAlignedRotation.STREAM);
            boolean renderFluid = buf.readBoolean();
            Optional tintColor = buf.readOptional(TintColor.STREAM);
            HashSet<Direction> faces = new HashSet<Direction>();
            int faceSize = buf.readInt();
            for (int i = 0; i < faceSize; ++i) {
                faces.add((Direction)buf.readEnum(Direction.class));
            }
            return new BasicOptions(scale, offset, rotations, renderFluid, tintColor, faces);
        }
    };
    private final Vector3f scale;
    private final Vector3f offset;
    private final List<AxisAlignedRotation> rotations;
    private final boolean renderFluid;
    private final Optional<TintColor> tintColor;
    private final Set<Direction> faces;

    public BasicOptions(Vector3f scale, Vector3f offset, List<AxisAlignedRotation> rotations, boolean renderFluid, Optional<TintColor> tintColor, Set<Direction> faces) {
        this.scale = scale;
        this.offset = offset;
        this.rotations = rotations;
        this.renderFluid = renderFluid;
        this.tintColor = tintColor;
        this.faces = faces;
    }

    @Override
    public Vector3f getScale() {
        return this.scale;
    }

    @Override
    public Vector3f getOffset() {
        return this.offset;
    }

    @Override
    public List<AxisAlignedRotation> getRotations() {
        return this.rotations;
    }

    @Override
    public boolean shouldRenderFluid() {
        return this.renderFluid;
    }

    @Override
    public Optional<TintColor> getColor() {
        return this.tintColor;
    }

    @Override
    public Set<Direction> getFaces() {
        return this.faces;
    }

    public static BasicOptions ofDefault() {
        return BasicOptions.ofDefault(DEFAULT_FACES);
    }

    public static BasicOptions ofDefault(Set<Direction> faces) {
        return new BasicOptions(DEFAULT_SCALE, DEFAULT_OFFSET, List.of(), false, Optional.empty(), faces);
    }
}

