/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.botanypots.common.impl.commands;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.darkhax.bookshelf.common.api.function.CachedSupplier;
import net.darkhax.bookshelf.common.api.util.CommandHelper;
import net.darkhax.botanypots.common.api.data.recipes.RecipeCache;
import net.darkhax.botanypots.common.api.data.recipes.crop.Crop;
import net.darkhax.botanypots.common.impl.BotanyPotsMod;
import net.darkhax.botanypots.common.impl.block.entity.BotanyPotBlockEntity;
import net.darkhax.botanypots.common.impl.data.recipe.crop.BasicCrop;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.coordinates.BlockPosArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;

public class PlaceCrops {
    public static final List<Supplier<Block>> pots = List.of(CachedSupplier.of((Registry)BuiltInRegistries.BLOCK, (ResourceLocation)BotanyPotsMod.id("red_concrete_waxed_botany_pot")), CachedSupplier.of((Registry)BuiltInRegistries.BLOCK, (ResourceLocation)BotanyPotsMod.id("orange_concrete_waxed_botany_pot")), CachedSupplier.of((Registry)BuiltInRegistries.BLOCK, (ResourceLocation)BotanyPotsMod.id("yellow_concrete_waxed_botany_pot")), CachedSupplier.of((Registry)BuiltInRegistries.BLOCK, (ResourceLocation)BotanyPotsMod.id("lime_concrete_waxed_botany_pot")), CachedSupplier.of((Registry)BuiltInRegistries.BLOCK, (ResourceLocation)BotanyPotsMod.id("green_concrete_waxed_botany_pot")), CachedSupplier.of((Registry)BuiltInRegistries.BLOCK, (ResourceLocation)BotanyPotsMod.id("cyan_concrete_waxed_botany_pot")), CachedSupplier.of((Registry)BuiltInRegistries.BLOCK, (ResourceLocation)BotanyPotsMod.id("light_blue_concrete_waxed_botany_pot")), CachedSupplier.of((Registry)BuiltInRegistries.BLOCK, (ResourceLocation)BotanyPotsMod.id("blue_concrete_waxed_botany_pot")), CachedSupplier.of((Registry)BuiltInRegistries.BLOCK, (ResourceLocation)BotanyPotsMod.id("purple_concrete_waxed_botany_pot")), CachedSupplier.of((Registry)BuiltInRegistries.BLOCK, (ResourceLocation)BotanyPotsMod.id("magenta_concrete_waxed_botany_pot")), CachedSupplier.of((Registry)BuiltInRegistries.BLOCK, (ResourceLocation)BotanyPotsMod.id("pink_concrete_waxed_botany_pot")));

    public static void build(LiteralArgumentBuilder<CommandSourceStack> parent) {
        LiteralArgumentBuilder cmd = Commands.literal((String)"place_seeds");
        cmd.executes(PlaceCrops::execute);
        cmd.then(((RequiredArgumentBuilder)Commands.argument((String)"pos", (ArgumentType)BlockPosArgument.blockPos()).executes(PlaceCrops::execute)).then(Commands.argument((String)"all_soils", (ArgumentType)BoolArgumentType.bool()).executes(PlaceCrops::execute)));
        parent.then((ArgumentBuilder)cmd);
    }

    private static int execute(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        BlockPos.MutableBlockPos mutable = CommandHelper.hasArgument((String)"pos", ctx) ? BlockPosArgument.getLoadedBlockPos(ctx, (String)"pos").mutable() : ((CommandSourceStack)ctx.getSource()).getPlayerOrException().getOnPos().mutable();
        boolean allSoils = CommandHelper.hasArgument((String)"all_soils", ctx) && BoolArgumentType.getBool(ctx, (String)"all_soils");
        ServerLevel level = ((CommandSourceStack)ctx.getSource()).getLevel();
        int count = 0;
        for (Map.Entry crop : Objects.requireNonNull((RecipeCache)Crop.CACHE.apply((Level)((CommandSourceStack)ctx.getSource()).getLevel())).getCachedValues().entries().stream().sorted(Comparator.comparing(s -> BuiltInRegistries.ITEM.getKey((Object)((Item)s.getKey())).toString())).collect(Collectors.toCollection(LinkedHashSet::new))) {
            if (allSoils) {
                for (ItemStack soilStack : PlaceCrops.findAllSoils((Crop)((RecipeHolder)crop.getValue()).value())) {
                    level.setBlock((BlockPos)mutable, pots.get(count).get().defaultBlockState(), 3);
                    BlockEntity blockEntity = level.getBlockEntity((BlockPos)mutable);
                    if (blockEntity instanceof BotanyPotBlockEntity) {
                        BotanyPotBlockEntity pot = (BotanyPotBlockEntity)blockEntity;
                        pot.setItem(0, soilStack);
                        pot.setItem(1, ((Item)crop.getKey()).getDefaultInstance());
                        pot.updateGrowthTime(pot.getRequiredGrowthTicks());
                    }
                    mutable.move(Direction.NORTH);
                    if (++count != pots.size()) continue;
                    count = 0;
                    mutable.move(Direction.SOUTH, pots.size());
                    mutable.move(Direction.EAST);
                }
                continue;
            }
            level.setBlock((BlockPos)mutable, pots.get(count).get().defaultBlockState(), 3);
            BlockEntity blockEntity = level.getBlockEntity((BlockPos)mutable);
            if (blockEntity instanceof BotanyPotBlockEntity) {
                BotanyPotBlockEntity pot = (BotanyPotBlockEntity)blockEntity;
                pot.setItem(0, PlaceCrops.findFirstSoil((Crop)((RecipeHolder)crop.getValue()).value()));
                pot.setItem(1, ((Item)crop.getKey()).getDefaultInstance());
                pot.updateGrowthTime(pot.getRequiredGrowthTicks());
            }
            mutable.move(Direction.NORTH);
            if (++count != pots.size()) continue;
            count = 0;
            mutable.move(Direction.SOUTH, pots.size());
            mutable.move(Direction.EAST);
        }
        return 0;
    }

    private static List<ItemStack> findAllSoils(Crop crop) {
        ArrayList<ItemStack> items = new ArrayList<ItemStack>();
        if (crop instanceof BasicCrop) {
            BasicCrop basic = (BasicCrop)crop;
            for (Item item : BuiltInRegistries.ITEM) {
                ItemStack stack = item.getDefaultInstance();
                if (!basic.getBasicProperties().soil().test(stack)) continue;
                items.add(stack);
            }
        }
        return items;
    }

    private static ItemStack findFirstSoil(Crop crop) {
        if (crop instanceof BasicCrop) {
            BasicCrop basic = (BasicCrop)crop;
            for (Item item : BuiltInRegistries.ITEM) {
                ItemStack stack = item.getDefaultInstance();
                if (!basic.getBasicProperties().soil().test(stack)) continue;
                return stack;
            }
        }
        return ItemStack.EMPTY;
    }
}

