/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.botanypots.common.impl.data.recipe.crop;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import net.darkhax.bookshelf.common.api.data.codecs.map.MapCodecs;
import net.darkhax.bookshelf.common.api.data.codecs.stream.StreamCodecs;
import net.darkhax.bookshelf.common.api.util.DataHelper;
import net.darkhax.botanypots.common.api.context.BlockEntityContext;
import net.darkhax.botanypots.common.api.context.BotanyPotContext;
import net.darkhax.botanypots.common.api.data.display.types.Display;
import net.darkhax.botanypots.common.api.data.display.types.DisplayType;
import net.darkhax.botanypots.common.api.data.itemdrops.ItemDropProvider;
import net.darkhax.botanypots.common.api.data.itemdrops.ItemDropProviderType;
import net.darkhax.botanypots.common.api.data.recipes.CacheableRecipe;
import net.darkhax.botanypots.common.api.data.recipes.crop.Crop;
import net.darkhax.botanypots.common.impl.BotanyPotsMod;
import net.darkhax.botanypots.common.impl.Helpers;
import net.minecraft.ChatFormatting;
import net.minecraft.advancements.critereon.BlockPredicate;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.codec.StreamDecoder;
import net.minecraft.network.codec.StreamEncoder;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.TagKey;
import net.minecraft.util.StringUtil;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class BasicCrop
extends Crop
implements CacheableRecipe {
    public static final Ingredient DIRT = Ingredient.of((TagKey)TagKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)BotanyPotsMod.id("soil/dirt")));
    public static final MapCodec<BasicCrop> CODEC = Properties.CODEC.xmap(BasicCrop::new, BasicCrop::getBasicProperties);
    public static final StreamCodec<RegistryFriendlyByteBuf, BasicCrop> STREAM = Properties.STREAM.map(BasicCrop::new, BasicCrop::getBasicProperties);
    public static final RecipeSerializer<BasicCrop> SERIALIZER = DataHelper.recipeSerializer(CODEC, STREAM);
    public static final Component TOOLTIP_WRONG_SOIL = Component.translatable((String)"tooltip.botanypots.wrong_soil").withStyle(ChatFormatting.RED);
    private final Properties properties;

    public BasicCrop(Properties properties) {
        this.properties = properties;
    }

    public Properties getBasicProperties() {
        return this.properties;
    }

    public boolean matches(@NotNull BotanyPotContext input, @NotNull Level level) {
        if (input instanceof BlockEntityContext) {
            BlockEntityContext context = (BlockEntityContext)input;
            if (this.properties.potPredicate.isPresent() && !this.properties.potPredicate.get().matches(context.blockInWorld())) {
                return false;
            }
        }
        return this.properties.input.test(input.getSeedItem());
    }

    @Override
    public boolean couldMatch(ItemStack candidate, BotanyPotContext context, Level level) {
        return this.properties.input.test(candidate);
    }

    @Override
    public void onHarvest(BotanyPotContext context, Level level, Consumer<ItemStack> drops) {
        for (ItemDropProvider provider : this.properties.drops) {
            provider.apply(context, level, drops);
        }
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            this.properties.functionId.ifPresent(context::runFunction);
        }
    }

    @Override
    public List<Display> getDisplayState(BotanyPotContext context, Level level) {
        return this.properties.display;
    }

    @Override
    public int getRequiredGrowthTicks(BotanyPotContext context, Level level) {
        return this.properties.growTime;
    }

    @Override
    public boolean isGrowthSustained(BotanyPotContext context, Level level) {
        return this.properties.soil.test(context.getSoilItem());
    }

    @Override
    public boolean canBeCached() {
        return true;
    }

    @Override
    public boolean isCacheKey(ItemStack stack) {
        return this.properties.input.test(stack);
    }

    @NotNull
    public RecipeSerializer<?> getSerializer() {
        return SERIALIZER;
    }

    @Override
    public void hoverTooltip(ItemStack stack, BotanyPotContext context, Level level, Consumer<Component> tooltipLines) {
        if (stack == context.getItem(1)) {
            if (this.isGrowthSustained(context, level)) {
                tooltipLines.accept((Component)Component.translatable((String)"tooltip.botanypots.growth_time", (Object[])new Object[]{StringUtil.formatTickDuration((int)context.getRequiredGrowthTicks(), (float)level.tickRateManager().tickrate())}).withStyle(ChatFormatting.GRAY));
            }
            if (!this.properties.soil.test(context.getItem(0))) {
                tooltipLines.accept(TOOLTIP_WRONG_SOIL);
            }
            if (context instanceof BlockEntityContext) {
                BlockEntityContext beContext = (BlockEntityContext)context;
                if (this.properties.potPredicate.isPresent() && !this.properties.potPredicate.get().matches(beContext.blockInWorld())) {
                    tooltipLines.accept((Component)Component.translatable((String)"tooltip.botanypots.wrong_pot", (Object[])new Object[]{beContext.pot().getBlockState().getBlock().getName()}).withStyle(ChatFormatting.RED));
                }
            }
        } else {
            tooltipLines.accept((Component)Component.translatable((String)"tooltip.botanypots.growth_time", (Object[])new Object[]{StringUtil.formatTickDuration((int)this.properties.growTime, (float)level.tickRateManager().tickrate())}).withStyle(ChatFormatting.GRAY));
        }
    }

    public boolean isValidSoil(ItemStack stack) {
        return this.properties.soil.test(stack);
    }

    public record Properties(Ingredient input, Ingredient soil, int growTime, List<Display> display, int lightLevel, List<ItemDropProvider> drops, Optional<ResourceLocation> functionId, Optional<BlockPredicate> potPredicate) {
        public static final MapCodec<Properties> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Ingredient.CODEC.fieldOf("input").forGetter(Properties::input), (App)Ingredient.CODEC.optionalFieldOf("soil", (Object)DIRT).forGetter(Properties::soil), (App)Codec.intRange((int)1, (int)Integer.MAX_VALUE).optionalFieldOf("grow_time", (Object)1200).forGetter(Properties::growTime), (App)DisplayType.LIST_CODEC.fieldOf("display").forGetter(Properties::display), (App)Codec.intRange((int)0, (int)15).optionalFieldOf("light_level", (Object)0).forGetter(Properties::lightLevel), (App)MapCodecs.flexibleList(ItemDropProviderType.DROP_PROVIDER_CODEC).optionalFieldOf("drops", List.of()).forGetter(Properties::drops), (App)ResourceLocation.CODEC.optionalFieldOf("function").forGetter(Properties::functionId), (App)BlockPredicate.CODEC.optionalFieldOf("pot_predicate").forGetter(Properties::potPredicate)).apply((Applicative)instance, Properties::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, Properties> STREAM = new StreamCodec<RegistryFriendlyByteBuf, Properties>(){

            @NotNull
            public Properties decode(@NotNull RegistryFriendlyByteBuf buf) {
                Ingredient input = (Ingredient)StreamCodecs.INGREDIENT_NON_EMPTY.decode((Object)buf);
                Ingredient soil = (Ingredient)StreamCodecs.INGREDIENT_NON_EMPTY.decode((Object)buf);
                int growTime = (Integer)ByteBufCodecs.INT.decode((Object)buf);
                List display = buf.readList(DisplayType.DISPLAY_STATE_STREAM);
                int light = (Integer)ByteBufCodecs.INT.decode((Object)buf);
                Optional functionId = buf.readOptional((StreamDecoder)ResourceLocation.STREAM_CODEC);
                int dropSize = buf.readInt();
                LinkedList<ItemDropProvider> drops = new LinkedList<ItemDropProvider>();
                for (int i = 0; i < dropSize; ++i) {
                    drops.add((ItemDropProvider)ItemDropProviderType.DROP_PROVIDER_STREAM.decode((Object)buf));
                }
                Optional potPredicate = (Optional)Helpers.OPTIONAL_BLOCK_PREDICATE.decode((Object)buf);
                return new Properties(input, soil, growTime, display, light, drops, functionId, potPredicate);
            }

            public void encode(@NotNull RegistryFriendlyByteBuf buf, @NotNull Properties properties) {
                StreamCodecs.INGREDIENT_NON_EMPTY.encode((Object)buf, (Object)properties.input);
                StreamCodecs.INGREDIENT_NON_EMPTY.encode((Object)buf, (Object)properties.soil);
                ByteBufCodecs.INT.encode((Object)buf, (Object)properties.growTime);
                buf.writeCollection(properties.display, DisplayType.DISPLAY_STATE_STREAM);
                ByteBufCodecs.INT.encode((Object)buf, (Object)properties.lightLevel);
                buf.writeOptional(properties.functionId, (StreamEncoder)ResourceLocation.STREAM_CODEC);
                buf.writeInt(properties.drops.size());
                for (ItemDropProvider provider : properties.drops) {
                    ItemDropProviderType.DROP_PROVIDER_STREAM.encode((Object)buf, (Object)provider);
                }
                Helpers.OPTIONAL_BLOCK_PREDICATE.encode((Object)buf, properties.potPredicate);
            }
        };
    }
}

