/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.botanypots.common.impl.data.recipe.fertilizer;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Objects;
import java.util.Optional;
import net.darkhax.bookshelf.common.api.data.codecs.stream.StreamCodecs;
import net.darkhax.bookshelf.common.api.util.DataHelper;
import net.darkhax.bookshelf.common.api.util.FunctionHelper;
import net.darkhax.botanypots.common.api.context.BlockEntityContext;
import net.darkhax.botanypots.common.api.context.BotanyPotContext;
import net.darkhax.botanypots.common.api.data.SoundEffect;
import net.darkhax.botanypots.common.api.data.growthamount.GrowthAmount;
import net.darkhax.botanypots.common.api.data.growthamount.GrowthAmountType;
import net.darkhax.botanypots.common.api.data.recipes.CacheableRecipe;
import net.darkhax.botanypots.common.api.data.recipes.fertilizer.Fertilizer;
import net.darkhax.botanypots.common.impl.Helpers;
import net.minecraft.core.Holder;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.gameevent.GameEvent;
import org.jetbrains.annotations.NotNull;

public class BasicFertilizer
extends Fertilizer
implements CacheableRecipe {
    public static final MapCodec<BasicFertilizer> CODEC = Properties.CODEC.xmap(BasicFertilizer::new, BasicFertilizer::getProperties);
    public static final StreamCodec<RegistryFriendlyByteBuf, BasicFertilizer> STREAM = Properties.STREAM.map(BasicFertilizer::new, BasicFertilizer::getProperties);
    public static final RecipeSerializer<BasicFertilizer> SERIALIZER = DataHelper.recipeSerializer(CODEC, STREAM);
    private final Properties properties;

    public BasicFertilizer(Properties properties) {
        this.properties = properties;
    }

    public Properties getProperties() {
        return this.properties;
    }

    @Override
    public void apply(@NotNull BotanyPotContext input, @NotNull Level level) {
        BlockEntityContext context;
        if (input instanceof BlockEntityContext && (context = (BlockEntityContext)input).pot().canBonemeal() && level instanceof ServerLevel) {
            ServerLevel sLevel = (ServerLevel)level;
            int requiredGrowthTicks = context.getRequiredGrowthTicks();
            int maxBonemealableTicks = requiredGrowthTicks - 20;
            if (requiredGrowthTicks > 20 && context.pot().growthTime.getTicks() < (float)maxBonemealableTicks) {
                context.pot().growthTime.setTicks(Math.min(context.pot().growthTime.getTicks() + (float)this.properties.growthAmount.getAmount(context, level), (float)maxBonemealableTicks));
                context.pot().setBonemealCooldown(this.properties.cooldown);
                if (this.properties.spawnsParticles) {
                    level.levelEvent(2011, context.pot().getBlockPos(), 15);
                }
                if (this.properties.notifySculk) {
                    level.gameEvent((Entity)context.getPlayer(), (Holder)GameEvent.BLOCK_CHANGE, context.pot().getBlockPos());
                }
                if (!Objects.requireNonNull(context.player()).isCreative()) {
                    context.getInteractionItem().shrink(1);
                }
                this.properties.soundEffect.ifPresent(soundEffect -> soundEffect.playSound(sLevel, null, context.pot().getBlockPos()));
                context.pot().markUpdated();
            }
        }
    }

    public boolean matches(@NotNull BotanyPotContext input, @NotNull Level level) {
        return this.properties.heldItem.test(input.getInteractionItem()) && FunctionHelper.test(this.properties.soilIngredient, i -> i.test(input.getSoilItem())) && FunctionHelper.test(this.properties.seedIngredient, i -> i.test(input.getSeedItem()));
    }

    @Override
    public boolean canBeCached() {
        return true;
    }

    @Override
    public boolean isCacheKey(ItemStack stack) {
        return this.properties.heldItem.test(stack);
    }

    @NotNull
    public RecipeSerializer<?> getSerializer() {
        return SERIALIZER;
    }

    @Override
    public boolean couldMatch(ItemStack candidate, BotanyPotContext context, Level level) {
        return this.properties.heldItem.test(candidate);
    }

    public record Properties(Ingredient heldItem, Optional<Ingredient> soilIngredient, Optional<Ingredient> seedIngredient, GrowthAmount growthAmount, int cooldown, boolean spawnsParticles, boolean notifySculk, Optional<SoundEffect> soundEffect) {
        public static final MapCodec<Properties> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Ingredient.CODEC.fieldOf("held_item").forGetter(Properties::heldItem), (App)Ingredient.CODEC.optionalFieldOf("soil_item").forGetter(Properties::soilIngredient), (App)Ingredient.CODEC.optionalFieldOf("seed_item").forGetter(Properties::seedIngredient), (App)GrowthAmountType.GROWTH_AMOUNT_CODEC.fieldOf("growth").forGetter(Properties::growthAmount), (App)Codec.INT.optionalFieldOf("cooldown", (Object)20).forGetter(Properties::cooldown), (App)Codec.BOOL.optionalFieldOf("spawn_particles", (Object)true).forGetter(Properties::spawnsParticles), (App)Codec.BOOL.optionalFieldOf("notify_sculk", (Object)true).forGetter(Properties::notifySculk), (App)SoundEffect.CODEC.codec().optionalFieldOf("sound_effect").forGetter(Properties::soundEffect)).apply((Applicative)instance, Properties::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, Properties> STREAM = new StreamCodec<RegistryFriendlyByteBuf, Properties>(){

            @NotNull
            public Properties decode(@NotNull RegistryFriendlyByteBuf buf) {
                Ingredient heldItem = (Ingredient)StreamCodecs.INGREDIENT_NON_EMPTY.decode((Object)buf);
                Optional soil = (Optional)Helpers.OPTIONAL_INGREDIENT_STREAM.decode((Object)buf);
                Optional seed = (Optional)Helpers.OPTIONAL_INGREDIENT_STREAM.decode((Object)buf);
                GrowthAmount growth = (GrowthAmount)GrowthAmountType.GROWTH_AMOUNT_STREAM.decode((Object)buf);
                int cooldown = (Integer)ByteBufCodecs.INT.decode((Object)buf);
                boolean particles = buf.readBoolean();
                boolean sculk = buf.readBoolean();
                Optional soundEffect = (Optional)SoundEffect.OPTIONAL_STREAM.decode((Object)buf);
                return new Properties(heldItem, soil, seed, growth, cooldown, particles, sculk, soundEffect);
            }

            public void encode(@NotNull RegistryFriendlyByteBuf buf, @NotNull Properties properties) {
                StreamCodecs.INGREDIENT_NON_EMPTY.encode((Object)buf, (Object)properties.heldItem);
                Helpers.OPTIONAL_INGREDIENT_STREAM.encode((Object)buf, properties.soilIngredient);
                Helpers.OPTIONAL_INGREDIENT_STREAM.encode((Object)buf, properties.seedIngredient);
                GrowthAmountType.GROWTH_AMOUNT_STREAM.encode((Object)buf, (Object)properties.growthAmount);
                ByteBufCodecs.INT.encode((Object)buf, (Object)properties.cooldown);
                buf.writeBoolean(properties.spawnsParticles);
                buf.writeBoolean(properties.notifySculk);
                SoundEffect.OPTIONAL_STREAM.encode((Object)buf, properties.soundEffect);
            }
        };
    }
}

