/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.botanypots.common.impl.command.generator;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Map;
import java.util.Objects;
import net.darkhax.botanypots.common.api.command.generator.DataHelper;
import net.darkhax.botanypots.common.api.command.generator.soil.SoilGenerator;
import net.darkhax.botanypots.common.api.data.recipes.BotanyPotRecipe;
import net.darkhax.botanypots.common.api.data.recipes.crop.Crop;
import net.darkhax.botanypots.common.api.data.recipes.interaction.PotInteraction;
import net.darkhax.botanypots.common.impl.data.recipe.crop.BasicCrop;
import net.darkhax.botanypots.common.impl.data.recipe.interaction.BasicPotInteraction;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;

public class MissingSoilGenerator
implements SoilGenerator {
    @Override
    public boolean canGenerateSoil(Level level, ItemStack stack) {
        if (stack.getItem() instanceof BlockItem) {
            BotanyPotRecipe basic;
            Recipe recipe;
            for (RecipeHolder crop : Objects.requireNonNull((Map)Crop.RECIPES.apply(level)).values()) {
                recipe = crop.value();
                if (!(recipe instanceof BasicCrop) || !(basic = (BasicCrop)recipe).isValidSoil(stack)) continue;
                return true;
            }
            for (RecipeHolder interaction : Objects.requireNonNull((Map)PotInteraction.RECIPES.apply(level)).values()) {
                recipe = interaction.value();
                if (!(recipe instanceof BasicPotInteraction)) continue;
                basic = (BasicPotInteraction)recipe;
                Ingredient soilTest = ((BasicPotInteraction)basic).properties.soilTest().orElse(null);
                if (soilTest != null && !soilTest.isEmpty() && soilTest.test(stack)) {
                    return true;
                }
                ItemStack output = ((BasicPotInteraction)basic).properties.newSoil().orElse(ItemStack.EMPTY);
                if (output.isEmpty() || !ItemStack.isSameItemSameComponents((ItemStack)stack, (ItemStack)output)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public JsonObject generateData(Level level, ItemStack stack) {
        Block block = ((BlockItem)stack.getItem()).getBlock();
        JsonObject output = new JsonObject();
        output.add("bookshelf:load_conditions", (JsonElement)DataHelper.array(new JsonElement[]{DataHelper.requiresBlock(block)}));
        output.addProperty("type", "botanypots:block_derived_soil");
        output.addProperty("block", DataHelper.BLOCKS.getKey((Object)block).toString());
        return output;
    }
}

