/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.botanypots.common.impl.data.display.types;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.darkhax.bookshelf.common.api.function.CachedSupplier;
import net.darkhax.botanypots.common.api.data.display.types.Display;
import net.darkhax.botanypots.common.api.data.display.types.DisplayType;
import net.darkhax.botanypots.common.impl.BotanyPotsMod;
import net.darkhax.botanypots.common.impl.Helpers;
import net.darkhax.botanypots.common.impl.data.display.types.BasicOptions;
import net.darkhax.botanypots.common.impl.data.display.types.PhasedDisplayState;
import net.darkhax.botanypots.common.impl.data.display.types.SimpleDisplayState;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;

public class AgingDisplayState
extends PhasedDisplayState {
    public static final ResourceLocation TYPE_ID = BotanyPotsMod.id("aging");
    public static final CachedSupplier<DisplayType<AgingDisplayState>> TYPE = CachedSupplier.cache(() -> DisplayType.get(TYPE_ID));
    public static final MapCodec<AgingDisplayState> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Helpers.BLOCK_CODEC.fieldOf("block").forGetter(AgingDisplayState::getBlock), (App)BasicOptions.CODEC.optionalFieldOf("options", (Object)BasicOptions.ofDefault()).forGetter(AgingDisplayState::getRenderOptions)).apply((Applicative)instance, AgingDisplayState::new));
    public static final StreamCodec<FriendlyByteBuf, AgingDisplayState> STREAM = StreamCodec.composite(Helpers.BLOCK_STREAM, AgingDisplayState::getBlock, BasicOptions.STREAM, AgingDisplayState::getRenderOptions, AgingDisplayState::new);
    private final Block block;
    private final BasicOptions renderOptions;
    private final List<Display> phases;

    public AgingDisplayState(Block block, BasicOptions renderOptions) {
        this.block = block;
        this.renderOptions = renderOptions;
        this.phases = this.calculatePhases(block);
    }

    private List<Display> calculatePhases(Block block) {
        ArrayList<Display> phases = new ArrayList<Display>();
        if (block instanceof CropBlock) {
            CropBlock crop = (CropBlock)block;
            for (int cropStage = 0; cropStage < crop.getMaxAge(); ++cropStage) {
                try {
                    BlockState agedState = crop.getStateForAge(cropStage);
                    phases.add(new SimpleDisplayState(agedState, this.renderOptions));
                    continue;
                }
                catch (Exception e) {
                    BotanyPotsMod.LOG.error("Invalid crop age found! id={} block={} age={}", new Object[]{BuiltInRegistries.BLOCK.getKey((Object)block), block, cropStage});
                    BotanyPotsMod.LOG.error("Error: ", (Throwable)e);
                }
            }
        } else if (block.defaultBlockState().hasProperty((Property)BlockStateProperties.FLOWER_AMOUNT)) {
            Property flowerCount = block.getStateDefinition().getProperty("flower_amount");
            if (flowerCount instanceof IntegerProperty) {
                IntegerProperty property = (IntegerProperty)flowerCount;
                Iterator iterator = property.getPossibleValues().iterator();
                while (iterator.hasNext()) {
                    int amount = (Integer)iterator.next();
                    phases.add(new SimpleDisplayState((BlockState)block.defaultBlockState().setValue((Property)property, (Comparable)Integer.valueOf(amount)), this.renderOptions));
                }
            }
        } else {
            Property ageProperty = block.getStateDefinition().getProperty("age");
            if (ageProperty instanceof IntegerProperty) {
                IntegerProperty intProperty = (IntegerProperty)ageProperty;
                Iterator iterator = intProperty.getPossibleValues().iterator();
                while (iterator.hasNext()) {
                    int age = (Integer)iterator.next();
                    phases.add(new SimpleDisplayState((BlockState)block.defaultBlockState().setValue((Property)intProperty, (Comparable)Integer.valueOf(age)), this.renderOptions));
                }
            } else {
                phases.add(new SimpleDisplayState(block.defaultBlockState(), this.renderOptions));
            }
        }
        return phases;
    }

    public Block getBlock() {
        return this.block;
    }

    public BasicOptions getRenderOptions() {
        return this.renderOptions;
    }

    @Override
    public List<Display> getDisplayPhases() {
        return this.phases;
    }

    @Override
    public DisplayType<?> getType() {
        return (DisplayType)TYPE.get();
    }
}

