/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.botanypots.common.impl.block;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.HashMap;
import java.util.Map;
import net.darkhax.bookshelf.common.api.util.IRenderHelper;
import net.darkhax.botanypots.common.api.data.display.math.AxisAlignedRotation;
import net.darkhax.botanypots.common.api.data.display.render.DisplayRenderer;
import net.darkhax.botanypots.common.api.data.display.types.Display;
import net.darkhax.botanypots.common.api.data.recipes.crop.Crop;
import net.darkhax.botanypots.common.api.data.recipes.soil.Soil;
import net.darkhax.botanypots.common.impl.block.entity.BotanyPotBlockEntity;
import net.darkhax.botanypots.common.impl.data.display.types.BasicOptions;
import net.darkhax.botanypots.common.impl.data.display.types.SimpleDisplayState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BotanyPotRenderer
implements BlockEntityRenderer<BotanyPotBlockEntity> {
    private static final Map<Item, Display> DEFAULT_SOIL_DISPLAYS = new HashMap<Item, Display>();
    private final BlockEntityRendererProvider.Context renderContext;
    private final IRenderHelper helper;

    public BotanyPotRenderer(BlockEntityRendererProvider.Context ctx) {
        this.renderContext = ctx;
        this.helper = IRenderHelper.GET;
    }

    private static AxisAlignedRotation getRotationForFace(Direction facing) {
        return switch (facing) {
            case Direction.EAST -> AxisAlignedRotation.Y_90;
            case Direction.NORTH -> AxisAlignedRotation.Y_180;
            case Direction.WEST -> AxisAlignedRotation.Y_270;
            default -> AxisAlignedRotation.Y_0;
        };
    }

    public static void applyRotation(AxisAlignedRotation rotation, PoseStack pose) {
        pose.mulPose(rotation.rotation);
        pose.translate(rotation.offset.x(), rotation.offset.y(), rotation.offset.z());
    }

    private static boolean canRenderSoil(ItemStack stack, @Nullable RecipeHolder<Soil> soil) {
        return !stack.isEmpty() && (soil != null || stack.getItem() instanceof BlockItem);
    }

    public void render(BotanyPotBlockEntity pot, float tickDelta, @NotNull PoseStack pose, @NotNull MultiBufferSource bufferSource, int light, int overlay) {
        Level level = pot.getLevel();
        if (level == null) {
            return;
        }
        BlockPos pos = pot.getBlockPos();
        int maxGrowth = pot.getRequiredGrowthTicks();
        float progress = Math.max(Mth.lerp((float)tickDelta, (float)(pot.growthTime.getTicks() - 1.0f), (float)pot.growthTime.getTicks()) / (float)maxGrowth, 0.0f);
        AxisAlignedRotation baseRotation = BotanyPotRenderer.getRotationForFace((Direction)pot.getBlockState().getValue((Property)BlockStateProperties.HORIZONTAL_FACING));
        Soil soil = pot.getOrInvalidateSoil();
        Crop crop = pot.getOrInvalidateCrop();
        boolean isGrowing = crop != null && crop.isGrowthSustained(pot.getRecipeContext(), level);
        ItemStack soilItem = pot.getSoilItem();
        float cropScale = 0.4f + Math.clamp(0.6f * progress, 0.0f, 0.6f);
        float lastOffset = 0.3984375f;
        if (isGrowing) {
            for (Display state : crop.getDisplayState(pot.getRecipeContext(), pot.getLevel())) {
                lastOffset = DisplayRenderer.renderState(this.renderContext, state, pose, level, pos, tickDelta, bufferSource, light, overlay, pot, progress, cropScale, lastOffset);
            }
        }
        if (!soilItem.isEmpty() && Minecraft.getInstance().getBlockEntityRenderDispatcher().camera.getPosition().y >= (double)pos.getY() && (soil != null || crop != null && soilItem.getItem() instanceof BlockItem && isGrowing)) {
            Display soilRender;
            pose.pushPose();
            BotanyPotRenderer.applyRotation(baseRotation, pose);
            pose.scale(1.0f, 0.6375f, 1.0f);
            if (soil != null) {
                v0 = soil.getDisplay(pot.getRecipeContext(), level);
            } else {
                Item item = soilItem.getItem();
                if (item instanceof BlockItem) {
                    BlockItem blockItem = (BlockItem)item;
                    v0 = DEFAULT_SOIL_DISPLAYS.computeIfAbsent((Item)blockItem, i -> new SimpleDisplayState(blockItem.getBlock().defaultBlockState(), BasicOptions.ofDefault()));
                } else {
                    v0 = soilRender = null;
                }
            }
            if (soilRender != null) {
                DisplayRenderer.renderState(this.renderContext, soilRender, pose, level, pos, tickDelta, bufferSource, light, overlay, pot, progress, 1.0f, 0.0f);
            }
            pose.popPose();
        }
    }

    public int getViewDistance() {
        return 40;
    }
}

