package net.darkhax.botanypots.common.impl.data.recipe.fertilizer;

import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.darkhax.bookshelf.common.api.data.codecs.stream.StreamCodecs;
import net.darkhax.bookshelf.common.api.util.DataHelper;
import net.darkhax.bookshelf.common.api.util.FunctionHelper;
import net.darkhax.bookshelf.common.api.util.MathsHelper;
import net.darkhax.botanypots.common.api.context.BlockEntityContext;
import net.darkhax.botanypots.common.api.context.BotanyPotContext;
import net.darkhax.botanypots.common.api.data.SoundEffect;
import net.darkhax.botanypots.common.api.data.recipes.CacheableRecipe;
import net.darkhax.botanypots.common.api.data.recipes.fertilizer.Fertilizer;
import net.darkhax.botanypots.common.impl.Helpers;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1865;
import net.minecraft.class_1937;
import net.minecraft.class_3218;
import net.minecraft.class_5712;
import net.minecraft.class_6088;
import net.minecraft.class_9129;
import net.minecraft.class_9135;
import net.minecraft.class_9139;
import org.jetbrains.annotations.NotNull;

import java.util.Objects;
import java.util.Optional;

public class BasicFertilizer extends Fertilizer implements CacheableRecipe {

    public static final MapCodec<BasicFertilizer> CODEC = Properties.CODEC.xmap(BasicFertilizer::new, BasicFertilizer::getProperties);
    public static final class_9139<class_9129, BasicFertilizer> STREAM = Properties.STREAM.method_56432(BasicFertilizer::new, BasicFertilizer::getProperties);
    public static final class_1865<BasicFertilizer> SERIALIZER = DataHelper.recipeSerializer(CODEC, STREAM);

    private final Properties properties;

    public BasicFertilizer(Properties properties) {
        this.properties = properties;
    }

    public Properties getProperties() {
        return this.properties;
    }

    @Override
    public void apply(@NotNull BotanyPotContext input, @NotNull class_1937 level) {
        if (input instanceof BlockEntityContext context && context.pot().canBonemeal() && level instanceof class_3218 sLevel) {
            final int requiredGrowthTicks = context.getRequiredGrowthTicks();
            final int maxBonemealableTicks = requiredGrowthTicks - 20;
            if (requiredGrowthTicks > 20 && context.pot().growthTime.getTicks() < maxBonemealableTicks) {
                context.pot().growthTime.setTicks(Math.min(context.pot().growthTime.getTicks() + MathsHelper.nextInt(sLevel.field_9229, properties.minGrowth, properties.maxGrowth), maxBonemealableTicks));
                context.pot().setBonemealCooldown(properties.cooldown);
                if (properties.spawnsParticles) {
                    level.method_20290(class_6088.field_47837, context.pot().method_11016(), 15);
                }
                if (properties.notifySculk) {
                    level.method_33596(context.getPlayer(), class_5712.field_28733, context.pot().method_11016());
                }
                if (!Objects.requireNonNull(context.player()).method_7337()) {
                    context.getInteractionItem().method_7934(1);
                }
                this.properties.soundEffect.ifPresent(soundEffect -> soundEffect.playSound(sLevel, null, context.pot().method_11016()));
                context.pot().markUpdated();
            }
        }
    }

    @Override
    public boolean matches(@NotNull BotanyPotContext input, @NotNull class_1937 level) {
        return properties.heldItem.method_8093(input.getInteractionItem()) && FunctionHelper.test(this.properties.soilIngredient, i -> i.method_8093(input.getSoilItem())) && FunctionHelper.test(this.properties.seedIngredient, i -> i.method_8093(input.getSeedItem()));
    }

    @Override
    public boolean canBeCached() {
        return true;
    }

    @Override
    public boolean isCacheKey(class_1799 stack) {
        return this.properties.heldItem.method_8093(stack);
    }

    @NotNull
    @Override
    public class_1865<?> method_8119() {
        return SERIALIZER;
    }

    @Override
    public boolean couldMatch(class_1799 candidate, BotanyPotContext context, class_1937 level) {
        return this.properties.heldItem.method_8093(candidate);
    }

    public record Properties(class_1856 heldItem, Optional<class_1856> soilIngredient, Optional<class_1856> seedIngredient, int minGrowth, int maxGrowth, int cooldown, boolean spawnsParticles, boolean notifySculk, Optional<SoundEffect> soundEffect) {
        public static final MapCodec<Properties> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group(
                class_1856.field_46095.fieldOf("held_item").forGetter(Properties::heldItem),
                class_1856.field_46095.optionalFieldOf("soil_item").forGetter(Properties::soilIngredient),
                class_1856.field_46095.optionalFieldOf("seed_item").forGetter(Properties::seedIngredient),
                Codec.INT.optionalFieldOf("min_growth", 400).forGetter(Properties::minGrowth),
                Codec.INT.optionalFieldOf("max_growth", 800).forGetter(Properties::maxGrowth),
                Codec.INT.optionalFieldOf("cooldown", 20).forGetter(Properties::cooldown),
                Codec.BOOL.optionalFieldOf("spawn_particles", true).forGetter(Properties::spawnsParticles),
                Codec.BOOL.optionalFieldOf("notify_sculk", true).forGetter(Properties::notifySculk),
                SoundEffect.CODEC.codec().optionalFieldOf("sound_effect").forGetter(Properties::soundEffect)
        ).apply(instance, Properties::new));

        public static final class_9139<class_9129, Properties> STREAM = new class_9139<>() {
            @NotNull
            @Override
            public Properties decode(@NotNull class_9129 buf) {
                final class_1856 heldItem = StreamCodecs.INGREDIENT_NON_EMPTY.decode(buf);
                final Optional<class_1856> soil = Helpers.OPTIONAL_INGREDIENT_STREAM.decode(buf);
                final Optional<class_1856> seed = Helpers.OPTIONAL_INGREDIENT_STREAM.decode(buf);
                final int min = class_9135.field_49675.decode(buf);
                final int max = class_9135.field_49675.decode(buf);
                final int cooldown = class_9135.field_49675.decode(buf);
                final boolean particles = buf.readBoolean();
                final boolean sculk = buf.readBoolean();
                final Optional<SoundEffect> soundEffect = SoundEffect.OPTIONAL_STREAM.decode(buf);
                return new Properties(heldItem, soil, seed, min, max, cooldown, particles, sculk, soundEffect);
            }

            @Override
            public void encode(@NotNull class_9129 buf, @NotNull Properties properties) {
                StreamCodecs.INGREDIENT_NON_EMPTY.encode(buf, properties.heldItem);
                Helpers.OPTIONAL_INGREDIENT_STREAM.encode(buf, properties.soilIngredient);
                Helpers.OPTIONAL_INGREDIENT_STREAM.encode(buf, properties.seedIngredient);
                class_9135.field_49675.encode(buf, properties.minGrowth);
                class_9135.field_49675.encode(buf, properties.maxGrowth);
                class_9135.field_49675.encode(buf, properties.cooldown);
                buf.method_52964(properties.spawnsParticles);
                buf.method_52964(properties.notifySculk);
                SoundEffect.OPTIONAL_STREAM.encode(buf, properties.soundEffect);
            }
        };
    }
}
