/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.botanypots.common.api.data.display.types;

import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import io.netty.buffer.ByteBuf;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.darkhax.bookshelf.common.api.data.codecs.map.MapCodecs;
import net.darkhax.botanypots.common.api.data.display.types.Display;
import net.darkhax.botanypots.common.impl.BotanyPotsMod;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_9139;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public record DisplayType<T extends Display>(class_2960 typeId, MapCodec<T> codec, class_9139<class_2540, T> stream) {
    private static final Map<class_2960, DisplayType<? extends Display>> REGISTRY = new HashMap<class_2960, DisplayType<? extends Display>>();
    public static final Codec<DisplayType<?>> TYPE_CODEC = class_2960.field_25139.xmap(REGISTRY::get, DisplayType::typeId);
    public static final class_9139<ByteBuf, ? extends DisplayType<? extends Display>> TYPE_STREAM = class_2960.field_48267.method_56432(REGISTRY::get, DisplayType::typeId);
    public static final Codec<Display> DISPLAY_STATE_CODEC = TYPE_CODEC.dispatch(Display::getType, DisplayType::codec);
    public static final class_9139<class_2540, Display> DISPLAY_STATE_STREAM = new class_9139<class_2540, Display>(){

        @NotNull
        public Display decode(@NotNull class_2540 buf) {
            class_2960 id = buf.method_10810();
            if (!REGISTRY.containsKey(id)) {
                BotanyPotsMod.LOG.error("Display type {} does not exist!", (Object)id);
                throw new IllegalStateException("Display type " + String.valueOf(id) + " does not exist!");
            }
            return (Display)DisplayType.REGISTRY.get((Object)id).stream.decode((Object)buf);
        }

        public void encode(@NotNull class_2540 buf, @NotNull Display state) {
            buf.method_10812(state.getType().typeId());
            state.getType().stream().encode((Object)buf, (Object)state);
        }
    };
    public static final Codec<List<Display>> LIST_CODEC = MapCodecs.flexibleList(DISPLAY_STATE_CODEC);

    @Nullable
    public static <T extends Display> DisplayType<T> get(class_2960 id) {
        return REGISTRY.get(id);
    }

    public static <T extends Display> DisplayType<T> register(class_2960 id, MapCodec<T> codec, class_9139<class_2540, T> buffer) {
        DisplayType<T> type = new DisplayType<T>(id, codec, buffer);
        if (REGISTRY.containsKey(id)) {
            BotanyPotsMod.LOG.warn("Display type ID {} has already been assigned to {}. You can not set it to {}.", new Object[]{id, REGISTRY.get(id), type});
            throw new IllegalStateException("Display type " + id.toString() + " has already been registered!");
        }
        REGISTRY.put(id, type);
        return type;
    }
}

