package net.darkhax.botanypots.common.impl.data.recipe.crop;

import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.darkhax.bookshelf.common.api.data.codecs.map.MapCodecs;
import net.darkhax.bookshelf.common.api.util.DataHelper;
import net.darkhax.bookshelf.common.mixin.access.block.AccessorCropBlock;
import net.darkhax.botanypots.common.api.data.display.types.Display;
import net.darkhax.botanypots.common.api.data.display.types.DisplayType;
import net.darkhax.botanypots.common.api.data.itemdrops.ItemDropProvider;
import net.darkhax.botanypots.common.api.data.itemdrops.ItemDropProviderType;
import net.darkhax.botanypots.common.impl.Helpers;
import net.darkhax.botanypots.common.impl.data.display.types.AgingDisplayState;
import net.darkhax.botanypots.common.impl.data.display.types.BasicOptions;
import net.darkhax.botanypots.common.impl.data.display.types.SimpleDisplayState;
import net.darkhax.botanypots.common.impl.data.itemdrops.BlockStateDrops;
import net.minecraft.class_1792;
import net.minecraft.class_1802;
import net.minecraft.class_1856;
import net.minecraft.class_1865;
import net.minecraft.class_1935;
import net.minecraft.class_2248;
import net.minecraft.class_2302;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2756;
import net.minecraft.class_2760;
import net.minecraft.class_2960;
import net.minecraft.class_7923;
import net.minecraft.class_9129;
import net.minecraft.class_9139;
import org.jetbrains.annotations.NotNull;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;

public class BlockDerivedCrop extends BasicCrop {

    public static final MapCodec<BlockDerivedCrop> CODEC = net.darkhax.botanypots.common.impl.data.recipe.crop.BlockDerivedCrop.Properties.CODEC.xmap(BlockDerivedCrop::new, BlockDerivedCrop::getProperties);
    public static final class_9139<class_9129, BlockDerivedCrop> STREAM = net.darkhax.botanypots.common.impl.data.recipe.crop.BlockDerivedCrop.Properties.STREAM.method_56432(BlockDerivedCrop::new, BlockDerivedCrop::getProperties);
    public static final class_1865<BlockDerivedCrop> SERIALIZER = DataHelper.recipeSerializer(CODEC, STREAM);

    private final net.darkhax.botanypots.common.impl.data.recipe.crop.BlockDerivedCrop.Properties properties;

    public BlockDerivedCrop(net.darkhax.botanypots.common.impl.data.recipe.crop.BlockDerivedCrop.Properties properties) {
        super(properties.toBasic());
        this.properties = properties;
    }

    public net.darkhax.botanypots.common.impl.data.recipe.crop.BlockDerivedCrop.Properties getProperties() {
        return this.properties;
    }

    public record Properties(class_2248 block, Optional<class_1856> seed, class_1856 soil, int growTime, Optional<List<Display>> display, int lightLevel, Optional<List<ItemDropProvider>> drops, Optional<BasicOptions> renderOptions, Optional<class_2960> functionId) {
        public static final MapCodec<net.darkhax.botanypots.common.impl.data.recipe.crop.BlockDerivedCrop.Properties> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group(
                class_7923.field_41175.method_39673().fieldOf("block").forGetter(net.darkhax.botanypots.common.impl.data.recipe.crop.BlockDerivedCrop.Properties::block),
                class_1856.field_46095.optionalFieldOf("input").forGetter(net.darkhax.botanypots.common.impl.data.recipe.crop.BlockDerivedCrop.Properties::seed),
                class_1856.field_46095.optionalFieldOf("soil", BasicCrop.DIRT).forGetter(net.darkhax.botanypots.common.impl.data.recipe.crop.BlockDerivedCrop.Properties::soil),
                Codec.intRange(1, Integer.MAX_VALUE).optionalFieldOf("grow_time", 1200).forGetter(net.darkhax.botanypots.common.impl.data.recipe.crop.BlockDerivedCrop.Properties::growTime),
                DisplayType.LIST_CODEC.optionalFieldOf("display").forGetter(net.darkhax.botanypots.common.impl.data.recipe.crop.BlockDerivedCrop.Properties::display),
                Codec.intRange(0, 15).optionalFieldOf("light_level", 0).forGetter(net.darkhax.botanypots.common.impl.data.recipe.crop.BlockDerivedCrop.Properties::lightLevel),
                MapCodecs.flexibleList(ItemDropProviderType.DROP_PROVIDER_CODEC).optionalFieldOf("drops").forGetter(net.darkhax.botanypots.common.impl.data.recipe.crop.BlockDerivedCrop.Properties::drops),
                BasicOptions.CODEC.optionalFieldOf("render_options").forGetter(net.darkhax.botanypots.common.impl.data.recipe.crop.BlockDerivedCrop.Properties::renderOptions),
                class_2960.field_25139.optionalFieldOf("function").forGetter(net.darkhax.botanypots.common.impl.data.recipe.crop.BlockDerivedCrop.Properties::functionId)
        ).apply(instance, net.darkhax.botanypots.common.impl.data.recipe.crop.BlockDerivedCrop.Properties::new));

        public static final class_9139<class_9129, net.darkhax.botanypots.common.impl.data.recipe.crop.BlockDerivedCrop.Properties> STREAM = new class_9139<>() {
            @NotNull
            @Override
            public net.darkhax.botanypots.common.impl.data.recipe.crop.BlockDerivedCrop.Properties decode(@NotNull class_9129 buf) {
                final class_2248 block = Helpers.BLOCK_STREAM.decode(buf);
                final BasicCrop.Properties props = BasicCrop.Properties.STREAM.decode(buf);
                return net.darkhax.botanypots.common.impl.data.recipe.crop.BlockDerivedCrop.Properties.fromBasic(block, props);
            }

            @Override
            public void encode(@NotNull class_9129 buf, @NotNull net.darkhax.botanypots.common.impl.data.recipe.crop.BlockDerivedCrop.Properties properties) {
                Helpers.BLOCK_STREAM.encode(buf, properties.block);
                BasicCrop.Properties.STREAM.encode(buf, properties.toBasic());
            }
        };

        public BasicCrop.Properties toBasic() {
            final class_1856 seed = this.seed.orElseGet(() -> getSeed(this.block));
            final BasicOptions rOptions = this.renderOptions.orElse(BasicOptions.ofDefault());
            final List<Display> display = this.display.orElseGet(() -> {
                final List<Display> states = new ArrayList<>();
                if (this.block.method_9564().method_28498(class_2741.field_12518)) {
                    states.add(new SimpleDisplayState(this.block.method_9564().method_11657(class_2741.field_12518, class_2760.field_12617), rOptions));
                    states.add(new SimpleDisplayState(this.block.method_9564().method_11657(class_2741.field_12518, class_2760.field_12619), rOptions));
                }
                else if (this.block.method_9564().method_28498(class_2741.field_12533)) {
                    states.add(new SimpleDisplayState(this.block.method_9564().method_11657(class_2741.field_12533, class_2756.field_12607), rOptions));
                    states.add(new SimpleDisplayState(this.block.method_9564().method_11657(class_2741.field_12533, class_2756.field_12609), rOptions));
                }
                else {
                    states.add(new AgingDisplayState(this.block, rOptions));
                }
                return states;
            });
            final List<ItemDropProvider> drops = this.drops.orElseGet(() -> List.of(new BlockStateDrops(getHarvestState(this.block))));
            return new BasicCrop.Properties(seed, this.soil, this.growTime, display, this.lightLevel, drops, this.functionId);
        }

        private static net.darkhax.botanypots.common.impl.data.recipe.crop.BlockDerivedCrop.Properties fromBasic(class_2248 block, BasicCrop.Properties basicProps) {
            return new net.darkhax.botanypots.common.impl.data.recipe.crop.BlockDerivedCrop.Properties(block, Optional.of(basicProps.input()), basicProps.soil(), basicProps.growTime(), Optional.of(basicProps.display()), basicProps.lightLevel(), Optional.of(basicProps.drops()), Optional.empty(), basicProps.functionId());
        }

        private static class_2680 getHarvestState(class_2248 block) {
            if (block instanceof class_2302 cropBlock) {
                return cropBlock.method_9828(cropBlock.method_9827());
            }
            return block.method_9564();
        }

        private static class_1856 getSeed(class_2248 block) {
            if (block instanceof AccessorCropBlock crop) {
                final class_1935 seedItem = crop.bookshelf$getSeed();
                if (seedItem != null && seedItem != class_1802.field_8162) {
                    return class_1856.method_8091(seedItem);
                }
            }
            final class_1792 placer = block.method_8389();
            if (placer != class_1802.field_8162) {
                return class_1856.method_8091(placer);
            }
            throw new IllegalArgumentException("Can not derive seed from block " + block + " id=" + class_7923.field_41175.method_10221(block));
        }
    }
}