package net.darkhax.botanypots.common.impl.data.recipe.crop;

import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.darkhax.bookshelf.common.api.data.codecs.map.MapCodecs;
import net.darkhax.bookshelf.common.api.data.codecs.stream.StreamCodecs;
import net.darkhax.bookshelf.common.api.util.DataHelper;
import net.darkhax.botanypots.common.api.context.BotanyPotContext;
import net.darkhax.botanypots.common.api.data.display.types.Display;
import net.darkhax.botanypots.common.api.data.display.types.DisplayType;
import net.darkhax.botanypots.common.api.data.itemdrops.ItemDropProvider;
import net.darkhax.botanypots.common.api.data.itemdrops.ItemDropProviderType;
import net.darkhax.botanypots.common.api.data.recipes.CacheableRecipe;
import net.darkhax.botanypots.common.api.data.recipes.crop.Crop;
import net.darkhax.botanypots.common.impl.BotanyPotsMod;
import net.darkhax.botanypots.common.impl.block.entity.BotanyPotBlockEntity;
import net.minecraft.class_124;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1865;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3544;
import net.minecraft.class_6862;
import net.minecraft.class_7924;
import net.minecraft.class_9129;
import net.minecraft.class_9135;
import net.minecraft.class_9139;
import org.jetbrains.annotations.NotNull;

import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;

public class BasicCrop extends Crop implements CacheableRecipe {

    public static final class_1856 DIRT = class_1856.method_8106(class_6862.method_40092(class_7924.field_41197, BotanyPotsMod.id("soil/dirt")));
    public static final MapCodec<BasicCrop> CODEC = Properties.CODEC.xmap(BasicCrop::new, BasicCrop::getBasicProperties);
    public static final class_9139<class_9129, BasicCrop> STREAM = Properties.STREAM.method_56432(BasicCrop::new, BasicCrop::getBasicProperties);
    public static final class_1865<BasicCrop> SERIALIZER = DataHelper.recipeSerializer(CODEC, STREAM);
    public static final class_2561 TOOLTIP_WRONG_SOIL = class_2561.method_43471("tooltip.botanypots.wrong_soil").method_27692(class_124.field_1061);

    private final Properties properties;

    public BasicCrop(Properties properties) {
        this.properties = properties;
    }

    public Properties getBasicProperties() {
        return this.properties;
    }

    @Override
    public boolean matches(@NotNull BotanyPotContext input, @NotNull class_1937 level) {
        return this.properties.input.method_8093(input.getSeedItem());
    }

    @Override
    public boolean couldMatch(class_1799 candidate, BotanyPotContext context, class_1937 level) {
        return this.properties.input.method_8093(candidate);
    }

    @Override
    public void onHarvest(BotanyPotContext context, class_1937 level, Consumer<class_1799> drops) {
        for (ItemDropProvider provider : this.properties.drops) {
            provider.apply(context, level, drops);
        }
        if (level instanceof class_3218 serverLevel) {
            this.properties.functionId.ifPresent(context::runFunction);
        }
    }

    @Override
    public List<Display> getDisplayState(BotanyPotContext context, class_1937 level) {
        return this.properties.display;
    }

    @Override
    public int getRequiredGrowthTicks(BotanyPotContext context, class_1937 level) {
        return this.properties.growTime;
    }

    @Override
    public boolean isGrowthSustained(BotanyPotContext context, class_1937 level) {
        return this.properties.soil.method_8093(context.getSoilItem());
    }

    @Override
    public boolean canBeCached() {
        return true;
    }

    @Override
    public boolean isCacheKey(class_1799 stack) {
        return properties.input.method_8093(stack);
    }

    @NotNull
    @Override
    public class_1865<?> method_8119() {
        return SERIALIZER;
    }

    @Override
    public void hoverTooltip(class_1799 stack, BotanyPotContext context, class_1937 level, Consumer<class_2561> tooltipLines) {
        if (stack == context.method_59984(BotanyPotBlockEntity.SEED_SLOT)) {
            if (this.isGrowthSustained(context, level)) {
                tooltipLines.accept(class_2561.method_43469("tooltip.botanypots.growth_time", class_3544.method_15439(context.getRequiredGrowthTicks(), level.method_54719().method_54748())).method_27692(class_124.field_1080));
            }
            if (!this.properties.soil.method_8093(context.method_59984(BotanyPotBlockEntity.SOIL_SLOT))) {
                tooltipLines.accept(TOOLTIP_WRONG_SOIL);
            }
        }
        else {
            tooltipLines.accept(class_2561.method_43469("tooltip.botanypots.growth_time", class_3544.method_15439(this.properties.growTime, level.method_54719().method_54748())).method_27692(class_124.field_1080));
        }
    }

    public boolean isValidSoil(class_1799 stack) {
        return this.properties.soil.method_8093(stack);
    }

    public record Properties(class_1856 input, class_1856 soil, int growTime, List<Display> display, int lightLevel, List<ItemDropProvider> drops, Optional<class_2960> functionId) {
        public static final MapCodec<Properties> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group(
                class_1856.field_46095.fieldOf("input").forGetter(Properties::input),
                class_1856.field_46095.optionalFieldOf("soil", DIRT).forGetter(Properties::soil),
                Codec.intRange(1, Integer.MAX_VALUE).optionalFieldOf("grow_time", 1200).forGetter(Properties::growTime),
                DisplayType.LIST_CODEC.fieldOf("display").forGetter(Properties::display),
                Codec.intRange(0, 15).optionalFieldOf("light_level", 0).forGetter(Properties::lightLevel),
                MapCodecs.flexibleList(ItemDropProviderType.DROP_PROVIDER_CODEC).optionalFieldOf("drops", List.of()).forGetter(Properties::drops),
                class_2960.field_25139.optionalFieldOf("function").forGetter(Properties::functionId)
        ).apply(instance, Properties::new));

        public static final class_9139<class_9129, Properties> STREAM = new class_9139<>() {
            @NotNull
            @Override
            public Properties decode(@NotNull class_9129 buf) {
                final class_1856 input = StreamCodecs.INGREDIENT_NON_EMPTY.decode(buf);
                final class_1856 soil = StreamCodecs.INGREDIENT_NON_EMPTY.decode(buf);
                final int growTime = class_9135.field_49675.decode(buf);
                final List<Display> display = buf.method_34066(DisplayType.DISPLAY_STATE_STREAM);
                final int light = class_9135.field_49675.decode(buf);
                final Optional<class_2960> functionId = buf.method_37436(class_2960.field_48267);

                final int dropSize = buf.readInt();
                final List<ItemDropProvider> drops = new LinkedList<>();
                for (int i = 0; i < dropSize; i++) {
                    drops.add(ItemDropProviderType.DROP_PROVIDER_STREAM.decode(buf));
                }

                return new Properties(input, soil, growTime, display, light, drops, functionId);
            }

            @Override
            public void encode(@NotNull class_9129 buf, @NotNull Properties properties) {
                StreamCodecs.INGREDIENT_NON_EMPTY.encode(buf, properties.input);
                StreamCodecs.INGREDIENT_NON_EMPTY.encode(buf, properties.soil);
                class_9135.field_49675.encode(buf, properties.growTime);
                buf.method_34062(properties.display, DisplayType.DISPLAY_STATE_STREAM);
                class_9135.field_49675.encode(buf, properties.lightLevel);
                buf.method_37435(properties.functionId, class_2960.field_48267);

                buf.method_53002(properties.drops.size());
                for (ItemDropProvider provider : properties.drops) {
                    ItemDropProviderType.DROP_PROVIDER_STREAM.encode(buf, provider);
                }
            }
        };
    }
}