package net.darkhax.botanypots.common.impl.data.itemdrops;

import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.darkhax.bookshelf.common.api.function.CachedSupplier;
import net.darkhax.bookshelf.common.api.function.ReloadableCache;
import net.darkhax.bookshelf.common.api.loot.LootPoolEntryDescriptions;
import net.darkhax.botanypots.common.api.context.BotanyPotContext;
import net.darkhax.botanypots.common.api.data.itemdrops.ItemDropProvider;
import net.darkhax.botanypots.common.api.data.itemdrops.ItemDropProviderType;
import net.darkhax.botanypots.common.impl.BotanyPotsMod;
import net.minecraft.class_1282;
import net.minecraft.class_1309;
import net.minecraft.class_173;
import net.minecraft.class_1799;
import net.minecraft.class_181;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_39;
import net.minecraft.class_52;
import net.minecraft.class_5321;
import net.minecraft.class_6880;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import net.minecraft.class_8110;
import net.minecraft.class_8567;
import net.minecraft.class_9129;
import net.minecraft.class_9135;
import net.minecraft.class_9139;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;

public class EntityDrops implements ItemDropProvider {

    public static final MapCodec<EntityDrops> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group(
            class_2487.field_25128.fieldOf("entity").forGetter(EntityDrops::getEntityData),
            class_8110.field_51565.optionalFieldOf("damage_source").forGetter(EntityDrops::getDamageType)
    ).apply(instance, EntityDrops::new));

    public static final class_9139<class_9129, EntityDrops> STREAM = class_9139.method_56437(
            (buf, value) -> {
                class_9135.field_48556.encode(buf, value.entityData);
                if (value.damageType.isPresent()) {
                    buf.method_52964(true);
                    class_8110.field_51932.encode(buf, value.damageType.get());
                }
                else {
                    buf.method_52964(false);
                }
                buf.method_44116(value.lootTableId.get());
                class_1799.field_49269.encode(buf, value.getDisplayItems());
            },
            buf -> {
                final class_2487 entityData = class_9135.field_48556.decode(buf);
                final boolean hasDamageType = buf.readBoolean();
                final Optional<class_6880<class_8110>> damageType = hasDamageType ? Optional.of(class_8110.field_51932.decode(buf)) : Optional.empty();
                final class_5321<class_52> tableId = buf.method_44112(class_7924.field_50079);
                final List<class_1799> displayItems = class_1799.field_49269.decode(buf);
                return new EntityDrops(entityData, damageType, tableId, displayItems);
            }
    );

    private final class_2487 entityData;
    private final Optional<class_6880<class_8110>> damageType;
    private final ReloadableCache<class_1309> entity;
    private final CachedSupplier<class_5321<class_52>> lootTableId;
    private final CachedSupplier<List<class_1799>> displayItems;

    // Server
    public EntityDrops(class_2487 entityData, Optional<class_6880<class_8110>> damageType) {
        this.entityData = entityData;
        this.damageType = damageType;
        this.entity = ReloadableCache.living(entityData);
        this.lootTableId = CachedSupplier.cache(() -> {
            if (entityData.method_10573("DeathLootTable", class_2520.field_33258)) {
                return class_5321.method_29179(class_7924.field_50079, class_2960.method_60654(entityData.method_10558("DeathLootTable")));
            }
            else if (entityData.method_10573("id", class_2520.field_33258)) {
                final class_2960 entityId = class_2960.method_12829(entityData.method_10558("id"));
                if (entityId != null && class_7923.field_41177.method_10250(entityId)) {
                    return class_7923.field_41177.method_10223(entityId).method_16351();
                }
            }
            return class_39.field_844;
        });
        this.displayItems = CachedSupplier.cache(() -> {
            final class_52 table = Objects.requireNonNull(BotanyPotsMod.REGISTRY_ACCESS.get()).method_30530(class_7924.field_50079).method_29107(this.lootTableId.get());
            return table != null ? LootPoolEntryDescriptions.getUniqueItems(Objects.requireNonNull(BotanyPotsMod.REGISTRY_ACCESS.get()), table) : List.of();
        });
    }

    // Client
    public EntityDrops(class_2487 entityData, Optional<class_6880<class_8110>> damageType, class_5321<class_52> tableId, List<class_1799> displayItems) {
        this.entityData = entityData;
        this.damageType = damageType;
        this.entity = ReloadableCache.living(entityData);
        this.lootTableId = CachedSupplier.singleton(tableId);
        this.displayItems = CachedSupplier.singleton(displayItems);
    }

    public class_2487 getEntityData() {
        return this.entityData;
    }

    public Optional<class_6880<class_8110>> getDamageType() {
        return this.damageType;
    }

    @Override
    public void apply(BotanyPotContext context, class_1937 level, Consumer<class_1799> drops) {
        if (level instanceof class_3218 serverLevel) {
            this.entity.ifPresent(level, living -> {
                final class_5321<class_52> resourcekey = living.method_5989();
                final class_52 loottable = serverLevel.method_8503().method_58576().method_58295(resourcekey);
                final class_8567.class_8568 paramBuilder = new class_8567.class_8568(serverLevel);
                paramBuilder.method_51874(class_181.field_1226, living);
                paramBuilder.method_51874(class_181.field_24424, living.method_19538());
                paramBuilder.method_51874(class_181.field_1231, this.damageType.map(class_1282::new).orElseGet(() -> serverLevel.method_48963().method_48830()));
                loottable.method_51880(paramBuilder.method_51875(class_173.field_1173), living.method_51851(), drops);
            });
        }
    }

    @Override
    public ItemDropProviderType<?> getType() {
        return ItemDropProviderType.ENTITY_DROPS;
    }

    @Override
    public List<class_1799> getDisplayItems() {
        return this.displayItems.get();
    }
}