package net.darkhax.botanypots.common.impl.data.itemdrops;

import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.darkhax.botanypots.common.api.context.BotanyPotContext;
import net.darkhax.botanypots.common.api.data.itemdrops.ItemDropProviderType;
import net.minecraft.class_1799;
import net.minecraft.class_2248;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_7923;
import net.minecraft.class_8567;
import net.minecraft.class_9129;
import net.minecraft.class_9139;
import java.util.List;

public class BlockDrops extends LootTableDrops {

    public static final MapCodec<BlockDrops> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group(
            class_7923.field_41175.method_39673().fieldOf("block").forGetter(BlockDrops::getBlock)
    ).apply(instance, BlockDrops::new));

    public static final class_9139<class_9129, BlockDrops> STREAM = class_9139.method_56437(
            (buf, val) -> {
                buf.method_10812(class_7923.field_41175.method_10221(val.getBlock()));
                buf.method_10812(val.getTableId());
                class_1799.field_49269.encode(buf, val.getDisplayItems());
            },
            buf -> {
                final class_2248 block = class_7923.field_41175.method_10223(buf.method_10810());
                final class_2960 tableId = buf.method_10810();
                final List<class_1799> items = class_1799.field_49269.decode(buf);
                return new BlockDrops(block, tableId, items);
            }
    );

    private final class_2248 block;
    private final class_2680 harvestState;

    // server
    public BlockDrops(class_2248 block) {
        this(block, block.method_9564());
    }

    // server
    public BlockDrops(class_2248 block, class_2680 harvestState) {
        super(block.method_26162().method_29177());
        this.block = block;
        this.harvestState = harvestState;
    }

    // client
    public BlockDrops(class_2248 block, class_2960 tableId, List<class_1799> display) {
        this(block, block.method_9564(), tableId, display);
    }

    // client
    public BlockDrops(class_2248 block, class_2680 harvestState, class_2960 tableId, List<class_1799> display) {
        super(tableId, display);
        this.block = block;
        this.harvestState = harvestState;
    }

    public class_2248 getBlock() {
        return this.block;
    }

    public class_2680 getHarvestState() {
        return this.harvestState;
    }

    @Override
    protected class_8567 getLootParams(BotanyPotContext context) {
        return context.createLootParams(this.harvestState);
    }

    @Override
    public ItemDropProviderType<?> getType() {
        return ItemDropProviderType.BLOCK_DROPS;
    }
}