/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.botanypots.common.impl.command;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.StringJoiner;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import net.darkhax.bookshelf.common.api.function.ReloadableCache;
import net.darkhax.bookshelf.common.api.util.CommandHelper;
import net.darkhax.botanypots.common.api.command.generator.DataHelper;
import net.darkhax.botanypots.common.api.command.generator.soil.SoilGenerator;
import net.darkhax.botanypots.common.api.command.generator.soil.TaggedSoilGenerator;
import net.darkhax.botanypots.common.api.data.recipes.RecipeCache;
import net.darkhax.botanypots.common.api.data.recipes.crop.Crop;
import net.darkhax.botanypots.common.api.data.recipes.fertilizer.Fertilizer;
import net.darkhax.botanypots.common.api.data.recipes.soil.Soil;
import net.darkhax.botanypots.common.impl.BotanyPotsMod;
import net.darkhax.botanypots.common.impl.command.BotanyPotsCommands;
import net.darkhax.botanypots.common.impl.command.generator.MissingSoilGenerator;
import net.minecraft.class_124;
import net.minecraft.class_1747;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1937;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2230;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2256;
import net.minecraft.class_2261;
import net.minecraft.class_2302;
import net.minecraft.class_2473;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_4863;
import net.minecraft.class_5321;
import net.minecraft.class_5809;
import net.minecraft.class_6862;
import net.minecraft.class_7922;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import org.apache.commons.io.FileUtils;

public class MissingCommand {
    public static SoilGenerator MISSING_BLOCK = new MissingSoilGenerator();
    public static SoilGenerator WATER = new TaggedSoilGenerator("botanypots:soil/water", DataHelper.simpleDisplay(class_2246.field_10382, true));
    public static SoilGenerator LAVA = new TaggedSoilGenerator("botanypots:soil/lava", DataHelper.simpleDisplay(class_2246.field_10164, true));
    public static SoilGenerator SNOW = new TaggedSoilGenerator("botanypots:soil/snow", DataHelper.simpleDisplay(class_2246.field_10491));
    private static final Comparator<class_2960> ID_COMPARE = Comparator.comparing(class_2960::toString);
    private static final class_6862<class_1792> FORGE_SEEDS = class_6862.method_40092((class_5321)class_7924.field_41197, (class_2960)class_2960.method_60655((String)"forge", (String)"seeds"));
    private static final class_6862<class_1792> COMMON_SEEDS = class_6862.method_40092((class_5321)class_7924.field_41197, (class_2960)class_2960.method_60655((String)"c", (String)"seeds"));
    private static final ReloadableCache<Set<class_1792>> IGNORED_ITEMS = ReloadableCache.of(() -> {
        HashSet<class_1792> items = new HashSet<class_1792>();
        items.add(class_1802.field_8689);
        items.add(class_1802.field_37511);
        items.add(class_1802.field_8328);
        items.add(class_1802.field_28655);
        items.add(class_1802.field_8270);
        items.add(class_1802.field_22015);
        items.add(class_1802.field_22013);
        return items;
    });
    public static final String SEED_TEMPLATE = "{\n  \"bookshelf:load_conditions\": [\n    {\n      \"type\": \"bookshelf:block_exists\",\n      \"values\": [\n        \"$block_id$\"\n      ]\n    }\n  ],\n  \"type\": \"botanypots:block_derived_crop\",\n  \"block\": \"$block_id$\"\n}\n";

    public static void build(LiteralArgumentBuilder<class_2168> parent) {
        LiteralArgumentBuilder cmd = class_2170.method_9247((String)"missing");
        LiteralArgumentBuilder seeds = class_2170.method_9247((String)"seeds");
        seeds.executes(MissingCommand::dumpMissingCrops);
        seeds.then(((RequiredArgumentBuilder)class_2170.method_9244((String)"include_saplings", (ArgumentType)BoolArgumentType.bool()).executes(MissingCommand::dumpMissingCrops)).then(class_2170.method_9244((String)"generate", (ArgumentType)BoolArgumentType.bool()).executes(MissingCommand::dumpMissingCrops)));
        cmd.then((ArgumentBuilder)seeds);
        LiteralArgumentBuilder soils = class_2170.method_9247((String)"soils");
        soils.executes(MissingCommand::dumpMissingSoils);
        soils.then(class_2170.method_9244((String)"generate", (ArgumentType)BoolArgumentType.bool()).executes(MissingCommand::dumpMissingSoils));
        cmd.then((ArgumentBuilder)soils);
        parent.then((ArgumentBuilder)cmd);
    }

    private static int dumpMissingSoils(CommandContext<class_2168> ctx) {
        class_3218 level = ((class_2168)ctx.getSource()).method_9225();
        boolean generate = CommandHelper.getBooleanArg((String)"generate", ctx, () -> false);
        SoilGenerator[] generators = new SoilGenerator[]{SNOW, LAVA, WATER, MISSING_BLOCK};
        HashMap<class_1799, SoilGenerator> missing = new HashMap<class_1799, SoilGenerator>();
        block0: for (class_1792 item : class_7923.field_41178) {
            class_1799 stack2 = item.method_7854();
            if (MissingCommand.isSoil(stack2, (class_1937)level)) continue;
            for (SoilGenerator generator : generators) {
                if (!generator.canGenerateSoil((class_1937)level, stack2)) continue;
                missing.put(stack2, generator);
                continue block0;
            }
        }
        if (missing.isEmpty()) {
            ((class_2168)ctx.getSource()).method_9226(() -> BotanyPotsCommands.modMessage((class_2561)class_2561.method_43471((String)"commands.botanypots.dump.no_results")), false);
            return 0;
        }
        if (generate) {
            MissingCommand.generateMissingSoils(level, missing);
        }
        StringJoiner entries = new StringJoiner(System.lineSeparator());
        entries.add("Potential missing soil IDs");
        missing.keySet().stream().map(stack -> class_7923.field_41178.method_10221((Object)stack.method_7909())).sorted(Comparator.comparing(class_2960::toString)).forEach(entry -> entries.add(entry.toString()));
        ((class_2168)ctx.getSource()).method_9226(() -> BotanyPotsCommands.modMessage((class_2561)class_2561.method_43469((String)"commands.botanypots.dump.missing_soils", (Object[])new Object[]{class_2561.method_43470((String)Integer.toString(missing.size())).method_27694(style -> style.method_10977(class_124.field_1061))}).method_27694(style -> style.method_10958(new class_2558(class_2558.class_2559.field_21462, entries.toString())))), false);
        return 0;
    }

    private static void generateMissingSoils(class_3218 level, Map<class_1799, SoilGenerator> missing) {
        File outDir = MissingCommand.setupDir("botanypots/generated/soils");
        for (Map.Entry<class_1799, SoilGenerator> entry : missing.entrySet()) {
            class_2960 itemId = class_7923.field_41178.method_10221((Object)entry.getKey().method_7909());
            File soilFile = new File(outDir, itemId.method_12836() + "/soil/" + itemId.method_12832() + ".json");
            JsonObject obj = entry.getValue().generateData((class_1937)level, entry.getKey());
            MissingCommand.writeFile(soilFile, DataHelper.GSON.toJson((JsonElement)obj));
        }
    }

    private static int dumpMissingCrops(CommandContext<class_2168> ctx) {
        boolean includeSaplings = CommandHelper.getBooleanArg((String)"include_saplings", ctx, () -> false);
        boolean generate = CommandHelper.getBooleanArg((String)"generate", ctx, () -> false);
        Set<class_2960> missingCrops = MissingCommand.getMissingCrops((class_1937)((class_2168)ctx.getSource()).method_9225(), includeSaplings);
        if (missingCrops.isEmpty()) {
            ((class_2168)ctx.getSource()).method_9226(() -> BotanyPotsCommands.modMessage((class_2561)class_2561.method_43471((String)"commands.botanypots.dump.no_results")), false);
            return 0;
        }
        if (generate) {
            File outdir = MissingCommand.setupDir("botanypots/generated/crops");
            for (class_2960 itemId : missingCrops) {
                class_1792 item = (class_1792)class_7923.field_41178.method_10223(itemId);
                if (!(item instanceof class_1747)) continue;
                class_1747 blockItem = (class_1747)item;
                class_2960 blockId = class_7923.field_41175.method_10221((Object)blockItem.method_7711());
                File cropFile = new File(outdir, blockId.method_12836() + "/crop/" + blockId.method_12832() + ".json");
                MissingCommand.writeFile(cropFile, SEED_TEMPLATE.replace("$block_id$", blockId.toString()));
            }
            ((class_2168)ctx.getSource()).method_9226(() -> class_2561.method_43471((String)"commands.botanypots.dump.generated").method_27694(style -> style.method_10958(new class_2558(class_2558.class_2559.field_11746, outdir.getAbsolutePath()))), false);
        } else {
            StringJoiner entries = new StringJoiner(System.lineSeparator());
            entries.add("Potential missing crop IDs");
            missingCrops.forEach(entry -> entries.add(entry.toString()));
            ((class_2168)ctx.getSource()).method_9226(() -> BotanyPotsCommands.modMessage((class_2561)class_2561.method_43469((String)"commands.botanypots.dump.missing_crops", (Object[])new Object[]{class_2561.method_43470((String)Integer.toString(missingCrops.size())).method_27694(style -> style.method_10977(class_124.field_1061))}).method_27694(style -> style.method_10958(new class_2558(class_2558.class_2559.field_21462, entries.toString())))), false);
        }
        return 0;
    }

    private static Set<class_2960> getMissingCrops(class_1937 level, boolean includeSaplings) {
        HashSet<class_1792> missingSeedItems = new HashSet<class_1792>();
        block0: for (class_1792 item2 : class_7923.field_41178) {
            if (MissingCommand.isCrop(item2.method_7854(), level) || MissingCommand.isSoil(item2.method_7854(), level) || !(item2 instanceof class_1747)) continue;
            class_1747 itemBlock = (class_1747)item2;
            class_2248 placedBlock = itemBlock.method_7711();
            class_2960 blockId = class_7923.field_41175.method_10221((Object)placedBlock);
            if (placedBlock instanceof class_2302 || placedBlock instanceof class_4863 || placedBlock instanceof class_2256 || placedBlock instanceof class_2473 || placedBlock instanceof class_2261 || placedBlock instanceof class_5809 || placedBlock instanceof class_2230 && !blockId.method_12832().startsWith("dead_")) {
                missingSeedItems.add(item2);
                continue;
            }
            for (class_2769 property : placedBlock.method_9595().method_11659()) {
                if (!property.method_11899().equalsIgnoreCase("age")) continue;
                missingSeedItems.add(item2);
                continue block0;
            }
        }
        Consumer<class_1792> tagProcessor = item -> {
            if (!MissingCommand.isCrop(item.method_7854(), level) && !MissingCommand.isSoil(item.method_7854(), level)) {
                missingSeedItems.add((class_1792)item);
            }
        };
        MissingCommand.processTag(FORGE_SEEDS, tagProcessor);
        MissingCommand.processTag(COMMON_SEEDS, tagProcessor);
        return missingSeedItems.stream().filter(item -> (includeSaplings || !MissingCommand.isSapling(item)) && !Objects.requireNonNull((Set)IGNORED_ITEMS.apply(level)).contains(item)).map(arg_0 -> ((class_7922)class_7923.field_41178).method_10221(arg_0)).sorted(ID_COMPARE).collect(Collectors.toCollection(LinkedHashSet::new));
    }

    private static void processTag(class_6862<class_1792> key, Consumer<class_1792> consumer) {
        class_7923.field_41178.method_40266(key).ifPresent(named -> named.forEach(entry -> consumer.accept((class_1792)entry.comp_349())));
    }

    private static boolean isCrop(class_1799 stack, class_1937 level) {
        return Objects.requireNonNull((RecipeCache)Crop.CACHE.apply(level)).isCached(stack);
    }

    private static boolean isSoil(class_1799 stack, class_1937 level) {
        return Objects.requireNonNull((RecipeCache)Soil.CACHE.apply(level)).isCached(stack);
    }

    private static boolean isFertilizer(class_1799 stack, class_1937 level) {
        return Objects.requireNonNull((RecipeCache)Fertilizer.CACHE.apply(level)).isCached(stack);
    }

    private static boolean isSapling(class_1792 item) {
        class_1747 blockItem;
        return item instanceof class_1747 && (blockItem = (class_1747)item).method_7711() instanceof class_2473;
    }

    private static void writeFile(File file, String text) {
        if (!file.getParentFile().exists()) {
            file.getParentFile().mkdirs();
        }
        try (FileWriter writer = new FileWriter(file);){
            writer.append(text);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static File setupDir(String dir) {
        File file = new File(dir);
        if (file.exists()) {
            try {
                FileUtils.deleteDirectory((File)file);
            }
            catch (Exception e) {
                BotanyPotsMod.LOG.error("Failed to setup dir {}.", (Object)dir, (Object)e);
            }
        }
        file.mkdirs();
        return file;
    }
}

