package net.darkhax.botanypots.common.impl.data.recipe.interaction;

import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.darkhax.bookshelf.common.api.data.codecs.stream.StreamCodecs;
import net.darkhax.bookshelf.common.api.service.Services;
import net.darkhax.bookshelf.common.api.util.DataHelper;
import net.darkhax.botanypots.common.api.data.SoundEffect;
import net.darkhax.botanypots.common.api.context.BlockEntityContext;
import net.darkhax.botanypots.common.api.context.BotanyPotContext;
import net.darkhax.botanypots.common.api.data.recipes.CacheableRecipe;
import net.darkhax.botanypots.common.api.data.recipes.interaction.PotInteraction;
import net.darkhax.botanypots.common.impl.Helpers;
import net.minecraft.class_1268;
import net.minecraft.class_1304;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1865;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_52;
import net.minecraft.class_5321;
import net.minecraft.class_5712;
import net.minecraft.class_7924;
import net.minecraft.class_9129;
import net.minecraft.class_9139;
import org.jetbrains.annotations.NotNull;

import java.util.Optional;

public class BasicPotInteraction extends PotInteraction implements CacheableRecipe {

    public static final MapCodec<BasicPotInteraction> CODEC = Properties.CODEC.xmap(BasicPotInteraction::new, BasicPotInteraction::getProperties);
    public static final class_9139<class_9129, BasicPotInteraction> STREAM = Properties.STREAM.method_56432(BasicPotInteraction::new, BasicPotInteraction::getProperties);
    public static final class_1865<BasicPotInteraction> SERIALIZER = DataHelper.recipeSerializer(CODEC, STREAM);

    public final Properties properties;

    public BasicPotInteraction(Properties properties) {
        this.properties = properties;
    }

    public Properties getProperties() {
        return this.properties;
    }

    @Override
    public void apply(@NotNull BotanyPotContext context) {
        if (context instanceof BlockEntityContext input && input.player() instanceof class_3222 player && player.method_37908() instanceof class_3218 level) {
            this.properties.newSoil.ifPresent(soilStack -> {
                Services.GAMEPLAY.dropRemainders(level, input.pot().method_11016(), input.getSoilItem());
                input.pot().setSoilItem(soilStack.method_7972());
            });
            this.properties.newSeed.ifPresent(seedStack -> {
                Services.GAMEPLAY.dropRemainders(level, input.pot().method_11016(), input.getSoilItem());
                input.pot().setSeed(seedStack.method_7972());
            });
            final class_1799 usedItem = input.getInteractionItem();
            if (!usedItem.method_7960()) {
                if (this.properties.damageHeld) {
                    usedItem.method_7970(1, player, input.hand() == class_1268.field_5808 ? class_1304.field_6173 : class_1304.field_6171);
                }
                else if (this.properties.consumeHeld) {
                    Services.GAMEPLAY.dropRemainders(level, input.pot().method_11016(), usedItem.method_7971(1));
                }
            }
            this.properties.extraDrops.ifPresent(tableKey -> {
                final class_52 table = level.method_8503().method_58576().method_58295(tableKey);
                final class_2338 pos = input.pot().method_11016();
                if (table != class_52.field_948) {
                    table.method_51878(input.createLootParams(null)).forEach(drop -> class_2248.method_9577(level, pos, drop));
                }
            });
            this.properties.soundEffect.ifPresent(soundEffect -> soundEffect.playSound(level, null, input.pot().method_11016()));
            if (this.properties.notifySculk) {
                level.method_33596(context.getPlayer(), class_5712.field_28733, input.pot().method_11016());
            }
        }
    }

    @Override
    public boolean matches(@NotNull BotanyPotContext input, @NotNull class_1937 level) {
        return this.properties.validateInputs(input.getInteractionItem(), input.getSoilItem(), input.getSeedItem());
    }

    @NotNull
    @Override
    public class_1865<?> method_8119() {
        return SERIALIZER;
    }

    @Override
    public boolean couldMatch(class_1799 candidate, BotanyPotContext context, class_1937 level) {
        return this.properties.validateInputs(candidate, context.getSoilItem(), context.getSeedItem());
    }

    @Override
    public boolean canBeCached() {
        return true;
    }

    @Override
    public boolean isCacheKey(class_1799 stack) {
        return this.properties.heldTest.method_8093(stack);
    }

    public record Properties(class_1856 heldTest, boolean damageHeld, boolean consumeHeld, Optional<class_1856> soilTest, Optional<class_1856> seedTest, Optional<class_1799> newSoil, Optional<class_1799> newSeed, Optional<class_5321<class_52>> extraDrops, Optional<SoundEffect> soundEffect, boolean notifySculk) {
        public static final MapCodec<Properties> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group(
                class_1856.field_46095.fieldOf("held_item").forGetter(Properties::heldTest),
                Codec.BOOL.optionalFieldOf("damage_held", true).forGetter(Properties::damageHeld),
                Codec.BOOL.optionalFieldOf("consume_held", false).forGetter(Properties::consumeHeld),
                class_1856.field_46095.optionalFieldOf("soil_item").forGetter(Properties::soilTest),
                class_1856.field_46095.optionalFieldOf("seed_item").forGetter(Properties::seedTest),
                class_1799.field_24671.optionalFieldOf("new_soil").forGetter(Properties::newSoil),
                class_1799.field_24671.optionalFieldOf("new_seed").forGetter(Properties::newSeed),
                class_2960.field_25139.optionalFieldOf("extra_drops").xmap(rl -> rl.map(arl -> class_5321.method_29179(class_7924.field_50079, arl)), arl -> arl.map(class_5321::method_29177)).forGetter(Properties::extraDrops),
                SoundEffect.CODEC.codec().optionalFieldOf("sound_effect").forGetter(Properties::soundEffect),
                Codec.BOOL.optionalFieldOf("notify_sculk", true).forGetter(Properties::notifySculk)
        ).apply(instance, Properties::new));

        public static final class_9139<class_9129, Properties> STREAM = new class_9139<>() {
            @NotNull
            @Override
            public Properties decode(@NotNull class_9129 buf) {
                final class_1856 ingredient = StreamCodecs.INGREDIENT_NON_EMPTY.decode(buf);
                final boolean damageHeld = buf.readBoolean();
                final boolean consumeHeld = buf.readBoolean();
                final Optional<class_1856> soilTest = Helpers.OPTIONAL_INGREDIENT_STREAM.decode(buf);
                final Optional<class_1856> seedTest = Helpers.OPTIONAL_INGREDIENT_STREAM.decode(buf);
                final Optional<class_1799> newSoil = Helpers.OPTIONAL_ITEMSTACK_STREAM.decode(buf);
                final Optional<class_1799> newSeed = Helpers.OPTIONAL_ITEMSTACK_STREAM.decode(buf);
                final Optional<class_5321<class_52>> extraDrops = buf.method_37436(class_2960.field_48267).map(rl -> class_5321.method_29179(class_7924.field_50079, rl));
                final Optional<SoundEffect> soundEffect = SoundEffect.OPTIONAL_STREAM.decode(buf);
                final boolean notifySculk = buf.readBoolean();
                return new Properties(ingredient, damageHeld, consumeHeld, soilTest, seedTest, newSoil, newSeed, extraDrops, soundEffect, notifySculk);
            }

            @Override
            public void encode(@NotNull class_9129 buf, @NotNull Properties properties) {
                StreamCodecs.INGREDIENT_NON_EMPTY.encode(buf, properties.heldTest);
                buf.method_52964(properties.damageHeld);
                buf.method_52964(properties.consumeHeld);
                Helpers.OPTIONAL_INGREDIENT_STREAM.encode(buf, properties.soilTest);
                Helpers.OPTIONAL_INGREDIENT_STREAM.encode(buf, properties.seedTest);
                Helpers.OPTIONAL_ITEMSTACK_STREAM.encode(buf, properties.newSoil);
                Helpers.OPTIONAL_ITEMSTACK_STREAM.encode(buf, properties.newSeed);
                buf.method_37435(properties.extraDrops, (b, v) -> b.method_10812(v.method_29177()));
                SoundEffect.OPTIONAL_STREAM.encode(buf, properties.soundEffect);
                buf.method_52964(properties.notifySculk);
            }
        };

        public boolean validateInputs(class_1799 held, class_1799 soil, class_1799 seed) {
            return this.heldTest.method_8093(held) && (this.soilTest.isEmpty() || this.soilTest.get().method_8093(soil)) && (this.seedTest.isEmpty() || this.seedTest.get().method_8093(seed));
        }
    }
}