package net.darkhax.botanypots.common.impl.command;

import com.google.gson.JsonObject;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import net.darkhax.bookshelf.common.api.function.ReloadableCache;
import net.darkhax.bookshelf.common.api.util.CommandHelper;
import net.darkhax.botanypots.common.api.command.generator.DataHelper;
import net.darkhax.botanypots.common.api.command.generator.soil.SoilGenerator;
import net.darkhax.botanypots.common.api.command.generator.soil.TaggedSoilGenerator;
import net.darkhax.botanypots.common.api.data.recipes.crop.Crop;
import net.darkhax.botanypots.common.api.data.recipes.fertilizer.Fertilizer;
import net.darkhax.botanypots.common.api.data.recipes.soil.Soil;
import net.darkhax.botanypots.common.impl.BotanyPotsMod;
import net.darkhax.botanypots.common.impl.command.generator.MissingSoilGenerator;
import net.minecraft.class_124;
import net.minecraft.class_1747;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1937;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2230;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2256;
import net.minecraft.class_2261;
import net.minecraft.class_2302;
import net.minecraft.class_2473;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_4863;
import net.minecraft.class_5809;
import net.minecraft.class_6862;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import org.apache.commons.io.FileUtils;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.StringJoiner;
import java.util.function.Consumer;
import java.util.stream.Collectors;

public class MissingCommand {

    public static SoilGenerator MISSING_BLOCK = new MissingSoilGenerator();
    public static SoilGenerator WATER = new TaggedSoilGenerator("botanypots:soil/water", DataHelper.simpleDisplay(class_2246.field_10382, true));
    public static SoilGenerator LAVA = new TaggedSoilGenerator("botanypots:soil/lava", DataHelper.simpleDisplay(class_2246.field_10164, true));
    public static SoilGenerator SNOW = new TaggedSoilGenerator("botanypots:soil/snow", DataHelper.simpleDisplay(class_2246.field_10491));


    private static final Comparator<class_2960> ID_COMPARE = Comparator.comparing(class_2960::toString);
    private static final class_6862<class_1792> FORGE_SEEDS = class_6862.method_40092(class_7924.field_41197, class_2960.method_60655("forge", "seeds"));
    private static final class_6862<class_1792> COMMON_SEEDS = class_6862.method_40092(class_7924.field_41197, class_2960.method_60655("c", "seeds"));
    private static final ReloadableCache<Set<class_1792>> IGNORED_ITEMS = ReloadableCache.of(() -> {
        final Set<class_1792> items = new HashSet<>();
        items.add(class_1802.field_8689);
        items.add(class_1802.field_37511);
        items.add(class_1802.field_8328);
        items.add(class_1802.field_28655);
        items.add(class_1802.field_8270);
        items.add(class_1802.field_22015);
        items.add(class_1802.field_22013);
        return items;
    });
    public static final String SEED_TEMPLATE = """
            {
              "bookshelf:load_conditions": [
                {
                  "type": "bookshelf:block_exists",
                  "values": [
                    "$block_id$"
                  ]
                }
              ],
              "type": "botanypots:block_derived_crop",
              "block": "$block_id$"
            }
            """;

    public static void build(LiteralArgumentBuilder<class_2168> parent) {
        final LiteralArgumentBuilder<class_2168> cmd = class_2170.method_9247("missing");
        final LiteralArgumentBuilder<class_2168> seeds = class_2170.method_9247("seeds");
        seeds.executes(MissingCommand::dumpMissingCrops);
        seeds.then(class_2170.method_9244("include_saplings", BoolArgumentType.bool()).executes(MissingCommand::dumpMissingCrops).then(class_2170.method_9244("generate", BoolArgumentType.bool()).executes(MissingCommand::dumpMissingCrops)));
        cmd.then(seeds);

        final LiteralArgumentBuilder<class_2168> soils = class_2170.method_9247("soils");
        soils.executes(MissingCommand::dumpMissingSoils);
        soils.then(class_2170.method_9244("generate", BoolArgumentType.bool()).executes(MissingCommand::dumpMissingSoils));
        cmd.then(soils);

        parent.then(cmd);
    }

    private static int dumpMissingSoils(CommandContext<class_2168> ctx) {
        final class_3218 level = ctx.getSource().method_9225();
        final boolean generate = CommandHelper.getBooleanArg("generate", ctx, () -> false);
        final SoilGenerator[] generators = {SNOW, LAVA, WATER, MISSING_BLOCK};

        final Map<class_1799, SoilGenerator> missing = new HashMap<>();
        for (class_1792 item : class_7923.field_41178) {
            final class_1799 stack = item.method_7854();
            if (!isSoil(stack, level)) {
                for (SoilGenerator generator : generators) {
                    if (generator.canGenerateSoil(level, stack)) {
                        missing.put(stack, generator);
                        break;
                    }
                }
            }
        }

        if (missing.isEmpty()) {
            ctx.getSource().method_9226(() -> BotanyPotsCommands.modMessage(class_2561.method_43471("commands.botanypots.dump.no_results")), false);
            return 0;
        }
        else {
            if (generate) {
                generateMissingSoils(level, missing);
            }
            final StringJoiner entries = new StringJoiner(System.lineSeparator());
            entries.add("Potential missing soil IDs");
            missing.keySet().stream().map(stack -> class_7923.field_41178.method_10221(stack.method_7909())).sorted(Comparator.comparing(class_2960::toString)).forEach(entry -> entries.add(entry.toString()));
            ctx.getSource().method_9226(() -> BotanyPotsCommands.modMessage(class_2561.method_43469("commands.botanypots.dump.missing_soils", class_2561.method_43470(Integer.toString(missing.size())).method_27694(style -> style.method_10977(class_124.field_1061))).method_27694(style -> style.method_10958(new class_2558(class_2558.class_2559.field_21462, entries.toString())))), false);
        }
        return 0;
    }

    private static void generateMissingSoils(class_3218 level, Map<class_1799, SoilGenerator> missing) {
        final File outDir = setupDir("botanypots/generated/soils");
        for (Map.Entry<class_1799, SoilGenerator> entry : missing.entrySet()) {
            final class_2960 itemId = class_7923.field_41178.method_10221(entry.getKey().method_7909());
            final File soilFile = new File(outDir, itemId.method_12836() + "/soil/" + itemId.method_12832() + ".json");
            final JsonObject obj = entry.getValue().generateData(level, entry.getKey());
            writeFile(soilFile, DataHelper.GSON.toJson(obj));
        }
    }

    private static int dumpMissingCrops(CommandContext<class_2168> ctx) {
        final boolean includeSaplings = CommandHelper.getBooleanArg("include_saplings", ctx, () -> false);
        final boolean generate = CommandHelper.getBooleanArg("generate", ctx, () -> false);
        final Set<class_2960> missingCrops = getMissingCrops(ctx.getSource().method_9225(), includeSaplings);

        if (missingCrops.isEmpty()) {
            ctx.getSource().method_9226(() -> BotanyPotsCommands.modMessage(class_2561.method_43471("commands.botanypots.dump.no_results")), false);
            return 0;
        }

        if (generate) {
            final File outdir = setupDir("botanypots/generated/crops");
            for (class_2960 itemId : missingCrops) {
                final class_1792 item = class_7923.field_41178.method_10223(itemId);
                if (item instanceof class_1747 blockItem) {
                    final class_2960 blockId = class_7923.field_41175.method_10221(blockItem.method_7711());
                    final File cropFile = new File(outdir, blockId.method_12836() + "/crop/" + blockId.method_12832() + ".json");
                    writeFile(cropFile, SEED_TEMPLATE.replace("$block_id$", blockId.toString()));
                }
            }
            ctx.getSource().method_9226(() -> class_2561.method_43471("commands.botanypots.dump.generated").method_27694(style -> style.method_10958(new class_2558(class_2558.class_2559.field_11746, outdir.getAbsolutePath()))), false);
        }
        else {
            final StringJoiner entries = new StringJoiner(System.lineSeparator());
            entries.add("Potential missing crop IDs");
            missingCrops.forEach(entry -> entries.add(entry.toString()));
            ctx.getSource().method_9226(() -> BotanyPotsCommands.modMessage(class_2561.method_43469("commands.botanypots.dump.missing_crops", class_2561.method_43470(Integer.toString(missingCrops.size())).method_27694(style -> style.method_10977(class_124.field_1061))).method_27694(style -> style.method_10958(new class_2558(class_2558.class_2559.field_21462, entries.toString())))), false);
        }
        return 0;
    }

    private static Set<class_2960> getMissingCrops(class_1937 level, boolean includeSaplings) {
        final Set<class_1792> missingSeedItems = new HashSet<>();
        for (class_1792 item : class_7923.field_41178) {
            if (isCrop(item.method_7854(), level) || isSoil(item.method_7854(), level)) {
                continue;
            }
            if (item instanceof class_1747 itemBlock) {
                final class_2248 placedBlock = itemBlock.method_7711();
                final class_2960 blockId = class_7923.field_41175.method_10221(placedBlock);
                if (placedBlock instanceof class_2302 || placedBlock instanceof class_4863 || placedBlock instanceof class_2256 || placedBlock instanceof class_2473 || placedBlock instanceof class_2261 || placedBlock instanceof class_5809 || (placedBlock instanceof class_2230 && !blockId.method_12832().startsWith("dead_"))) {
                    missingSeedItems.add(item);
                }
                else {
                    for (class_2769<?> property : placedBlock.method_9595().method_11659()) {
                        if (property.method_11899().equalsIgnoreCase("age")) {
                            missingSeedItems.add(item);
                            break;
                        }
                    }
                }
            }
        }
        final Consumer<class_1792> tagProcessor = item -> {
            if (!isCrop(item.method_7854(), level) && !isSoil(item.method_7854(), level)) {
                missingSeedItems.add(item);
            }
        };
        processTag(FORGE_SEEDS, tagProcessor);
        processTag(COMMON_SEEDS, tagProcessor);
        return missingSeedItems.stream().filter(item -> (includeSaplings || !isSapling(item)) && !Objects.requireNonNull(IGNORED_ITEMS.apply(level)).contains(item)).map(class_7923.field_41178::method_10221).sorted(ID_COMPARE).collect(Collectors.toCollection(LinkedHashSet::new));
    }

    private static void processTag(class_6862<class_1792> key, Consumer<class_1792> consumer) {
        class_7923.field_41178.method_40266(key).ifPresent(named -> named.forEach(entry -> consumer.accept(entry.comp_349())));
    }

    private static boolean isCrop(class_1799 stack, class_1937 level) {
        return Objects.requireNonNull(Crop.CACHE.apply(level)).isCached(stack);
    }

    private static boolean isSoil(class_1799 stack, class_1937 level) {
        return Objects.requireNonNull(Soil.CACHE.apply(level)).isCached(stack);
    }

    private static boolean isFertilizer(class_1799 stack, class_1937 level) {
        return Objects.requireNonNull(Fertilizer.CACHE.apply(level)).isCached(stack);
    }

    private static boolean isSapling(class_1792 item) {
        return item instanceof class_1747 blockItem && blockItem.method_7711() instanceof class_2473;
    }

    private static void writeFile(File file, String text) {
        if (!file.getParentFile().exists()) {
            file.getParentFile().mkdirs();
        }
        try (FileWriter writer = new FileWriter(file)) {
            writer.append(text);
        }
        catch (IOException e) {
            // No
        }
    }

    private static File setupDir(String dir) {
        final File file = new File(dir);
        if (file.exists()) {
            try {
                FileUtils.deleteDirectory(file);
            }
            catch (Exception e) {
                BotanyPotsMod.LOG.error("Failed to setup dir {}.", dir, e);
            }
        }
        file.mkdirs();
        return file;
    }
}
