package net.darkhax.botanypots.common.api.command.generator;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.serialization.Codec;
import com.mojang.serialization.JsonOps;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_2248;
import net.minecraft.class_6862;
import net.minecraft.class_7922;
import net.minecraft.class_7923;

public class DataHelper {

    public static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    public static final class_7922<class_2248> BLOCKS = class_7923.field_41175;
    public static final class_7922<class_1792> ITEMS = class_7923.field_41178;

    public static JsonObject requiresBlock(class_2248 block) {
        return object("{\"type\":\"bookshelf:block_exists\",\"values\": [\"" + BLOCKS.method_10221(block) + "\"]}");
    }

    public static JsonObject requiresItem(class_1792 item) {
        return object("{\"type\":\"bookshelf:item_exists\",\"values\": [\"" + ITEMS.method_10221(item) + "\"]}");
    }

    public static JsonObject item(class_1792 item) {
        return object("{\"item\":\"" + ITEMS.method_10221(item) + "\"}");
    }

    public static JsonObject tag(class_6862<?> tag) {
        return object("{\"tag\":\"" + tag.comp_327() + "\"}");
    }

    public static JsonElement stack(class_1799 stack) {
        return encode(class_1799.field_24671, stack);
    }

    public static JsonElement ingredient(class_1856 ingredient) {
        return encode(class_1856.field_46095, ingredient);
    }

    public static JsonObject simpleDisplay(class_2248 block) {
        return simpleDisplay(block, false);
    }

    public static JsonObject simpleDisplay(class_2248 block, boolean fluid) {
        final JsonObject out = new JsonObject();
        out.addProperty("type", "botanypots:simple");
        out.add("block_state", object("{\"block\":\"" + BLOCKS.method_10221(block) + "\"}"));
        if (fluid) {
            out.add("options", object("{\"render_fluid\":true}"));
        }
        return out;
    }

    public static JsonArray array(JsonElement... elements) {
        final JsonArray array = new JsonArray();
        for (JsonElement element : elements) {
            array.add(element);
        }
        return array;
    }

    public static JsonObject object(String raw) {
        return GSON.fromJson(raw, JsonObject.class);
    }

    public static <T> JsonElement encode(Codec<T> codec, T value) {
        return codec.encodeStart(JsonOps.INSTANCE, value).getOrThrow();
    }
}