/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.botanypots.common.impl.commands;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.StringJoiner;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.darkhax.bookshelf.common.api.function.ReloadableCache;
import net.darkhax.bookshelf.common.api.util.CommandHelper;
import net.darkhax.botanypots.common.api.data.recipes.RecipeCache;
import net.darkhax.botanypots.common.api.data.recipes.crop.Crop;
import net.darkhax.botanypots.common.api.data.recipes.fertilizer.Fertilizer;
import net.darkhax.botanypots.common.api.data.recipes.soil.Soil;
import net.darkhax.botanypots.common.impl.BotanyPotsMod;
import net.darkhax.botanypots.common.impl.commands.BotanyPotsCommands;
import net.darkhax.botanypots.common.impl.data.recipe.crop.BasicCrop;
import net.minecraft.class_124;
import net.minecraft.class_1747;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1860;
import net.minecraft.class_1937;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2230;
import net.minecraft.class_2248;
import net.minecraft.class_2256;
import net.minecraft.class_2261;
import net.minecraft.class_2302;
import net.minecraft.class_2473;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_4863;
import net.minecraft.class_5321;
import net.minecraft.class_5809;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_7922;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import net.minecraft.class_8786;
import org.apache.commons.io.FileUtils;

public class MissingCommand {
    private static final class_6862<class_1792> SOIL_WATER = class_6862.method_40092((class_5321)class_7924.field_41197, (class_2960)class_2960.method_60655((String)"botanypots", (String)"soil/water"));
    private static final class_6862<class_1792> SOIL_LAVA = class_6862.method_40092((class_5321)class_7924.field_41197, (class_2960)class_2960.method_60655((String)"botanypots", (String)"soil/lava"));
    private static final class_6862<class_1792> SOIL_SNOW = class_6862.method_40092((class_5321)class_7924.field_41197, (class_2960)class_2960.method_60655((String)"botanypots", (String)"soil/snow"));
    private static final Comparator<class_2960> ID_COMPARE = Comparator.comparing(class_2960::toString);
    private static final class_6862<class_1792> FORGE_SEEDS = class_6862.method_40092((class_5321)class_7924.field_41197, (class_2960)class_2960.method_60655((String)"forge", (String)"seeds"));
    private static final class_6862<class_1792> COMMON_SEEDS = class_6862.method_40092((class_5321)class_7924.field_41197, (class_2960)class_2960.method_60655((String)"c", (String)"seeds"));
    private static final ReloadableCache<Set<class_1792>> IGNORED_ITEMS = ReloadableCache.of(() -> {
        HashSet<class_1792> items = new HashSet<class_1792>();
        items.add(class_1802.field_8689);
        items.add(class_1802.field_37511);
        items.add(class_1802.field_8328);
        items.add(class_1802.field_28655);
        items.add(class_1802.field_8270);
        items.add(class_1802.field_22015);
        items.add(class_1802.field_22013);
        return items;
    });
    public static final String SEED_TEMPLATE = "{\n  \"bookshelf:load_conditions\": [\n    {\n      \"type\": \"bookshelf:block_exists\",\n      \"values\": [\n        \"$block_id$\"\n      ]\n    }\n  ],\n  \"type\": \"botanypots:block_derived_crop\",\n  \"block\": \"$block_id$\"\n}\n";
    public static final String WATER_SOIL = "{\n  \"bookshelf:load_conditions\": [\n    {\n      \"type\": \"bookshelf:item_exists\",\n      \"values\": [\n        \"$item_id$\"\n      ]\n    }\n  ],\n  \"type\": \"botanypots:soil\",\n  \"input\": {\n    \"item\": \"$item_id$\"\n  },\n  \"display\": {\n    \"type\": \"botanypots:simple\",\n    \"block_state\": {\n      \"block\": \"minecraft:water\"\n    },\n    \"options\": {\n      \"render_fluid\": true\n    }\n  }\n}\n";
    public static final String SNOW_SOIL = "{\n  \"bookshelf:load_conditions\": [\n    {\n      \"type\": \"bookshelf:item_exists\",\n      \"values\": [\n        \"$item_id$\"\n      ]\n    }\n  ],\n  \"type\": \"botanypots:soil\",\n  \"input\": {\n    \"item\": \"$item_id$\"\n  },\n  \"display\": {\n    \"type\": \"botanypots:simple\",\n    \"block_state\": {\n      \"block\": \"minecraft:snow_block\"\n    }\n  }\n}\n";
    public static final String BLOCK_SOIL = "{\n  \"bookshelf:load_conditions\": [\n    {\n      \"type\": \"bookshelf:block_exists\",\n      \"values\": [\n        \"$block_id$\"\n      ]\n    }\n  ],\n  \"type\": \"botanypots:block_derived_soil\",\n  \"block\": \"$block_id$\"\n}\n";

    public static void build(LiteralArgumentBuilder<class_2168> parent) {
        LiteralArgumentBuilder cmd = class_2170.method_9247((String)"missing");
        LiteralArgumentBuilder seeds = class_2170.method_9247((String)"seeds");
        seeds.executes(MissingCommand::dumpMissingCrops);
        seeds.then(((RequiredArgumentBuilder)class_2170.method_9244((String)"include_saplings", (ArgumentType)BoolArgumentType.bool()).executes(MissingCommand::dumpMissingCrops)).then(class_2170.method_9244((String)"generate", (ArgumentType)BoolArgumentType.bool()).executes(MissingCommand::dumpMissingCrops)));
        cmd.then((ArgumentBuilder)seeds);
        LiteralArgumentBuilder soils = class_2170.method_9247((String)"soils");
        soils.executes(MissingCommand::dumpMissingSoils);
        soils.then(class_2170.method_9244((String)"generate", (ArgumentType)BoolArgumentType.bool()).executes(MissingCommand::dumpMissingSoils));
        cmd.then((ArgumentBuilder)soils);
        parent.then((ArgumentBuilder)cmd);
    }

    private static int dumpMissingSoils(CommandContext<class_2168> ctx) {
        class_3218 level = ((class_2168)ctx.getSource()).method_9225();
        boolean generate = CommandHelper.getBooleanArg((String)"generate", ctx, () -> false);
        HashSet<class_1792> missing = new HashSet<class_1792>();
        for (class_1792 item : class_7923.field_41178) {
            class_1799 stack = item.method_7854();
            if (MissingCommand.isSoil(stack, (class_1937)level)) continue;
            for (class_8786 crop : Objects.requireNonNull((Map)Crop.RECIPES.apply((class_1937)level)).values()) {
                BasicCrop basic;
                class_1860 class_18602 = crop.comp_1933();
                if (!(class_18602 instanceof BasicCrop) || !(basic = (BasicCrop)class_18602).isValidSoil(stack)) continue;
                missing.add(item);
            }
        }
        MissingCommand.addMissingSoils(level, SOIL_WATER, missing);
        MissingCommand.addMissingSoils(level, SOIL_LAVA, missing);
        MissingCommand.addMissingSoils(level, SOIL_SNOW, missing);
        if (missing.isEmpty()) {
            ((class_2168)ctx.getSource()).method_9226(() -> BotanyPotsCommands.modMessage((class_2561)class_2561.method_43471((String)"commands.botanypots.dump.no_results")), false);
            return 0;
        }
        if (generate) {
            MissingCommand.generateMissingSoils(level, missing);
        }
        StringJoiner entries = new StringJoiner(System.lineSeparator());
        entries.add("Potential missing soil IDs");
        missing.stream().map(arg_0 -> ((class_7922)class_7923.field_41178).method_10221(arg_0)).sorted(Comparator.comparing(class_2960::toString)).forEach(entry -> entries.add(entry.toString()));
        ((class_2168)ctx.getSource()).method_9226(() -> BotanyPotsCommands.modMessage((class_2561)class_2561.method_43469((String)"commands.botanypots.dump.missing_soils", (Object[])new Object[]{class_2561.method_43470((String)Integer.toString(missing.size())).method_27694(style -> style.method_10977(class_124.field_1061))}).method_27694(style -> style.method_10958(new class_2558(class_2558.class_2559.field_21462, entries.toString())))), false);
        return 0;
    }

    private static void generateMissingSoils(class_3218 level, Set<class_1792> missing) {
        File outDir = MissingCommand.setupDir("botanypots/generated/soils");
        for (class_1792 item : missing) {
            class_2960 itemId = class_7923.field_41178.method_10221((Object)item);
            File soilFile = new File(outDir, itemId.method_12836() + "/soil/" + itemId.method_12832() + ".json");
            class_1799 stack = item.method_7854();
            if (stack.method_31573(SOIL_WATER)) {
                MissingCommand.writeFile(soilFile, WATER_SOIL.replace("$item_id$", itemId.toString()));
                continue;
            }
            if (stack.method_31573(SOIL_SNOW)) {
                MissingCommand.writeFile(soilFile, SNOW_SOIL.replace("$item_id$", itemId.toString()));
                continue;
            }
            if (!(item instanceof class_1747)) continue;
            class_1747 blockItem = (class_1747)item;
            MissingCommand.writeFile(soilFile, BLOCK_SOIL.replace("$item_id$", itemId.toString()).replace("$block_id$", class_7923.field_41175.method_10221((Object)blockItem.method_7711()).toString()));
        }
    }

    private static int dumpMissingCrops(CommandContext<class_2168> ctx) {
        boolean includeSaplings = CommandHelper.getBooleanArg((String)"include_saplings", ctx, () -> false);
        boolean generate = CommandHelper.getBooleanArg((String)"generate", ctx, () -> false);
        Set<class_2960> missingCrops = MissingCommand.getMissingCrops((class_1937)((class_2168)ctx.getSource()).method_9225(), includeSaplings);
        if (missingCrops.isEmpty()) {
            ((class_2168)ctx.getSource()).method_9226(() -> BotanyPotsCommands.modMessage((class_2561)class_2561.method_43471((String)"commands.botanypots.dump.no_results")), false);
            return 0;
        }
        if (generate) {
            File outdir = MissingCommand.setupDir("botanypots/generated/crops");
            for (class_2960 itemId : missingCrops) {
                class_1792 item = (class_1792)class_7923.field_41178.method_10223(itemId);
                if (!(item instanceof class_1747)) continue;
                class_1747 blockItem = (class_1747)item;
                class_2960 blockId = class_7923.field_41175.method_10221((Object)blockItem.method_7711());
                File cropFile = new File(outdir, blockId.method_12836() + "/crop/" + blockId.method_12832() + ".json");
                MissingCommand.writeFile(cropFile, SEED_TEMPLATE.replace("$block_id$", blockId.toString()));
            }
            ((class_2168)ctx.getSource()).method_9226(() -> class_2561.method_43471((String)"commands.botanypots.dump.generated").method_27694(style -> style.method_10958(new class_2558(class_2558.class_2559.field_11746, outdir.getAbsolutePath()))), false);
        } else {
            StringJoiner entries = new StringJoiner(System.lineSeparator());
            entries.add("Potential missing crop IDs");
            missingCrops.forEach(entry -> entries.add(entry.toString()));
            ((class_2168)ctx.getSource()).method_9226(() -> BotanyPotsCommands.modMessage((class_2561)class_2561.method_43469((String)"commands.botanypots.dump.missing_crops", (Object[])new Object[]{class_2561.method_43470((String)Integer.toString(missingCrops.size())).method_27694(style -> style.method_10977(class_124.field_1061))}).method_27694(style -> style.method_10958(new class_2558(class_2558.class_2559.field_21462, entries.toString())))), false);
        }
        return 0;
    }

    private static Set<class_2960> getMissingCrops(class_1937 level, boolean includeSaplings) {
        HashSet<class_1792> missingSeedItems = new HashSet<class_1792>();
        block0: for (class_1792 item2 : class_7923.field_41178) {
            if (MissingCommand.isCrop(item2.method_7854(), level) || MissingCommand.isSoil(item2.method_7854(), level) || !(item2 instanceof class_1747)) continue;
            class_1747 itemBlock = (class_1747)item2;
            class_2248 placedBlock = itemBlock.method_7711();
            class_2960 blockId = class_7923.field_41175.method_10221((Object)placedBlock);
            if (placedBlock instanceof class_2302 || placedBlock instanceof class_4863 || placedBlock instanceof class_2256 || placedBlock instanceof class_2473 || placedBlock instanceof class_2261 || placedBlock instanceof class_5809 || placedBlock instanceof class_2230 && !blockId.method_12832().startsWith("dead_")) {
                missingSeedItems.add(item2);
                continue;
            }
            for (class_2769 property : placedBlock.method_9595().method_11659()) {
                if (!property.method_11899().equalsIgnoreCase("age")) continue;
                missingSeedItems.add(item2);
                continue block0;
            }
        }
        Consumer<class_1792> tagProcessor = item -> {
            if (!MissingCommand.isCrop(item.method_7854(), level) && !MissingCommand.isSoil(item.method_7854(), level)) {
                missingSeedItems.add((class_1792)item);
            }
        };
        MissingCommand.processTag(FORGE_SEEDS, tagProcessor);
        MissingCommand.processTag(COMMON_SEEDS, tagProcessor);
        return missingSeedItems.stream().filter(item -> (includeSaplings || !MissingCommand.isSapling(item)) && !Objects.requireNonNull((Set)IGNORED_ITEMS.apply(level)).contains(item)).map(arg_0 -> ((class_7922)class_7923.field_41178).method_10221(arg_0)).sorted(ID_COMPARE).collect(Collectors.toCollection(LinkedHashSet::new));
    }

    private static void processTag(class_6862<class_1792> key, Consumer<class_1792> consumer) {
        class_7923.field_41178.method_40266(key).ifPresent(named -> named.forEach(entry -> consumer.accept((class_1792)entry.comp_349())));
    }

    private static boolean isCrop(class_1799 stack, class_1937 level) {
        return Objects.requireNonNull((RecipeCache)Crop.CACHE.apply(level)).isCached(stack);
    }

    private static boolean isSoil(class_1799 stack, class_1937 level) {
        return Objects.requireNonNull((RecipeCache)Soil.CACHE.apply(level)).isCached(stack);
    }

    private static boolean isFertilizer(class_1799 stack, class_1937 level) {
        return Objects.requireNonNull((RecipeCache)Fertilizer.CACHE.apply(level)).isCached(stack);
    }

    private static boolean isSapling(class_1792 item) {
        class_1747 blockItem;
        return item instanceof class_1747 && (blockItem = (class_1747)item).method_7711() instanceof class_2473;
    }

    private static void addMissingSoils(class_3218 level, class_6862<class_1792> tag, Collection<class_1792> items) {
        MissingCommand.addFromTag(tag, items, item -> !MissingCommand.isSoil(item.method_7854(), (class_1937)level));
    }

    private static void addFromTag(class_6862<class_1792> tag, Collection<class_1792> items, Predicate<class_1792> test) {
        for (class_6880 entry : class_7923.field_41178.method_40286(tag)) {
            if (!test.test((class_1792)entry.comp_349())) continue;
            items.add((class_1792)entry.comp_349());
        }
    }

    private static void writeFile(File file, String text) {
        if (!file.getParentFile().exists()) {
            file.getParentFile().mkdirs();
        }
        try (FileWriter writer = new FileWriter(file);){
            writer.append(text);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static File setupDir(String dir) {
        File file = new File(dir);
        if (file.exists()) {
            try {
                FileUtils.deleteDirectory((File)file);
            }
            catch (Exception e) {
                BotanyPotsMod.LOG.error("Failed to setup dir {}.", (Object)dir, (Object)e);
            }
        }
        file.mkdirs();
        return file;
    }
}

