package net.darkhax.botanypots.common.api.data.recipes.interaction;

import net.darkhax.bookshelf.common.api.function.CachedSupplier;
import net.darkhax.bookshelf.common.api.function.SidedReloadableCache;
import net.darkhax.botanypots.common.api.data.context.BotanyPotContext;
import net.darkhax.botanypots.common.api.data.recipes.BotanyPotRecipe;
import net.darkhax.botanypots.common.api.data.recipes.RecipeCache;
import net.darkhax.botanypots.common.impl.BotanyPotsMod;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2960;
import net.minecraft.class_3956;
import net.minecraft.class_7923;
import net.minecraft.class_8786;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

import java.util.Map;
import java.util.function.Supplier;

/**
 * Represents a special type of interaction that can happen when the player interacts with a botany pot.
 */
public abstract class PotInteraction extends BotanyPotRecipe {

    public static final Supplier<class_3956<PotInteraction>> TYPE = CachedSupplier.of(class_7923.field_41188, BotanyPotsMod.id("pot_interaction")).cast();
    public static final SidedReloadableCache<Map<class_2960, class_8786<PotInteraction>>> RECIPES = SidedReloadableCache.recipes(TYPE);
    public static final SidedReloadableCache<RecipeCache<PotInteraction>> CACHE = RecipeCache.of(TYPE);

    /**
     * Applies the interaction effect to the given context.
     *
     * @param context The current context.
     */
    public abstract void apply(@NotNull BotanyPotContext context);

    @NotNull
    @Override
    public class_3956<?> method_17716() {
        return TYPE.get();
    }

    @Nullable
    public static class_8786<PotInteraction> getInteraction(class_1937 level, BotanyPotContext context, class_1799 stack) {
        final RecipeCache<PotInteraction> cache = CACHE.apply(level);
        return cache != null ? cache.lookup(stack, context, level) : null;
    }
}