/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.botanypots.common.impl;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.serialization.MapCodec;
import java.io.File;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import net.darkhax.bookshelf.common.api.data.conditions.ILoadCondition;
import net.darkhax.bookshelf.common.api.function.CachedSupplier;
import net.darkhax.bookshelf.common.api.registry.ContentProvider;
import net.darkhax.bookshelf.common.api.registry.adapters.GameRegistryAdapter;
import net.darkhax.bookshelf.common.api.registry.adapters.GenericRegistryAdapter;
import net.darkhax.bookshelf.common.api.service.Services;
import net.darkhax.bookshelf.common.impl.registry.adapter.BlockEntityRendererAdapter;
import net.darkhax.bookshelf.common.impl.registry.adapter.BlockRegistryAdapter;
import net.darkhax.bookshelf.common.impl.registry.adapter.BlockRenderTypeAdapter;
import net.darkhax.bookshelf.common.impl.registry.adapter.CreativeModeTabAdapter;
import net.darkhax.bookshelf.common.impl.registry.adapter.MenuScreenAdapter;
import net.darkhax.bookshelf.common.impl.registry.adapter.MenuTypeAdapter;
import net.darkhax.bookshelf.common.impl.registry.adapter.RecipeTypeAdapter;
import net.darkhax.botanypots.common.api.BotanyPotsPlugin;
import net.darkhax.botanypots.common.api.data.components.CropOverride;
import net.darkhax.botanypots.common.api.data.components.SoilOverride;
import net.darkhax.botanypots.common.impl.BotanyPotsMod;
import net.darkhax.botanypots.common.impl.Helpers;
import net.darkhax.botanypots.common.impl.block.BotanyPotBlock;
import net.darkhax.botanypots.common.impl.block.BotanyPotRenderer;
import net.darkhax.botanypots.common.impl.block.PotType;
import net.darkhax.botanypots.common.impl.block.entity.BotanyPotBlockEntity;
import net.darkhax.botanypots.common.impl.block.menu.BotanyPotMenu;
import net.darkhax.botanypots.common.impl.block.menu.BotanyPotScreen;
import net.darkhax.botanypots.common.impl.command.BotanyPotsCommands;
import net.darkhax.botanypots.common.impl.data.BotanyPotFileGenerator;
import net.darkhax.botanypots.common.impl.data.conditions.ConfigLoadCondition;
import net.darkhax.botanypots.common.impl.data.recipe.crop.BasicCrop;
import net.darkhax.botanypots.common.impl.data.recipe.crop.BlockDerivedCrop;
import net.darkhax.botanypots.common.impl.data.recipe.fertilizer.BasicFertilizer;
import net.darkhax.botanypots.common.impl.data.recipe.interaction.BasicPotInteraction;
import net.darkhax.botanypots.common.impl.data.recipe.soil.BasicSoil;
import net.darkhax.botanypots.common.impl.data.recipe.soil.BlockDerivedSoil;
import net.minecraft.class_1320;
import net.minecraft.class_1322;
import net.minecraft.class_1329;
import net.minecraft.class_1767;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1865;
import net.minecraft.class_1921;
import net.minecraft.class_1935;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2248;
import net.minecraft.class_2561;
import net.minecraft.class_2591;
import net.minecraft.class_2960;
import net.minecraft.class_3620;
import net.minecraft.class_3917;
import net.minecraft.class_7157;
import net.minecraft.class_7923;
import net.minecraft.class_9274;
import net.minecraft.class_9300;
import net.minecraft.class_9331;
import net.minecraft.class_9334;

public class BotanyPotsContent
implements ContentProvider {
    public static final Supplier<class_1799> TAB_ICON = CachedSupplier.cache(() -> ((class_1792)class_7923.field_41178.method_10223(BotanyPotsMod.id("terracotta_botany_pot"))).method_7854());
    private static final String[] BRICK_TYPES = new String[]{"brick", "stone", "mossy_stone", "deepslate", "tuff", "mud", "prismarine", "nether", "red_nether", "polished_blackstone", "end_stone", "quartz"};
    private final Map<class_2960, class_2248> allPotBlocks = new LinkedHashMap<class_2960, class_2248>();

    private void generatePotFiles() {
        BotanyPotFileGenerator gen = new BotanyPotFileGenerator(new File("outdir"), "botanypots");
        this.make(gen, "terracotta");
        for (class_1767 class_17672 : class_1767.values()) {
            this.make(gen, class_17672.method_7792() + "_terracotta");
            this.make(gen, class_17672.method_7792() + "_glazed_terracotta");
            this.make(gen, class_17672.method_7792() + "_concrete");
        }
        for (String string : BRICK_TYPES) {
            this.make(gen, (String)(string.equalsIgnoreCase("brick") ? "bricks" : string + "_bricks"));
        }
    }

    private void make(BotanyPotFileGenerator gen, String block) {
        class_2960 blockId = class_2960.method_60656((String)block);
        gen.potRecipes(blockId);
        gen.models(blockId);
        gen.lootTables(blockId);
    }

    public void defineBlocks(BlockRegistryAdapter registry) {
        this.createPots(registry, "terracotta");
        for (class_1767 class_17672 : class_1767.values()) {
            this.createPots(registry, class_17672.method_7792() + "_terracotta");
            this.createPots(registry, class_17672.method_7792() + "_glazed_terracotta");
            this.createPots(registry, class_17672.method_7792() + "_concrete");
        }
        for (String string : BRICK_TYPES) {
            this.createPots(registry, (String)("brick".equals(string) ? "bricks" : string + "_bricks"));
        }
    }

    private void createPots(BlockRegistryAdapter registry, String name) {
        class_2960 blockId = class_2960.method_60656((String)name);
        class_3620 color = class_7923.field_41175.method_10250(blockId) ? ((class_2248)class_7923.field_41175.method_10223(blockId)).method_26403() : class_3620.field_15987;
        this.definePot(registry, name + "_botany_pot", (class_2248)new BotanyPotBlock(color, PotType.BASIC));
        this.definePot(registry, name + "_hopper_botany_pot", (class_2248)new BotanyPotBlock(color, PotType.HOPPER));
        this.definePot(registry, name + "_waxed_botany_pot", (class_2248)new BotanyPotBlock(color, PotType.WAXED));
    }

    private void definePot(BlockRegistryAdapter registry, String id, class_2248 block) {
        class_2960 blockId = class_2960.method_60655((String)this.namespace(), (String)id);
        registry.addPlaceable(id, () -> block);
        this.allPotBlocks.put(blockId, block);
    }

    public void defineBlockEntities(GameRegistryAdapter<class_2591<?>> registry) {
        registry.add("botany_pot", (Object)Services.GAMEPLAY.blockEntityBuilder(BotanyPotBlockEntity::new, (class_2248[])this.allPotBlocks.values().toArray(class_2248[]::new)).method_11034(null));
        ((List)BotanyPotsPlugin.PLUGINS.get()).forEach(BotanyPotsPlugin::registerDisplayTypes);
        ((List)BotanyPotsPlugin.PLUGINS.get()).forEach(BotanyPotsPlugin::registerDropProviders);
        ((List)BotanyPotsPlugin.PLUGINS.get()).forEach(BotanyPotsPlugin::registerGrowthAmountTypes);
    }

    public void defineMenuType(MenuTypeAdapter registry) {
        registry.add("basic_pot_menu", BotanyPotMenu::basicMenuClient);
        registry.add("hopper_pot_menu", BotanyPotMenu::hopperMenuClient);
    }

    public void defineRecipeTypes(RecipeTypeAdapter registry) {
        registry.add("soil");
        registry.add("crop");
        registry.add("pot_interaction");
        registry.add("fertilizer");
    }

    public void defineRecipeSerializers(GameRegistryAdapter<class_1865<?>> registry) {
        registry.add("soil", BasicSoil.SERIALIZER);
        registry.add("block_derived_soil", BlockDerivedSoil.SERIALIZER);
        registry.add("crop", BasicCrop.SERIALIZER);
        registry.add("block_derived_crop", BlockDerivedCrop.SERIALIZER);
        registry.add("pot_interaction", BasicPotInteraction.SERIALIZER);
        registry.add("fertilizer", BasicFertilizer.SERIALIZER);
    }

    public void defineLoadConditions(GenericRegistryAdapter<MapCodec<? extends ILoadCondition>> registry) {
        registry.add(ConfigLoadCondition.TYPE_ID, ConfigLoadCondition.CODEC);
    }

    public void defineCreativeTabs(CreativeModeTabAdapter registry) {
        registry.add("tab", TAB_ICON, (params, builder) -> {
            for (class_2248 block : this.allPotBlocks.values()) {
                builder.method_45421((class_1935)block.method_8389());
            }
            float[] buffs = new float[]{0.25f, 0.5f, 0.75f, 1.0f, 5.0f, 10.0f, 15.0f, 50.0f, 100.0f, 1000.0f};
            class_2960 yieldId = BotanyPotsMod.id("test_yield");
            class_2960 growthId = BotanyPotsMod.id("test_growth");
            for (float buff : buffs) {
                class_1799 yield = new class_1799((class_1935)class_1802.field_8527);
                Helpers.addModifier(yield, Helpers.YIELD_MOD_ATTRIBUTE.get(), new class_1322(yieldId, (double)buff, class_1322.class_1323.field_6328), class_9274.field_49217);
                yield.method_57379(class_9334.field_49630, (Object)new class_9300(true));
                builder.method_45420(yield);
            }
            for (float buff : buffs) {
                class_1799 growth = new class_1799((class_1935)class_1802.field_8303);
                Helpers.addModifier(growth, Helpers.GROWTH_MOD_ATTRIBUTE.get(), new class_1322(growthId, (double)buff, class_1322.class_1323.field_6328), class_9274.field_49217);
                growth.method_57379(class_9334.field_49630, (Object)new class_9300(true));
                builder.method_45420(growth);
            }
            for (float buff : buffs) {
                class_1799 both = new class_1799((class_1935)class_1802.field_22026);
                Helpers.addModifier(both, Helpers.YIELD_MOD_ATTRIBUTE.get(), new class_1322(yieldId, (double)buff, class_1322.class_1323.field_6328), class_9274.field_49217);
                Helpers.addModifier(both, Helpers.GROWTH_MOD_ATTRIBUTE.get(), new class_1322(growthId, (double)buff, class_1322.class_1323.field_6328), class_9274.field_49217);
                both.method_57379(class_9334.field_49630, (Object)new class_9300(true));
                builder.method_45420(both);
            }
        });
    }

    public void defineCommands(CommandDispatcher<class_2168> dispatcher, class_7157 context, class_2170.class_5364 selection) {
        BotanyPotsCommands.build(dispatcher, context, selection);
    }

    public void defineBlockRenderers(BlockEntityRendererAdapter registry) {
        registry.bind((class_2591)BotanyPotBlockEntity.TYPE.get(), BotanyPotRenderer::new);
        ((List)BotanyPotsPlugin.PLUGINS.get()).forEach(BotanyPotsPlugin::bindDisplayRenderers);
    }

    public void defineItemComponents(GameRegistryAdapter<class_9331<?>> registry) {
        registry.add(CropOverride.TYPE_ID.method_12832(), (Object)new class_9331.class_9332().method_57881(CropOverride.CODEC).method_57882(CropOverride.STREAM).method_57880());
        registry.add(SoilOverride.TYPE_ID.method_12832(), (Object)new class_9331.class_9332().method_57881(SoilOverride.CODEC).method_57882(SoilOverride.STREAM).method_57880());
    }

    public void defineMenuScreens(MenuScreenAdapter registry) {
        registry.bind((class_3917)BotanyPotMenu.BASIC_MENU.get(), BotanyPotScreen::new);
        registry.bind((class_3917)BotanyPotMenu.HOPPER_MENU.get(), BotanyPotScreen::new);
    }

    public void defineBlockRenderTypes(BlockRenderTypeAdapter registry) {
        for (class_2248 block : this.allPotBlocks.values()) {
            registry.add(block, class_1921.method_23581());
        }
    }

    public void defineAttributes(GameRegistryAdapter<class_1320> registry) {
        registry.add("growth", (Object)new class_1329("attribute.botanypots.growth", 0.0, -3.4028234663852886E38, 3.4028234663852886E38));
        registry.add("yield", (Object)new class_1329("attribute.botanypots.yield", 0.0, -3.4028234663852886E38, 3.4028234663852886E38));
    }

    public String namespace() {
        return "botanypots";
    }

    public static class_2561 modMessage(class_2561 component) {
        return class_2561.method_43469((String)"commands.botanypots.mod_message", (Object[])new Object[]{component});
    }
}

