package net.darkhax.botanypots.common.impl;

import com.mojang.serialization.Codec;
import io.netty.buffer.ByteBuf;
import net.darkhax.bookshelf.common.api.data.codecs.stream.StreamCodecs;
import net.darkhax.bookshelf.common.api.data.enchantment.EnchantmentLevel;
import net.darkhax.bookshelf.common.api.function.CachedSupplier;
import net.darkhax.bookshelf.common.api.util.DataHelper;
import net.darkhax.bookshelf.common.api.util.MathsHelper;
import net.darkhax.botanypots.common.api.context.BlockEntityContext;
import net.darkhax.botanypots.common.api.context.BotanyPotContext;
import net.darkhax.botanypots.common.api.data.recipes.crop.Crop;
import net.darkhax.botanypots.common.api.data.recipes.soil.Soil;
import net.darkhax.botanypots.common.impl.block.BotanyPotBlock;
import net.minecraft.class_124;
import net.minecraft.class_1299;
import net.minecraft.class_1320;
import net.minecraft.class_1322;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1887;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3532;
import net.minecraft.class_4550;
import net.minecraft.class_5250;
import net.minecraft.class_5455;
import net.minecraft.class_5819;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import net.minecraft.class_9129;
import net.minecraft.class_9135;
import net.minecraft.class_9139;
import net.minecraft.class_9274;
import net.minecraft.class_9285;
import net.minecraft.class_9334;
import org.jetbrains.annotations.Nullable;

import java.util.Optional;
import java.util.function.Supplier;

public class Helpers {

    public static final Codec<class_2248> BLOCK_CODEC = class_2960.field_25139.xmap(class_7923.field_41175::method_10223, class_7923.field_41175::method_10221);
    public static final class_9139<ByteBuf, class_2248> BLOCK_STREAM = class_2960.field_48267.method_56432(class_7923.field_41175::method_10223, class_7923.field_41175::method_10221);
    public static final Codec<class_1792> ITEM_CODEC = class_2960.field_25139.xmap(class_7923.field_41178::method_10223, class_7923.field_41178::method_10221);
    public static final class_9139<ByteBuf, class_1792> ITEM_STREAM = class_2960.field_48267.method_56432(class_7923.field_41178::method_10223, class_7923.field_41178::method_10221);
    public static final Codec<class_1299<?>> ENTITY_TYPE_CODEC = class_2960.field_25139.xmap(class_7923.field_41177::method_10223, class_7923.field_41177::method_10221);
    public static final class_9139<ByteBuf, class_1299<?>> ENTITY_TYPE_STREAM = class_2960.field_48267.method_56432(class_7923.field_41177::method_10223, class_7923.field_41177::method_10221);
    public static final class_9139<ByteBuf, class_2680> BLOCK_STATE_STREAM = class_9135.method_56371(class_2248.field_10651);
    public static final class_9139<class_9129, Optional<class_1856>> OPTIONAL_INGREDIENT_STREAM = DataHelper.optionalStream(StreamCodecs.INGREDIENT_NON_EMPTY);
    public static final class_9139<class_9129, Optional<class_1799>> OPTIONAL_ITEMSTACK_STREAM = DataHelper.optionalStream(class_1799.field_48349);
    public static final class_9139<class_9129, Optional<class_4550>> OPTIONAL_BLOCK_PREDICATE = DataHelper.optionalStream(class_4550.field_49181);
    public static final class_9139<ByteBuf, class_6862<class_2248>> BLOCK_TAG = class_2960.field_48267.method_56432(rl -> class_6862.method_40092(class_7924.field_41254, rl), class_6862::comp_327);
    public static final class_6862<class_1887> INCREASE_POT_GROWTH_TAG = class_6862.method_40092(class_7924.field_41265, BotanyPotsMod.id("increase_pot_growth"));
    public static final class_6862<class_1887> NEGATE_HARVEST_DAMAGE_TAG = class_6862.method_40092(class_7924.field_41265, BotanyPotsMod.id("negate_harvest_damage"));

    public static final Supplier<class_6880<class_1320>> GROWTH_MOD_ATTRIBUTE = CachedSupplier.cache(() -> class_7923.field_41190.method_55841(BotanyPotsMod.id("growth")).orElseThrow());
    public static final String GROWTH_MODIFIER_KEY = "tooltip.botanypots.growth_modifier";
    public static final Supplier<class_6880<class_1320>> YIELD_MOD_ATTRIBUTE = CachedSupplier.cache(() -> class_7923.field_41190.method_55841(BotanyPotsMod.id("yield")).orElseThrow());
    public static final String YIELD_MODIFIER_KEY = "tooltip.botanypots.yield_modifier";


    public static class_2561 modifierComponent(String key, float modifier) {
        if (modifier > 0) {
            return class_2561.method_43469(key, "+" + MathsHelper.DECIMAL_2.format(modifier * 100d) + "%").method_27692(class_124.field_1078);
        }
        return class_2561.method_43469(key, "-" + MathsHelper.DECIMAL_2.format(modifier * 100d) + "%").method_27692(class_124.field_1061);
    }

    public static class_2561 indent(class_2561 base) {
        return class_2561.method_43470("  ").method_10852(base);
    }

    public static int getRequiredGrowthTicks(BotanyPotContext context, class_1937 level, Crop crop, @Nullable Soil soil) {
        final float cropTime = crop.getRequiredGrowthTicks(context, level);
        float growthModifier = BotanyPotsMod.CONFIG.get().gameplay.global_growth_modifier;
        growthModifier += soil != null ? soil.getGrowthModifier(context, level) : 0f;
        growthModifier += efficiencyModifier(level.method_30349(), context.getHarvestItem());
        if (context instanceof BlockEntityContext beContext && beContext.pot().method_11010().method_26204() instanceof BotanyPotBlock potBlock) {
            growthModifier += potBlock.getGrowthModifier(context, level, crop, soil);
        }
        return class_3532.method_15375(cropTime / growthModifier);
    }

    public static float getTotalYield(BotanyPotContext context, class_1937 level, Crop crop, @Nullable Soil soil) {
        final float yieldScale = crop.getYieldScale(context, level);
        float yield = crop.getBaseYield(context, level);
        if (context instanceof BlockEntityContext beContext && beContext.pot().method_11010().method_26204() instanceof BotanyPotBlock potBlock) {
            yield += (yieldScale * potBlock.getYieldModifier(context, level, crop, soil));
        }
        if (soil != null) {
            yield += (yieldScale * soil.getYieldModifier(context, level));
        }
        yield += (yieldScale * (float) getAttributeValue(YIELD_MOD_ATTRIBUTE.get(), context.getHarvestItem(), 0f));
        return yield;
    }

    public static int getLootRolls(BotanyPotContext context, class_1937 level, Crop crop, @Nullable Soil soil) {
        return determineRollCount(getTotalYield(context, level, crop, soil), level.method_8409());
    }

    /**
     * Calculates the amount of rolls that should take place. When chance is over 100% there will be a guaranteed roll
     * for each multiple of 100% plus an additional random chance using the remainder. The amount of rolls determined
     * will never be negative.
     * <p>
     * For example, if the chance is 550% the user will have 5 guaranteed rolls and a 50% chance for a sixth roll.
     *
     * @param chance The chance for rolls to happen.
     * @param rng    An RNG source used to calculate percentages.
     * @return The amount of rolls that was determined. Can never be negative.
     */
    public static int determineRollCount(float chance, class_5819 rng) {
        int guaranteedRolls = (int) Math.floor(chance);
        final float remainingChance = chance % 1f;
        if (rng.method_43057() < remainingChance) {
            guaranteedRolls++;
        }
        return Math.max(0, guaranteedRolls);
    }

    public static int chanceToInt(float chance) {
        return (int) Math.floor(chance * 100f);
    }

    public static class_5250 withScale(class_5250 base, float scale) {
        if (scale != 1f) {
            base.method_27693(" (").method_10852(class_2561.method_43469("tooltip.botanypots.percent", chanceToInt(scale)).method_27692(scale > 1f ? class_124.field_1060 : class_124.field_1061)).method_27693(")");
        }
        return base;
    }

    public static float efficiencyModifier(class_5455 registryAccess, class_1799 stack) {
        float modifier = 0f;
        modifier += EnchantmentLevel.HIGHEST.get(INCREASE_POT_GROWTH_TAG, stack) * BotanyPotsMod.CONFIG.get().gameplay.efficiency_growth_modifier;
        modifier += (float) getAttributeValue(GROWTH_MOD_ATTRIBUTE.get(), stack, 0f);
        return modifier;
    }

    public static double getAttributeValue(class_6880<class_1320> attribute, class_1799 stack, float defaultValue) {
        double value = 0d;
        final class_9285 modifiers = stack.method_57825(class_9334.field_49636, class_9285.field_49326);
        for (class_9285.class_9287 entry : modifiers.comp_2393()) {
            if (entry.comp_2395() == attribute) {
                final double entryAmount = entry.comp_2396().comp_2449();
                value += switch (entry.comp_2396().comp_2450()) {
                    case field_6328 -> entryAmount;
                    case field_6330 -> entryAmount * defaultValue;
                    case field_6331 -> entryAmount * value;
                };
            }
        }
        return value;
    }

    public static boolean contains(String input, String... matches) {
        for (String match : matches) {
            if (input.contains(match)) {
                return true;
            }
        }
        return false;
    }


    public static class_1799 addModifier(class_1799 stack, class_6880<class_1320> attribute, class_1322 modifier, class_9274 group) {
        class_9285 component = stack.method_57825(class_9334.field_49636, class_9285.field_49326);
        component = component.method_57484(attribute, modifier, group);
        stack.method_57379(class_9334.field_49636, component);
        return stack;
    }
}