package net.darkhax.botanypots.common.impl.data.display.renderer;

import net.darkhax.bookshelf.common.api.util.IRenderHelper;
import net.darkhax.botanypots.common.api.data.display.math.TintColor;
import net.darkhax.botanypots.common.api.data.display.render.AbstractDisplayRenderer;
import net.darkhax.botanypots.common.api.data.display.types.RenderOptions;
import net.darkhax.botanypots.common.impl.block.entity.BotanyPotBlockEntity;
import net.darkhax.botanypots.common.impl.data.display.types.SimpleDisplayState;
import net.minecraft.class_1087;
import net.minecraft.class_1921;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2464;
import net.minecraft.class_2680;
import net.minecraft.class_310;
import net.minecraft.class_3610;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_5614;
import net.minecraft.class_5819;
import net.minecraft.class_777;
import java.util.List;
import java.util.Optional;
import java.util.Set;

public final class SimpleDisplayStateRenderer extends AbstractDisplayRenderer<SimpleDisplayState, RenderOptions> {

    public static final SimpleDisplayStateRenderer RENDERER = new SimpleDisplayStateRenderer();

    @Override
    public RenderOptions getRenderOptions(SimpleDisplayState display) {
        return display.renderOptions();
    }

    @Override
    public void render(class_5614.class_5615 context, SimpleDisplayState display, RenderOptions renderOptions, class_4587 pose, class_1937 level, class_2338 pos, float tickDelta, class_4597 bufferSource, int light, int overlay, BotanyPotBlockEntity pot, float progress, float growthScale, float heightOffset) {
        final class_2680 blockState = display.getState();
        if (display.renderOptions().shouldRenderFluid()) {
            final class_3610 fluidState = blockState.method_26227();
            if (!fluidState.method_15769()) {
                IRenderHelper.GET.renderFluidBox(pose, fluidState, level, pos, bufferSource, light, class_4608.field_21444);
            }
        }
        renderBlockState(blockState, context, pose, level, pos, bufferSource, display.renderOptions().getColor(), light, overlay, renderOptions.getFaces());
    }

    public static void renderBlockState(class_2680 blockState, class_5614.class_5615 context, class_4587 pose, class_1937 level, class_2338 pos, class_4597 bufferSource, Optional<TintColor> tintColor, int light, int overlay, Set<class_2350> faces) {
        if (blockState.method_26217() == class_2464.field_11458) {
            final class_1087 blockModel = class_310.method_1551().method_1541().method_3349(blockState);
            final class_4588 builder = bufferSource.getBuffer(class_1921.method_23581());
            renderModel(blockState, level, pos, pose.method_23760(), builder, blockModel, tintColor, light, class_4608.field_21444, faces);
        }
    }

    private static void renderModel(class_2680 blockState, class_1937 level, class_2338 pos, class_4587.class_4665 pose, class_4588 consumer, class_1087 model, Optional<TintColor> tintColor, int packedLight, int packedOverlay, Set<class_2350> faces) {
        class_5819 randomsource = class_5819.method_43047();
        for (class_2350 direction : faces) {
            randomsource.method_43052(42);
            renderQuadList(blockState, level, pos, pose, consumer, tintColor, model.method_4707(blockState, direction, randomsource), packedLight, packedOverlay);
        }
        randomsource.method_43052(42);
        renderQuadList(blockState, level, pos, pose, consumer, tintColor, model.method_4707(blockState, null, randomsource), packedLight, packedOverlay);
    }

    private static void renderQuadList(class_2680 blockState, class_1937 level, class_2338 pos, class_4587.class_4665 pose, class_4588 consumer, Optional<TintColor> tintColor, List<class_777> quads, int packedLight, int packedOverlay) {
        for (class_777 bakedQuad : quads) {
            float[] argb = {1f, 1f, 1f, 1f};
            if (tintColor.isPresent()) {
                argb = tintColor.get().asPercents();
            }
            else if (bakedQuad.method_3360()) {
                final int worldTint = class_310.method_1551().method_1505().method_1697(blockState, level, pos, bakedQuad.method_3359());
                argb = new float[]{1f, (float) (worldTint >> 16 & 0xFF) / 255f, (float) (worldTint >> 8 & 0xFF) / 255f, (float) (worldTint & 0xFF) / 255f};
            }
            consumer.method_22919(pose, bakedQuad, argb[1], argb[2], argb[3], argb[0], packedLight, packedOverlay);
        }
    }
}