package net.darkhax.botanypots.common.impl.command;

import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import net.darkhax.bookshelf.common.api.function.CachedSupplier;
import net.darkhax.botanypots.common.api.data.recipes.crop.Crop;
import net.darkhax.botanypots.common.impl.BotanyPotsMod;
import net.darkhax.botanypots.common.impl.block.entity.BotanyPotBlockEntity;
import net.darkhax.botanypots.common.impl.data.recipe.crop.BasicCrop;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1893;
import net.minecraft.class_1937;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_5455;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import net.minecraft.class_8786;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;

public class InvalidCrops {

    private static final CachedSupplier<class_2248> potBlockType = CachedSupplier.of(class_7923.field_41175, BotanyPotsMod.id("terracotta_hopper_botany_pot"));

    public static void build(LiteralArgumentBuilder<class_2168> parent) {
        final LiteralArgumentBuilder<class_2168> cmd = class_2170.method_9247("check_crops");
        cmd.executes(InvalidCrops::execute);
        parent.then(cmd);
    }

    private static int execute(CommandContext<class_2168> ctx) throws CommandSyntaxException {
        final class_2338 targetPos = ctx.getSource().method_9229().method_23312();
        final class_1937 level = ctx.getSource().method_9225();
        level.method_8652(targetPos, potBlockType.get().method_9564(), 3);
        final BotanyPotBlockEntity potEntity = (BotanyPotBlockEntity) level.method_8321(targetPos);
        if (potEntity == null) {
            throw new IllegalStateException("Test pot was null!");
        }
        final Set<Map.Entry<class_1792, class_8786<Crop>>> crops = Objects.requireNonNull(Crop.CACHE.apply(ctx.getSource().method_9225())).getCachedValues().entries().stream().sorted(Comparator.comparing(s -> class_7923.field_41178.method_10221(s.getKey()).toString())).collect(Collectors.toCollection(LinkedHashSet::new));
        final List<class_1799> toolList = buildToolList(ctx.getSource().method_30497());
        int errorCount = 0;
        cropLoop:
        for (Map.Entry<class_1792, class_8786<Crop>> cropEntry : crops) {
            final Crop crop = cropEntry.getValue().comp_1933();
            potEntity.method_5448();
            final class_1799 firstSoil = findFirstSoil(crop);
            if (firstSoil.method_7960()) {
                BotanyPotsMod.LOG.error("Could not find a valid soil for crop '{}'!", cropEntry.getValue().comp_1932());
                errorCount++;
                continue;
            }
            potEntity.method_5447(0, findFirstSoil(crop));
            potEntity.method_5447(1, cropEntry.getKey().method_7854());
            for (class_1799 tool : toolList) {
                potEntity.method_5447(2, tool.method_7972());
                final List<class_1799> items = new ArrayList<>();
                for (int i = 0; i < 1000; i++) {
                    potEntity.updateGrowthTime(potEntity.getRequiredGrowthTicks());
                    crop.onHarvest(potEntity.getRecipeContext(), level, items::add);
                    if (!items.isEmpty()) {
                        continue cropLoop;
                    }
                }
            }
            errorCount++;
            BotanyPotsMod.LOG.error("Crop '{}' did not drop any items!", cropEntry.getValue().comp_1932());
        }
        if (errorCount > 0) {
            ctx.getSource().method_9213(class_2561.method_43469("commands.botanypots.debug.crop_errors", crops.size(), errorCount));
        }
        else {
            ctx.getSource().method_9226(() -> class_2561.method_43469("commands.botanypots.debug.crop_success", crops.size()), false);
        }
        return errorCount;
    }

    private static class_1799 findFirstSoil(Crop crop) {
        if (crop instanceof BasicCrop basic) {
            for (class_1792 item : class_7923.field_41178) {
                final class_1799 stack = item.method_7854();
                if (basic.getBasicProperties().soil().method_8093(stack)) {
                    return stack;
                }
            }
        }
        return class_1799.field_8037;
    }

    private static List<class_1799> buildToolList(class_5455 registries) {
        final List<class_1799> tools = new ArrayList<>();
        tools.add(class_1799.field_8037);
        tools.add(withSilkTouch(class_1802.field_8868, registries));
        tools.add(withSilkTouch(class_1802.field_22026, registries));
        tools.add(withSilkTouch(class_1802.field_22024, registries));
        tools.add(withSilkTouch(class_1802.field_22025, registries));
        tools.add(withSilkTouch(class_1802.field_22022, registries));
        tools.add(withSilkTouch(class_1802.field_22023, registries));
        return tools;
    }

    private static class_1799 withSilkTouch(class_1792 item, class_5455 registries) {
        final class_1799 stack = item.method_7854();
        stack.method_7978(registries.method_30530(class_7924.field_41265).method_40264(class_1893.field_9099).orElseThrow(), 1);
        return stack;
    }
}