package net.darkhax.botanypots.common.api.data.recipes;

import com.mojang.serialization.Codec;
import net.darkhax.botanypots.common.api.data.context.BotanyPotContext;
import net.minecraft.class_1799;
import net.minecraft.class_1860;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import net.minecraft.class_3956;
import net.minecraft.class_7225;
import net.minecraft.class_9129;
import net.minecraft.class_9139;
import org.jetbrains.annotations.NotNull;

import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;

/**
 * The base class for all recipes that use a botany pot.
 */
public abstract class BotanyPotRecipe implements class_1860<BotanyPotContext> {

    /**
     * Tests if the recipe is valid for the current context.
     *
     * @param candidate The item to test.
     * @param context   The current context.
     * @param level     The current game level.
     * @return If the recipe is valid.
     */
    public abstract boolean couldMatch(class_1799 candidate, BotanyPotContext context, class_1937 level);

    @NotNull
    @Override
    public class_1799 assemble(@NotNull BotanyPotContext input, @NotNull class_7225.class_7874 provider) {
        return class_1799.field_8037;
    }

    @NotNull
    @Override
    public class_1799 method_8110(class_7225.@NotNull class_7874 provider) {
        return class_1799.field_8037;
    }

    @Override
    public boolean method_8113(int width, int height) {
        return true;
    }

    @Override
    public boolean method_8118() {
        return true;
    }

    @Override
    public boolean method_49188() {
        return false;
    }

    /**
     * Populates a tooltip when the item is hovered in a botany pot.
     *
     * @param stack        The ItemStack being hovered.
     * @param context      The context of the current situation.
     * @param level        The current game level.
     * @param tooltipLines The list of tooltips being displayed.
     */
    public void hoverTooltip(class_1799 stack, BotanyPotContext context, class_1937 level, Consumer<class_2561> tooltipLines) {
        // No-Op
    }

    /**
     * Creates a codec for a recipe of a specific type.
     *
     * @param recipeType The type of recipe to serialize.
     * @param <T>        The type of the recipe.
     * @return A codec that serializes recipes of a given type.
     */
    public static <T extends class_1860<?>> Codec<T> recipeCodec(Supplier<class_3956<T>> recipeType) {
        return Codec.lazyInitialized(() -> class_1860.field_47319.xmap(recipe -> (T) recipe, Function.identity()));
    }

    /**
     * Creates a stream codec for a recipe of a specific type.
     *
     * @param recipeType The type of recipe to serialize.
     * @param <T>        A stream codec that serializes recipes of a given type.
     * @return The type of the recipe.
     */
    public static <T extends class_1860<?>> class_9139<class_9129, T> recipeStream(Supplier<class_3956<T>> recipeType) {
        return class_9139.method_56437(class_1860.field_48356::encode, buf -> (T) class_1860.field_48356.decode(buf));
    }
}