package net.darkhax.botanypots.common.api.data.recipes.soil;

import net.darkhax.bookshelf.common.api.function.CachedSupplier;
import net.darkhax.bookshelf.common.api.function.SidedReloadableCache;
import net.darkhax.botanypots.common.api.context.BotanyPotContext;
import net.darkhax.botanypots.common.api.data.display.types.Display;
import net.darkhax.botanypots.common.api.data.recipes.BotanyPotRecipe;
import net.darkhax.botanypots.common.api.data.recipes.RecipeCache;
import net.darkhax.botanypots.common.impl.BotanyPotsMod;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2960;
import net.minecraft.class_3956;
import net.minecraft.class_7923;
import net.minecraft.class_8786;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

import java.util.Map;
import java.util.function.Supplier;

/**
 * Represents additional properties for a soil in a botany pot.
 */
public abstract class Soil extends BotanyPotRecipe {

    public static final class_2960 TYPE_ID = BotanyPotsMod.id("soil");
    public static final Supplier<class_3956<Soil>> TYPE = CachedSupplier.of(class_7923.field_41188, TYPE_ID).cast();
    public static final SidedReloadableCache<Map<class_2960, class_8786<Soil>>> RECIPES = SidedReloadableCache.recipes(TYPE);
    public static final SidedReloadableCache<RecipeCache<Soil>> CACHE = RecipeCache.of(TYPE);

    /**
     * Gets the modifier to apply to the crop growth rate.
     *
     * @param context The current context.
     * @param level   The current game level.
     * @return The growth modifier of the soil.
     */
    public abstract float getGrowthModifier(@NotNull BotanyPotContext context, @NotNull class_1937 level);

    /**
     * Gets the light level emitted by the soil.
     *
     * @param context The current context.
     * @param level   The current game level.
     * @return The light level emitted by the soil.
     */
    public abstract int getLightLevel(@NotNull BotanyPotContext context, @NotNull class_1937 level);

    /**
     * Gets the display for the soil.
     *
     * @param context The current context.
     * @param level   The current game level.
     * @return The display for the soil.
     */
    public abstract Display getDisplay(BotanyPotContext context, @NotNull class_1937 level);

    /**
     * An optional hook that fires every tick the soil is in a botany pot.
     *
     * @param context The current context.
     * @param level   The current game level.
     */
    public void onTick(BotanyPotContext context, class_1937 level) {
        // No op
    }

    /**
     * Gets a modifier that will be added to the chance that a crop will drop items when harvested. If the chance
     * exceeds 100% additional rolls can happen.
     *
     * @param context The context of the crop being grown.
     * @param level   The game level this is happening in.
     * @return The drop chance modifier to add to the base chance.
     */
    public float getYieldModifier(BotanyPotContext context, class_1937 level) {
        return 0f;
    }

    @NotNull
    @Override
    public class_3956<?> method_17716() {
        return TYPE.get();
    }

    /**
     * Gets the soil that best represents a given item stack.
     *
     * @param level   The current game level.
     * @param context The current context.
     * @param stack   The item to lookup.
     * @return The soil that best represents the given item stack.
     */
    @Nullable
    public static class_8786<Soil> getSoil(class_1937 level, BotanyPotContext context, class_1799 stack) {
        final RecipeCache<Soil> cache = CACHE.apply(level);
        return cache != null ? cache.lookup(stack, context, level) : null;
    }
}