package net.darkhax.botanypots.common.impl.data.display.types;

import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.darkhax.bookshelf.common.api.function.CachedSupplier;
import net.darkhax.botanypots.common.api.data.display.types.AbstractDisplay;
import net.darkhax.botanypots.common.api.data.display.types.DisplayType;
import net.darkhax.botanypots.common.impl.BotanyPotsMod;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_9139;

public class TexturedCubeDisplayState extends AbstractDisplay<BasicOptions> {

    public static final class_2960 TYPE_ID = BotanyPotsMod.id("textured_cube");
    public static final CachedSupplier<DisplayType<TexturedCubeDisplayState>> TYPE = CachedSupplier.cache(() -> DisplayType.get(TYPE_ID));
    public static final MapCodec<TexturedCubeDisplayState> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group(
            class_2960.field_25139.fieldOf("texture").forGetter(TexturedCubeDisplayState::getTexture),
            BasicOptions.CODEC.optionalFieldOf("options", BasicOptions.ofDefault()).forGetter(TexturedCubeDisplayState::renderOptions)
    ).apply(instance, TexturedCubeDisplayState::new));
    public static final class_9139<class_2540, TexturedCubeDisplayState> STREAM = class_9139.method_56435(class_2960.field_48267, TexturedCubeDisplayState::getTexture, BasicOptions.STREAM, TexturedCubeDisplayState::renderOptions, TexturedCubeDisplayState::new);

    private final class_2960 texture;

    public TexturedCubeDisplayState(class_2960 texture, BasicOptions options) {
        super(options);
        this.texture = texture;
    }

    public class_2960 getTexture() {
        return this.texture;
    }

    @Override
    public DisplayType<?> getType() {
        return TYPE.get();
    }
}