package net.darkhax.botanypots.common.impl;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.serialization.MapCodec;
import net.darkhax.bookshelf.common.api.data.conditions.ILoadCondition;
import net.darkhax.bookshelf.common.api.function.CachedSupplier;
import net.darkhax.bookshelf.common.api.registry.IContentProvider;
import net.darkhax.bookshelf.common.api.registry.register.ItemComponentRegister;
import net.darkhax.bookshelf.common.api.registry.register.MenuRegister;
import net.darkhax.bookshelf.common.api.registry.register.Register;
import net.darkhax.bookshelf.common.api.registry.register.RegisterBlockEntityRenderer;
import net.darkhax.bookshelf.common.api.registry.register.RegisterItem;
import net.darkhax.bookshelf.common.api.registry.register.RegisterItemTab;
import net.darkhax.bookshelf.common.api.registry.register.RegisterMenuScreen;
import net.darkhax.bookshelf.common.api.registry.register.RegisterRecipeType;
import net.darkhax.bookshelf.common.api.service.Services;
import net.darkhax.botanypots.common.api.BotanyPotsPlugin;
import net.darkhax.botanypots.common.api.data.components.CropOverride;
import net.darkhax.botanypots.common.api.data.components.SoilOverride;
import net.darkhax.botanypots.common.impl.block.BotanyPotBlock;
import net.darkhax.botanypots.common.impl.block.BotanyPotRenderer;
import net.darkhax.botanypots.common.impl.block.PotType;
import net.darkhax.botanypots.common.impl.block.entity.BotanyPotBlockEntity;
import net.darkhax.botanypots.common.impl.block.menu.BotanyPotMenu;
import net.darkhax.botanypots.common.impl.block.menu.BotanyPotScreen;
import net.darkhax.botanypots.common.impl.command.BotanyPotsCommands;
import net.darkhax.botanypots.common.impl.data.BotanyPotFileGenerator;
import net.darkhax.botanypots.common.impl.data.conditions.ConfigLoadCondition;
import net.darkhax.botanypots.common.impl.data.recipe.crop.BasicCrop;
import net.darkhax.botanypots.common.impl.data.recipe.crop.BlockDerivedCrop;
import net.darkhax.botanypots.common.impl.data.recipe.fertilizer.BasicFertilizer;
import net.darkhax.botanypots.common.impl.data.recipe.interaction.BasicPotInteraction;
import net.darkhax.botanypots.common.impl.data.recipe.soil.BasicSoil;
import net.darkhax.botanypots.common.impl.data.recipe.soil.BlockDerivedSoil;
import net.minecraft.class_1320;
import net.minecraft.class_1322;
import net.minecraft.class_1329;
import net.minecraft.class_1767;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1865;
import net.minecraft.class_1921;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2248;
import net.minecraft.class_2561;
import net.minecraft.class_2591;
import net.minecraft.class_2960;
import net.minecraft.class_3620;
import net.minecraft.class_6880;
import net.minecraft.class_7157;
import net.minecraft.class_7923;
import net.minecraft.class_9274;
import net.minecraft.class_9285;
import net.minecraft.class_9300;
import net.minecraft.class_9331;
import net.minecraft.class_9334;
import java.io.File;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;

public class BotanyPotsContent implements IContentProvider {

    public static final Supplier<class_1799> TAB_ICON = CachedSupplier.cache(() -> class_7923.field_41178.method_10223(BotanyPotsMod.id("terracotta_botany_pot")).method_7854());
    private static final String[] BRICK_TYPES = {"brick", "stone", "mossy_stone", "deepslate", "tuff", "mud", "prismarine", "nether", "red_nether", "polished_blackstone", "end_stone", "quartz"};
    private final Map<class_2960, class_2248> allPotBlocks = new LinkedHashMap<>();

    public BotanyPotsContent() {
        //generatePotFiles();
    }

    private void generatePotFiles() {
        final BotanyPotFileGenerator gen = new BotanyPotFileGenerator(new File("outdir"), BotanyPotsMod.MOD_ID);
        make(gen, "terracotta");
        for (class_1767 color : class_1767.values()) {
            make(gen, color.method_7792() + "_terracotta");
            make(gen, color.method_7792() + "_glazed_terracotta");
            make(gen, color.method_7792() + "_concrete");
        }
        for (String brickType : BRICK_TYPES) {
            make(gen, brickType.equalsIgnoreCase("brick") ? "bricks" : brickType + "_bricks");
        }
    }

    private void make(BotanyPotFileGenerator gen, String block) {
        final class_2960 blockId = class_2960.method_60656(block);
        gen.potRecipes(blockId);
        gen.models(blockId);
        gen.lootTables(blockId);
    }

    @Override
    public void registerBlocks(Register<class_2248> registry) {
        createPots(registry, "terracotta");
        for (class_1767 color : class_1767.values()) {
            createPots(registry, color.method_7792() + "_terracotta");
            createPots(registry, color.method_7792() + "_glazed_terracotta");
            createPots(registry, color.method_7792() + "_concrete");
        }
        for (String brickType : BRICK_TYPES) {
            createPots(registry, "brick".equals(brickType) ? "bricks" : brickType + "_bricks");
        }
    }

    private void createPots(Register<class_2248> registry, String name) {
        final class_2960 blockId = class_2960.method_60656(name);
        final class_3620 color = class_7923.field_41175.method_10250(blockId) ? class_7923.field_41175.method_10223(blockId).method_26403() : class_3620.field_15987;
        registerPot(registry, name + "_botany_pot", new BotanyPotBlock(color, PotType.BASIC));
        registerPot(registry, name + "_hopper_botany_pot", new BotanyPotBlock(color, PotType.HOPPER));
        registerPot(registry, name + "_waxed_botany_pot", new BotanyPotBlock(color, PotType.WAXED));
    }

    private void registerPot(Register<class_2248> registry, String id, class_2248 block) {
        final class_2960 blockId = class_2960.method_60655(this.contentNamespace(), id);
        registry.add(blockId, block);
        allPotBlocks.put(blockId, block);
    }

    @Override
    public void registerItems(RegisterItem registry) {
        for (Map.Entry<class_2960, class_2248> block : allPotBlocks.entrySet()) {
            registry.addBlock(block.getValue());
        }
    }

    @Override
    public void registerBlockEntities(Register<class_2591.class_2592<?>> registry) {
        registry.add("botany_pot", Services.GAMEPLAY.blockEntityBuilder(BotanyPotBlockEntity::new, this.allPotBlocks.values().toArray(class_2248[]::new)));
        BotanyPotsPlugin.PLUGINS.get().forEach(BotanyPotsPlugin::registerDisplayTypes);
        BotanyPotsPlugin.PLUGINS.get().forEach(BotanyPotsPlugin::registerDropProviders);
        BotanyPotsPlugin.PLUGINS.get().forEach(BotanyPotsPlugin::registerGrowthAmountTypes);
    }

    @Override
    public void registerMenus(MenuRegister registry) {
        registry.add("basic_pot_menu", BotanyPotMenu::basicMenuClient);
        registry.add("hopper_pot_menu", BotanyPotMenu::hopperMenuClient);
    }

    @Override
    public void registerRecipeTypes(RegisterRecipeType registry) {
        registry.add("soil");
        registry.add("crop");
        registry.add("pot_interaction");
        registry.add("fertilizer");
    }

    @Override
    public void registerRecipeSerializers(Register<class_1865<?>> registry) {
        registry.add("soil", BasicSoil.SERIALIZER);
        registry.add("block_derived_soil", BlockDerivedSoil.SERIALIZER);
        registry.add("crop", BasicCrop.SERIALIZER);
        registry.add("block_derived_crop", BlockDerivedCrop.SERIALIZER);
        registry.add("pot_interaction", BasicPotInteraction.SERIALIZER);
        registry.add("fertilizer", BasicFertilizer.SERIALIZER);
    }

    @Override
    public void registerLoadConditions(Register<MapCodec<? extends ILoadCondition>> registry) {
        registry.add(ConfigLoadCondition.TYPE_ID, ConfigLoadCondition.CODEC);
    }

    @Override
    public void registerItemTabs(RegisterItemTab registry) {
        registry.add("tab", TAB_ICON, (params, builder) -> {
            for (class_2248 block : this.allPotBlocks.values()) {
                builder.method_45421(block.method_8389());
            }
            final float[] buffs = {0.25f, 0.5f, 0.75f, 1f, 5f, 10f, 15f, 50f, 100f, 1000f};
            final class_2960 yieldId = BotanyPotsMod.id("test_yield");
            final class_2960 growthId = BotanyPotsMod.id("test_growth");
            for (float buff : buffs) {
                final class_1799 yield = new class_1799(class_1802.field_8527);
                addModifier(yield, Helpers.YIELD_MOD_ATTRIBUTE.get(), new class_1322(yieldId, buff, class_1322.class_1323.field_6328), class_9274.field_49217);
                yield.method_57379(class_9334.field_49630, new class_9300(true));
                builder.method_45420(yield);
            }
            for (float buff : buffs) {
                final class_1799 growth = new class_1799(class_1802.field_8303);
                addModifier(growth, Helpers.GROWTH_MOD_ATTRIBUTE.get(), new class_1322(growthId, buff, class_1322.class_1323.field_6328), class_9274.field_49217);
                growth.method_57379(class_9334.field_49630, new class_9300(true));
                builder.method_45420(growth);
            }
            for (float buff : buffs) {
                final class_1799 both = new class_1799(class_1802.field_22026);
                addModifier(both, Helpers.YIELD_MOD_ATTRIBUTE.get(), new class_1322(yieldId, buff, class_1322.class_1323.field_6328), class_9274.field_49217);
                addModifier(both, Helpers.GROWTH_MOD_ATTRIBUTE.get(), new class_1322(growthId, buff, class_1322.class_1323.field_6328), class_9274.field_49217);
                both.method_57379(class_9334.field_49630, new class_9300(true));
                builder.method_45420(both);
            }
        });
    }

    private static class_1799 addModifier(class_1799 stack, class_6880<class_1320> attribute, class_1322 modifier, class_9274 group) {
        class_9285 component = stack.method_57825(class_9334.field_49636, class_9285.field_49326);
        component = component.method_57484(attribute, modifier, group);
        stack.method_57379(class_9334.field_49636, component);
        return stack;
    }

    @Override
    public void registerCommands(CommandDispatcher<class_2168> dispatcher, class_7157 context, class_2170.class_5364 selection) {
        BotanyPotsCommands.build(dispatcher, context, selection);
    }

    @Override
    public void bindBlockEntityRenderer(RegisterBlockEntityRenderer registry) {
        registry.bind(BotanyPotBlockEntity.TYPE.get(), BotanyPotRenderer::new);
        BotanyPotsPlugin.PLUGINS.get().forEach(BotanyPotsPlugin::bindDisplayRenderers);
    }

    @Override
    public void registerItemComponents(ItemComponentRegister registry) {
        registry.accept(CropOverride.TYPE_ID, (UnaryOperator<class_9331.class_9332<CropOverride>>) b -> b.method_57881(CropOverride.CODEC).method_57882(CropOverride.STREAM));
        registry.accept(SoilOverride.TYPE_ID, (UnaryOperator<class_9331.class_9332<SoilOverride>>) b -> b.method_57881(SoilOverride.CODEC).method_57882(SoilOverride.STREAM));
    }

    @Override
    public void registerMenuScreens(RegisterMenuScreen registry) {
        registry.bind(BotanyPotMenu.BASIC_MENU.get(), BotanyPotScreen::new);
        registry.bind(BotanyPotMenu.HOPPER_MENU.get(), BotanyPotScreen::new);
    }

    @Override
    public void bindRenderLayers(BiConsumer<class_2248, class_1921> registry) {
        for (class_2248 block : this.allPotBlocks.values()) {
            registry.accept(block, class_1921.method_23581());
        }
    }

    @Override
    public void registerAttributes(Register<class_1320> registry) {
        // TODO Write a mixin to display these as a percentage in tooltips
        registry.add("growth", new class_1329("attribute.botanypots.growth", 0f, -Float.MAX_VALUE, Float.MAX_VALUE));
        registry.add("yield", new class_1329("attribute.botanypots.yield", 0f, -Float.MAX_VALUE, Float.MAX_VALUE));
    }

    @Override
    public String contentNamespace() {
        return BotanyPotsMod.MOD_ID;
    }

    public static class_2561 modMessage(class_2561 component) {
        return class_2561.method_43469("commands.botanypots.mod_message", component);
    }
}
