package net.darkhax.botanypots.common.api.data;

import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.darkhax.bookshelf.common.api.data.codecs.map.MapCodecs;
import net.minecraft.class_1657;
import net.minecraft.class_2338;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import net.minecraft.class_3419;
import net.minecraft.class_6880;
import net.minecraft.class_9129;
import net.minecraft.class_9139;
import java.util.Optional;

public record SoundEffect(class_6880<class_3414> sound, class_3419 source, float volume, float pitch) {

    public static final MapCodec<SoundEffect> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group(
            class_3414.field_41699.fieldOf("id").forGetter(SoundEffect::sound),
            MapCodecs.enumerable(class_3419.class).optionalFieldOf("category", class_3419.field_15250).forGetter(SoundEffect::source),
            Codec.FLOAT.optionalFieldOf("volume", 1f).forGetter(SoundEffect::volume),
            Codec.FLOAT.optionalFieldOf("pitch", 1f).forGetter(SoundEffect::pitch)
    ).apply(instance, SoundEffect::new));

    public static final class_9139<class_9129, SoundEffect> STREAM = class_9139.method_56437(
            (buf, val) -> {
                class_3414.field_48279.encode(buf, val.sound);
                buf.method_10817(val.source);
                buf.method_52941(val.volume);
                buf.method_52941(val.pitch);
            },
            buf -> {
                final class_6880<class_3414> sound = class_3414.field_48279.decode(buf);
                final class_3419 source = buf.method_10818(class_3419.class);
                final float volume = buf.readFloat();
                final float pitch = buf.readFloat();
                return new SoundEffect(sound, source, volume, pitch);
            }
    );

    public static final class_9139<class_9129, Optional<SoundEffect>> OPTIONAL_STREAM = class_9139.method_56437(
            (buf, val) -> {
                buf.method_52964(val.isPresent());
                val.ifPresent(soundEffect -> SoundEffect.STREAM.encode(buf, soundEffect));
            },
            buf -> {
                final boolean isPresent = buf.readBoolean();
                return isPresent ? Optional.of(SoundEffect.STREAM.decode(buf)) : Optional.empty();
            }
    );

    public void playSound(class_3218 level, class_1657 player, class_2338 pos) {
        this.playSound(level, player, pos.method_10263() + 0.5f, pos.method_10264() + 0.5f, pos.method_10260() + 0.5f);
    }

    public void playSound(class_3218 level, class_1657 player, float x, float y, float z) {
        level.method_60511(player, x, y, z, this.sound, this.source, this.volume, this.pitch);
    }
}
