package net.darkhax.botanypots.common.api.context;

import net.darkhax.bookshelf.common.api.PhysicalSide;
import net.darkhax.bookshelf.common.api.annotation.OnlyFor;
import net.darkhax.botanypots.common.api.data.recipes.crop.Crop;
import net.darkhax.botanypots.common.api.data.recipes.soil.Soil;
import net.darkhax.botanypots.common.impl.Helpers;
import net.darkhax.botanypots.common.impl.block.entity.BotanyPotBlockEntity;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_8567;
import net.minecraft.class_8786;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

import java.util.List;
import java.util.Objects;

/**
 * Recipe context that is provided when a pot is not available. This context should only be used on the client in
 * contexts like a JEI plugin.
 *
 * @param inventory A list of items simulating the inventory of a botany pot. This is not an actual inventory, only an
 *                  immutable simulation.
 */
@OnlyFor(PhysicalSide.CLIENT)
public record DisplayContext(List<class_1799> inventory) implements BotanyPotContext {

    @Override
    public class_1799 getSoilItem() {
        return inventory.get(BotanyPotBlockEntity.SOIL_SLOT);
    }

    @Override
    public class_1799 getSeedItem() {
        return inventory.get(BotanyPotBlockEntity.SEED_SLOT);
    }

    @Override
    public class_1799 getHarvestItem() {
        return inventory.get(BotanyPotBlockEntity.TOOL_SLOT);
    }

    @Override
    public class_8567 createLootParams(@Nullable class_2680 state) {
        throw new IllegalStateException("Display context can not generate loot.");
    }

    @Override
    public void runFunction(class_2960 functionId) {
        throw new IllegalStateException("Display context can not run functions! Function=" + functionId.toString());
    }

    @Nullable
    @Override
    public class_1657 getPlayer() {
        return class_310.method_1551().field_1724;
    }

    @Override
    public class_1799 getInteractionItem() {
        return this.getPlayer() != null ? getPlayer().method_6047() : class_1799.field_8037;
    }

    @Override
    public int getRequiredGrowthTicks() {
        if (this.getPlayer() != null) {
            final class_1937 level = this.getPlayer().method_37908();
            final class_8786<Soil> soil = Objects.requireNonNull(Soil.CACHE.apply(level)).lookup(this.getSoilItem(), this, level);
            final class_8786<Crop> crop = Objects.requireNonNull(Crop.CACHE.apply(level)).lookup(this.getSeedItem(), this, level);
            if (crop != null) {
                return Helpers.getRequiredGrowthTicks(this, level, crop.comp_1933(), soil != null ? soil.comp_1933() : null);
            }
        }
        return -1;
    }

    @Override
    public boolean isServerThread() {
        return false;
    }

    @Nullable
    @Override
    public Crop getCrop() {
        if (this.getPlayer() != null) {
            final class_1937 level = this.getPlayer().method_37908();
            final class_8786<Crop> crop = Objects.requireNonNull(Crop.CACHE.apply(level)).lookup(this.getSeedItem(), this, level);
            if (crop != null) {
                return crop.comp_1933();
            }
        }
        return null;
    }

    @Nullable
    @Override
    public Soil getSoil() {
        if (this.getPlayer() != null) {
            final class_1937 level = this.getPlayer().method_37908();
            final class_8786<Soil> soil = Objects.requireNonNull(Soil.CACHE.apply(level)).lookup(this.getSoilItem(), this, level);
            if (soil != null) {
                return soil.comp_1933();
            }
        }
        return null;
    }

    @NotNull
    @Override
    public class_1799 method_59984(int i) {
        return this.inventory.get(i);
    }

    @Override
    public int method_59983() {
        return this.inventory.size();
    }
}