/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.botanypots.common.impl.command;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.darkhax.bookshelf.common.api.function.CachedSupplier;
import net.darkhax.bookshelf.common.api.util.CommandHelper;
import net.darkhax.botanypots.common.api.data.recipes.RecipeCache;
import net.darkhax.botanypots.common.api.data.recipes.crop.Crop;
import net.darkhax.botanypots.common.impl.BotanyPotsMod;
import net.darkhax.botanypots.common.impl.block.entity.BotanyPotBlockEntity;
import net.darkhax.botanypots.common.impl.data.recipe.crop.BasicCrop;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2248;
import net.minecraft.class_2262;
import net.minecraft.class_2267;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2378;
import net.minecraft.class_2586;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_7923;
import net.minecraft.class_8786;

public class PlaceCrops {
    public static final List<Supplier<class_2248>> pots = List.of(CachedSupplier.of((class_2378)class_7923.field_41175, (class_2960)BotanyPotsMod.id("red_concrete_waxed_botany_pot")), CachedSupplier.of((class_2378)class_7923.field_41175, (class_2960)BotanyPotsMod.id("orange_concrete_waxed_botany_pot")), CachedSupplier.of((class_2378)class_7923.field_41175, (class_2960)BotanyPotsMod.id("yellow_concrete_waxed_botany_pot")), CachedSupplier.of((class_2378)class_7923.field_41175, (class_2960)BotanyPotsMod.id("lime_concrete_waxed_botany_pot")), CachedSupplier.of((class_2378)class_7923.field_41175, (class_2960)BotanyPotsMod.id("green_concrete_waxed_botany_pot")), CachedSupplier.of((class_2378)class_7923.field_41175, (class_2960)BotanyPotsMod.id("cyan_concrete_waxed_botany_pot")), CachedSupplier.of((class_2378)class_7923.field_41175, (class_2960)BotanyPotsMod.id("light_blue_concrete_waxed_botany_pot")), CachedSupplier.of((class_2378)class_7923.field_41175, (class_2960)BotanyPotsMod.id("blue_concrete_waxed_botany_pot")), CachedSupplier.of((class_2378)class_7923.field_41175, (class_2960)BotanyPotsMod.id("purple_concrete_waxed_botany_pot")), CachedSupplier.of((class_2378)class_7923.field_41175, (class_2960)BotanyPotsMod.id("magenta_concrete_waxed_botany_pot")), CachedSupplier.of((class_2378)class_7923.field_41175, (class_2960)BotanyPotsMod.id("pink_concrete_waxed_botany_pot")));

    public static void build(LiteralArgumentBuilder<class_2168> parent) {
        LiteralArgumentBuilder cmd = class_2170.method_9247((String)"place_seeds");
        cmd.executes(PlaceCrops::execute);
        cmd.then(((RequiredArgumentBuilder)class_2170.method_9244((String)"pos", (ArgumentType)class_2262.method_9698()).executes(PlaceCrops::execute)).then(class_2170.method_9244((String)"all_soils", (ArgumentType)BoolArgumentType.bool()).executes(PlaceCrops::execute)));
        parent.then((ArgumentBuilder)cmd);
    }

    private static class_2338 getPos(String name, CommandContext<class_2168> ctx, Supplier<class_2338> fallback) {
        return CommandHelper.hasArgument((String)name, ctx, class_2267.class) ? class_2262.method_48299(ctx, (String)name) : fallback.get();
    }

    private static int execute(CommandContext<class_2168> ctx) throws CommandSyntaxException {
        class_2338.class_2339 mutable = PlaceCrops.getPos("pos", ctx, () -> ((class_2168)ctx.getSource()).method_44023().method_23312()).method_25503();
        boolean allSoils = CommandHelper.getBooleanArg((String)"all_soils", ctx);
        class_3218 level = ((class_2168)ctx.getSource()).method_9225();
        int count = 0;
        for (Map.Entry crop : Objects.requireNonNull((RecipeCache)Crop.CACHE.apply((class_1937)((class_2168)ctx.getSource()).method_9225())).getCachedValues().entries().stream().sorted(Comparator.comparing(s -> class_7923.field_41178.method_10221((Object)((class_1792)s.getKey())).toString())).collect(Collectors.toCollection(LinkedHashSet::new))) {
            if (allSoils) {
                for (class_1799 soilStack : PlaceCrops.findAllSoils((Crop)((class_8786)crop.getValue()).comp_1933())) {
                    level.method_8652((class_2338)mutable, pots.get(count).get().method_9564(), 3);
                    class_2586 class_25862 = level.method_8321((class_2338)mutable);
                    if (class_25862 instanceof BotanyPotBlockEntity) {
                        BotanyPotBlockEntity pot = (BotanyPotBlockEntity)class_25862;
                        pot.method_5447(0, soilStack);
                        pot.method_5447(1, ((class_1792)crop.getKey()).method_7854());
                        pot.updateGrowthTime(pot.getRequiredGrowthTicks());
                    }
                    mutable.method_10098(class_2350.field_11043);
                    if (++count != pots.size()) continue;
                    count = 0;
                    mutable.method_10104(class_2350.field_11035, pots.size());
                    mutable.method_10098(class_2350.field_11034);
                }
                continue;
            }
            level.method_8652((class_2338)mutable, pots.get(count).get().method_9564(), 3);
            class_2586 class_25863 = level.method_8321((class_2338)mutable);
            if (class_25863 instanceof BotanyPotBlockEntity) {
                BotanyPotBlockEntity pot = (BotanyPotBlockEntity)class_25863;
                pot.method_5447(0, PlaceCrops.findFirstSoil((Crop)((class_8786)crop.getValue()).comp_1933()));
                pot.method_5447(1, ((class_1792)crop.getKey()).method_7854());
                pot.updateGrowthTime(pot.getRequiredGrowthTicks());
            }
            mutable.method_10098(class_2350.field_11043);
            if (++count != pots.size()) continue;
            count = 0;
            mutable.method_10104(class_2350.field_11035, pots.size());
            mutable.method_10098(class_2350.field_11034);
        }
        return 0;
    }

    private static List<class_1799> findAllSoils(Crop crop) {
        ArrayList<class_1799> items = new ArrayList<class_1799>();
        if (crop instanceof BasicCrop) {
            BasicCrop basic = (BasicCrop)crop;
            for (class_1792 item : class_7923.field_41178) {
                class_1799 stack = item.method_7854();
                if (!basic.getBasicProperties().soil().method_8093(stack)) continue;
                items.add(stack);
            }
        }
        return items;
    }

    private static class_1799 findFirstSoil(Crop crop) {
        if (crop instanceof BasicCrop) {
            BasicCrop basic = (BasicCrop)crop;
            for (class_1792 item : class_7923.field_41178) {
                class_1799 stack = item.method_7854();
                if (!basic.getBasicProperties().soil().method_8093(stack)) continue;
                return stack;
            }
        }
        return class_1799.field_8037;
    }
}

