/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.botanypots.common.api.data.recipes;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import net.darkhax.bookshelf.common.api.function.ReloadableCache;
import net.darkhax.bookshelf.common.api.function.SidedReloadableCache;
import net.darkhax.botanypots.common.api.context.BotanyPotContext;
import net.darkhax.botanypots.common.api.data.recipes.BotanyPotRecipe;
import net.darkhax.botanypots.common.api.data.recipes.CacheableRecipe;
import net.darkhax.botanypots.common.impl.BotanyPotsMod;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1860;
import net.minecraft.class_1937;
import net.minecraft.class_2960;
import net.minecraft.class_3956;
import net.minecraft.class_7923;
import net.minecraft.class_8786;
import org.jetbrains.annotations.Nullable;

public final class RecipeCache<T extends BotanyPotRecipe> {
    private final Supplier<class_3956<T>> recipeType;
    private final ReloadableCache<Map<class_2960, class_8786<T>>> recipeCache;
    private final Multimap<class_1792, class_8786<T>> lookupCache = ArrayListMultimap.create();
    private final List<class_8786<T>> uncached = new LinkedList<class_8786<T>>();

    private RecipeCache(Supplier<class_3956<T>> recipeType) {
        this.recipeType = recipeType;
        this.recipeCache = ReloadableCache.recipes(this.recipeType);
    }

    public boolean isCached(class_1799 stack) {
        return !stack.method_7960() && !this.lookupCache.get((Object)stack.method_7909()).isEmpty();
    }

    public Multimap<class_1792, class_8786<T>> getCachedValues() {
        return this.lookupCache;
    }

    @Nullable
    public class_8786<T> lookup(class_1799 stack, BotanyPotContext context, class_1937 level) {
        if (stack.method_7960()) {
            return null;
        }
        Collection cachedRecipes = this.lookupCache.get((Object)stack.method_7909());
        for (class_8786 class_87862 : this.lookupCache.get((Object)stack.method_7909())) {
            if (!((BotanyPotRecipe)class_87862.comp_1933()).couldMatch(stack, context, level)) continue;
            return class_87862;
        }
        for (class_8786 class_87863 : this.uncached) {
            if (!((BotanyPotRecipe)class_87863.comp_1933()).couldMatch(stack, context, level)) continue;
            return class_87863;
        }
        return null;
    }

    private void buildCache(class_1937 level) {
        long startTime = System.nanoTime();
        Map recipes = (Map)this.recipeCache.apply(level);
        if (recipes == null) {
            BotanyPotsMod.LOG.error("Could not build {} cache. Entries do not exist?", this.recipeType.get());
            return;
        }
        this.uncached.clear();
        this.uncached.addAll(recipes.values());
        if (!recipes.isEmpty()) {
            for (class_1792 item : class_7923.field_41178) {
                class_1799 defaultStack = item.method_7854();
                for (class_8786 recipe : recipes.values()) {
                    CacheableRecipe cacheable;
                    class_1860 class_18602 = recipe.comp_1933();
                    if (!(class_18602 instanceof CacheableRecipe) || !(cacheable = (CacheableRecipe)class_18602).canBeCached() || !cacheable.isCacheKey(defaultStack)) continue;
                    this.lookupCache.put((Object)item, (Object)recipe);
                    this.uncached.remove(recipe);
                }
            }
        }
        long endTime = System.nanoTime();
        BotanyPotsMod.LOG.info("Built {} {} cache in {}ms. {} / {} entries cached.", new Object[]{level.field_9236 ? "Client" : "Server", this.recipeType.get(), Float.valueOf((float)(endTime - startTime) / 1000000.0f), recipes.size() - this.uncached.size(), recipes.size()});
    }

    public static <T extends BotanyPotRecipe> SidedReloadableCache<RecipeCache<T>> of(Supplier<class_3956<T>> type) {
        return SidedReloadableCache.of((T level) -> {
            RecipeCache cache = new RecipeCache(type);
            cache.buildCache((class_1937)level);
            return cache;
        });
    }
}

