package net.darkhax.botanypots.common.impl.data.display.types;

import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.darkhax.bookshelf.common.api.data.codecs.map.MapCodecs;
import net.darkhax.botanypots.common.api.data.display.math.AxisAlignedRotation;
import net.darkhax.botanypots.common.api.data.display.math.TintColor;
import net.darkhax.botanypots.common.api.data.display.types.RenderOptions;
import net.minecraft.class_2350;
import net.minecraft.class_2540;
import net.minecraft.class_5699;
import net.minecraft.class_9135;
import net.minecraft.class_9139;
import org.jetbrains.annotations.NotNull;
import org.joml.Vector3f;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;

/**
 * A basic implementation of the render options.
 */
public class BasicOptions implements RenderOptions {

    /**
     * The default set of faces that should not be culled. All faces are preserved by default.
     */
    public static Set<class_2350> DEFAULT_FACES = Set.of(class_2350.values());

    /**
     * The default scale to apply to displays. The default is 62.5% which is what we determined looked good at 100%
     * growth.
     */
    public static Vector3f DEFAULT_SCALE = new Vector3f(0.625f, 0.625f, 0.625f);

    /**
     * The default offset, which does nothing.
     */
    public static Vector3f DEFAULT_OFFSET = new Vector3f(0f, 0f, 0f);

    public static final Codec<BasicOptions> CODEC = RecordCodecBuilder.create(instance -> instance.group(
            class_5699.field_40723.optionalFieldOf("scale", DEFAULT_SCALE).forGetter(BasicOptions::getScale),
            class_5699.field_40723.optionalFieldOf("offset", DEFAULT_OFFSET).forGetter(BasicOptions::getOffset),
            AxisAlignedRotation.CODEC_HELPER.getList("rotation", BasicOptions::getRotations, new ArrayList<>()),
            MapCodecs.BOOLEAN.get("render_fluid", BasicOptions::shouldRenderFluid, false),
            TintColor.CODEC.optionalFieldOf("color").forGetter(BasicOptions::getColor),
            MapCodecs.flexibleSet(class_2350.field_29502).optionalFieldOf("faces", DEFAULT_FACES).forGetter(BasicOptions::getFaces)
    ).apply(instance, BasicOptions::new));

    public static final class_9139<class_2540, BasicOptions> STREAM = new class_9139<>() {
        @Override
        public void encode(@NotNull class_2540 buf, @NotNull BasicOptions state) {
            class_9135.field_48558.encode(buf, state.scale);
            class_9135.field_48558.encode(buf, state.offset);
            buf.method_34062(state.rotations, AxisAlignedRotation.STREAM);
            buf.method_52964(state.renderFluid);
            buf.method_37435(state.tintColor, TintColor.STREAM);
            buf.method_53002(state.faces.size());
            for (class_2350 face : state.faces) {
                buf.method_10817(face);
            }
        }

        @NotNull
        @Override
        public BasicOptions decode(@NotNull class_2540 buf) {
            final Vector3f scale = class_9135.field_48558.decode(buf);
            final Vector3f offset = class_9135.field_48558.decode(buf);
            final List<AxisAlignedRotation> rotations = buf.method_34066(AxisAlignedRotation.STREAM);
            final boolean renderFluid = buf.readBoolean();
            final Optional<TintColor> tintColor = buf.method_37436(TintColor.STREAM);
            final Set<class_2350> faces = new HashSet<>();
            final int faceSize = buf.readInt();
            for (int i = 0; i < faceSize; i++) {
                faces.add(buf.method_10818(class_2350.class));
            }
            return new BasicOptions(scale, offset, rotations, renderFluid, tintColor, faces);
        }
    };

    private final Vector3f scale;
    private final Vector3f offset;
    private final List<AxisAlignedRotation> rotations;
    private final boolean renderFluid;
    private final Optional<TintColor> tintColor;
    private final Set<class_2350> faces;

    public BasicOptions(Vector3f scale, Vector3f offset, List<AxisAlignedRotation> rotations, boolean renderFluid, Optional<TintColor> tintColor, Set<class_2350> faces) {
        this.scale = scale;
        this.offset = offset;
        this.rotations = rotations;
        this.renderFluid = renderFluid;
        this.tintColor = tintColor;
        this.faces = faces;
    }

    @Override
    public Vector3f getScale() {
        return scale;
    }

    @Override
    public Vector3f getOffset() {
        return offset;
    }

    @Override
    public List<AxisAlignedRotation> getRotations() {
        return rotations;
    }

    @Override
    public boolean shouldRenderFluid() {
        return renderFluid;
    }

    @Override
    public Optional<TintColor> getColor() {
        return this.tintColor;
    }

    @Override
    public Set<class_2350> getFaces() {
        return this.faces;
    }

    public static BasicOptions ofDefault() {
        return ofDefault(DEFAULT_FACES);
    }

    public static BasicOptions ofDefault(Set<class_2350> faces) {
        return new BasicOptions(DEFAULT_SCALE, DEFAULT_OFFSET, List.of(), false, Optional.empty(), faces);
    }
}
