package net.darkhax.botanypots.common.impl.data.display.types;

import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.darkhax.bookshelf.common.api.function.CachedSupplier;
import net.darkhax.botanypots.common.api.data.display.types.Display;
import net.darkhax.botanypots.common.api.data.display.types.DisplayType;
import net.darkhax.botanypots.common.impl.BotanyPotsMod;
import net.darkhax.botanypots.common.impl.Helpers;
import net.minecraft.class_2248;
import net.minecraft.class_2302;
import net.minecraft.class_2540;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2758;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_7923;
import net.minecraft.class_9139;
import java.util.ArrayList;
import java.util.List;

public class AgingDisplayState extends PhasedDisplayState {

    public static final class_2960 TYPE_ID = BotanyPotsMod.id("aging");
    public static final CachedSupplier<DisplayType<AgingDisplayState>> TYPE = CachedSupplier.cache(() -> DisplayType.get(TYPE_ID));
    public static final MapCodec<AgingDisplayState> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group(Helpers.BLOCK_CODEC.fieldOf("block").forGetter(AgingDisplayState::getBlock), BasicOptions.CODEC.optionalFieldOf("options", BasicOptions.ofDefault()).forGetter(AgingDisplayState::getRenderOptions)).apply(instance, AgingDisplayState::new));
    public static final class_9139<class_2540, AgingDisplayState> STREAM = class_9139.method_56435(Helpers.BLOCK_STREAM, AgingDisplayState::getBlock, BasicOptions.STREAM, AgingDisplayState::getRenderOptions, AgingDisplayState::new);

    private final class_2248 block;
    private final BasicOptions renderOptions;
    private final List<Display> phases;

    public AgingDisplayState(class_2248 block, BasicOptions renderOptions) {
        this.block = block;
        this.renderOptions = renderOptions;
        this.phases = calculatePhases(block);
    }

    private List<Display> calculatePhases(class_2248 block) {
        final List<Display> phases = new ArrayList<>();
        if (block instanceof class_2302 crop) {
            for (int cropStage = 0; cropStage <= crop.method_9827(); cropStage++) {
                try {
                    final class_2680 agedState = crop.method_9828(cropStage);
                    phases.add(new SimpleDisplayState(agedState, this.renderOptions));
                }
                catch (Exception e) {
                    BotanyPotsMod.LOG.error("Invalid crop age found! id={} block={} age={}", class_7923.field_41175.method_10221(block), block, cropStage);
                    BotanyPotsMod.LOG.error("Error: ", e);
                }
            }
        }
        else if (block.method_9564().method_28498(class_2741.field_42835)) {
            final class_2769<?> flowerCount = block.method_9595().method_11663("flower_amount");
            if (flowerCount instanceof class_2758 property) {
                for (int amount : property.method_11898()) {
                    phases.add(new SimpleDisplayState(block.method_9564().method_11657(property, amount), this.renderOptions));
                }
            }
        }
        else {
            final class_2769<?> ageProperty = block.method_9595().method_11663("age");
            if (ageProperty instanceof class_2758 intProperty) {
                for (int age : intProperty.method_11898()) {
                    phases.add(new SimpleDisplayState(block.method_9564().method_11657(intProperty, age), this.renderOptions));
                }
            }
            else {
                phases.add(new SimpleDisplayState(block.method_9564(), this.renderOptions));
            }
        }
        return phases;
    }

    public class_2248 getBlock() {
        return this.block;
    }

    public BasicOptions getRenderOptions() {
        return this.renderOptions;
    }

    @Override
    public List<Display> getDisplayPhases() {
        return this.phases;
    }

    @Override
    public DisplayType<?> getType() {
        return TYPE.get();
    }
}