package net.darkhax.botanypots.common.impl.command.generator;

import com.google.gson.JsonObject;
import net.darkhax.botanypots.common.api.command.generator.DataHelper;
import net.darkhax.botanypots.common.api.command.generator.soil.SoilGenerator;
import net.darkhax.botanypots.common.api.data.recipes.crop.Crop;
import net.darkhax.botanypots.common.api.data.recipes.interaction.PotInteraction;
import net.darkhax.botanypots.common.impl.BotanyPotsMod;
import net.darkhax.botanypots.common.impl.data.recipe.crop.BasicCrop;
import net.darkhax.botanypots.common.impl.data.recipe.interaction.BasicPotInteraction;
import net.minecraft.class_1747;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_2248;
import net.minecraft.class_3218;
import net.minecraft.class_6862;
import net.minecraft.class_7924;
import net.minecraft.class_8786;
import java.util.Objects;

/**
 * This soil generator is used as a fallback when none of the other generators have claimed an item. It looks for items
 * that are accepted by existing crops, or items that are part of a pot interaction recipe.
 */
public class MissingSoilGenerator implements SoilGenerator {

    private static final class_6862<class_1792> IGNORED_ITEMS = class_6862.method_40092(class_7924.field_41197, BotanyPotsMod.id("soil_generator_ignores"));

    @Override
    public boolean canGenerateSoil(class_3218 level, class_1799 stack) {
        if (!stack.method_31573(IGNORED_ITEMS) && stack.method_7909() instanceof class_1747) {
            for (class_8786<Crop> crop : Objects.requireNonNull(Crop.RECIPES.apply(level)).values()) {
                if (crop.comp_1933() instanceof BasicCrop basic && basic.isValidSoil(stack)) {
                    return true;
                }
            }
            for (class_8786<PotInteraction> interaction : Objects.requireNonNull(PotInteraction.RECIPES.apply(level)).values()) {
                if (interaction.comp_1933() instanceof BasicPotInteraction basic) {
                    final class_1856 soilTest = basic.properties.soilTest().orElse(null);
                    if (soilTest != null && !soilTest.method_8103() && soilTest.method_8093(stack)) {
                        return true;
                    }
                    final class_1799 output = basic.properties.newSoil().orElse(class_1799.field_8037);
                    if (!output.method_7960() && class_1799.method_31577(stack, output)) {
                        return true;
                    }
                }
            }
        }
        return false;
    }

    @Override
    public JsonObject generateData(class_3218 level, class_1799 stack) {
        final class_2248 block = ((class_1747) stack.method_7909()).method_7711();
        final JsonObject output = new JsonObject();
        output.add("bookshelf:load_conditions", DataHelper.array(DataHelper.requiresBlock(block)));
        output.addProperty("type", "botanypots:block_derived_soil");
        output.addProperty("block", DataHelper.BLOCKS.method_10221(block).toString());
        return output;
    }
}