package net.darkhax.botanypots.common.api.context;

import net.darkhax.botanypots.common.api.data.recipes.crop.Crop;
import net.darkhax.botanypots.common.api.data.recipes.soil.Soil;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_8567;
import net.minecraft.class_9695;
import org.jetbrains.annotations.Nullable;

/**
 * Provides context for recipes related to botany pots.
 */
public interface BotanyPotContext extends class_9695 {

    /**
     * Gets the item in the soil slot.
     *
     * @return The item in the soil slot.
     */
    class_1799 getSoilItem();

    /**
     * Gets the item in the seed slot.
     *
     * @return The item in the seed slot.
     */
    class_1799 getSeedItem();

    /**
     * Gets the item in the harvest tool slot. This is not the same as the players held item.
     *
     * @return The item in the harvest tool slot.
     */
    class_1799 getHarvestItem();

    /**
     * Creates loot table parameters for generating loot from a loot table. Loot tables only exist on the server thread
     * and parameters can not be constructed on a client thread.
     *
     * @param state The state for the block_state parameter. Sometimes it is necessary to use a different block to get
     *              te right loot table results. For example, the wheat loot table checks the block id and age.
     * @return Loot parameters based on the current context.
     */
    class_8567 createLootParams(@Nullable class_2680 state);

    /**
     * Runs an MCFunction file based on the provided ID. Functions can only be executed on the server thread, trying to
     * do this on a client thread will cause issues.
     *
     * @param functionId The ID of the MCFunction to run.
     */
    void runFunction(class_2960 functionId);

    /**
     * Gets the relevant player if one is available.
     *
     * @return The relevant player if one is available.
     */
    @Nullable
    class_1657 getPlayer();

    /**
     * Gets the item used by the player if one was used.
     *
     * @return The item the player used to interact.
     */
    class_1799 getInteractionItem();

    /**
     * Determines the total amount of growth ticks required for the crop to fully mature based on the current
     * conditions.
     *
     * @return The total amount of growth ticks required to grow the crop.
     */
    int getRequiredGrowthTicks();

    /**
     * Determines if the action is happening on the server thread. It does not matter if the server is integrated or
     * dedicated.
     *
     * @return If the action is happening on a server thread.
     */
    boolean isServerThread();

    @Nullable
    Crop getCrop();

    @Nullable
    Soil getSoil();
}
