/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.botanypots.common.impl.block.menu;

import java.util.Objects;
import net.darkhax.bookshelf.common.api.function.CachedSupplier;
import net.darkhax.bookshelf.common.api.menu.data.BlockPosData;
import net.darkhax.bookshelf.common.api.menu.slot.InputSlot;
import net.darkhax.bookshelf.common.api.menu.slot.OutputSlot;
import net.darkhax.botanypots.common.api.context.BlockEntityContext;
import net.darkhax.botanypots.common.api.data.recipes.RecipeCache;
import net.darkhax.botanypots.common.api.data.recipes.crop.Crop;
import net.darkhax.botanypots.common.api.data.recipes.soil.Soil;
import net.darkhax.botanypots.common.impl.BotanyPotsMod;
import net.darkhax.botanypots.common.impl.block.entity.BotanyPotBlockEntity;
import net.minecraft.class_1263;
import net.minecraft.class_1277;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1735;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2960;
import net.minecraft.class_3913;
import net.minecraft.class_3917;
import net.minecraft.class_3919;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BotanyPotMenu
extends class_1703 {
    public static final class_2960 EMPTY_SLOT_SOIL = BotanyPotsMod.id("item/empty_slot_soil");
    public static final class_2960 EMPTY_SLOT_SEED = BotanyPotsMod.id("item/empty_slot_seed");
    public static final class_2960 EMPTY_SLOT_HOE = class_2960.method_60656((String)"item/empty_slot_hoe");
    public static final CachedSupplier<class_3917<BotanyPotMenu>> BASIC_MENU = CachedSupplier.cache(() -> (class_3917)class_7923.field_41187.method_10223(BotanyPotsMod.id("basic_pot_menu"))).cast();
    public static final CachedSupplier<class_3917<BotanyPotMenu>> HOPPER_MENU = CachedSupplier.cache(() -> (class_3917)class_7923.field_41187.method_10223(BotanyPotsMod.id("hopper_pot_menu"))).cast();
    public static final class_6862<class_1792> HARVEST_ITEM = class_6862.method_40092((class_5321)class_7924.field_41197, (class_2960)BotanyPotsMod.id("harvest_items"));
    private final class_1937 level;
    private final class_1263 potContainer;
    private final class_1661 playerInv;
    private final class_3913 blockPos;
    protected final boolean isHopper;

    public static BotanyPotMenu basicMenuClient(int containerId, class_1661 playerInv) {
        return new BotanyPotMenu((class_3917)BASIC_MENU.get(), containerId, playerInv, (class_1263)new class_1277(2), false, (class_3913)new class_3919(3));
    }

    public static BotanyPotMenu hopperMenuClient(int containerId, class_1661 playerInv) {
        return new BotanyPotMenu((class_3917)HOPPER_MENU.get(), containerId, playerInv, (class_1263)new class_1277(15), true, (class_3913)new class_3919(3));
    }

    public static BotanyPotMenu potMenuServer(int containerId, class_1661 playerInv, BotanyPotBlockEntity pot) {
        return new BotanyPotMenu(pot.isHopper() ? (class_3917)HOPPER_MENU.get() : (class_3917)BASIC_MENU.get(), containerId, playerInv, (class_1263)pot, pot.isHopper(), (class_3913)new BlockPosData(pot.method_11016()));
    }

    public BotanyPotMenu(class_3917<?> menuType, int id, class_1661 playerInv, class_1263 potContainer, boolean isHopper, class_3913 data) {
        super(menuType, id);
        this.level = playerInv.field_7546.method_37908();
        this.playerInv = playerInv;
        this.potContainer = potContainer;
        this.isHopper = isHopper;
        this.blockPos = data;
        this.method_17360(this.blockPos);
        int slotXOffset = isHopper ? 44 : 80;
        this.method_7621((class_1735)new InputSlot(potContainer, 0, slotXOffset, 48, EMPTY_SLOT_SOIL));
        this.method_7621((class_1735)new InputSlot(potContainer, 1, slotXOffset, 22, EMPTY_SLOT_SEED));
        if (isHopper) {
            this.method_7621((class_1735)new InputSlot(potContainer, 2, 18, 35, EMPTY_SLOT_HOE, stack -> stack.method_31573(HARVEST_ITEM)));
        }
        if (isHopper) {
            for (int potOutputY = 0; potOutputY < 3; ++potOutputY) {
                for (int potOutputX = 0; potOutputX < 4; ++potOutputX) {
                    int slotId = 3 + (potOutputX + potOutputY * 4);
                    int slotX = 80 + potOutputX * 18;
                    int slotY = 17 + potOutputY * 18;
                    this.method_7621((class_1735)new OutputSlot(potContainer, slotId, slotX, slotY));
                }
            }
        }
        for (int playerInvY = 0; playerInvY < 3; ++playerInvY) {
            for (int playerInvX = 0; playerInvX < 9; ++playerInvX) {
                this.method_7621(new class_1735((class_1263)playerInv, playerInvX + playerInvY * 9 + 9, 8 + playerInvX * 18, 84 + playerInvY * 18));
            }
        }
        for (int hotbarX = 0; hotbarX < 9; ++hotbarX) {
            this.method_7621(new class_1735((class_1263)playerInv, hotbarX, 8 + hotbarX * 18, 142));
        }
    }

    @NotNull
    public class_1799 method_7601(@NotNull class_1657 player, int clickedSlotId) {
        BlockEntityContext context = this.getContext();
        class_1735 clickedSlot = (class_1735)this.field_7761.get(clickedSlotId);
        if (context == null) {
            return class_1799.field_8037;
        }
        int firstSlot = this.isHopper ? 14 : 2;
        int lastSlot = this.isHopper ? 51 : 38;
        class_1799 unplacedItems = class_1799.field_8037;
        if (clickedSlot.method_7681()) {
            class_1799 clickedStack = clickedSlot.method_7677();
            unplacedItems = clickedStack.method_7972();
            if (this.isHopper && clickedSlotId > 2 && clickedSlotId <= firstSlot) {
                if (!this.method_7616(clickedStack, firstSlot, lastSlot, false)) {
                    return class_1799.field_8037;
                }
                clickedSlot.method_7670(clickedStack, unplacedItems);
            } else if (clickedSlotId == 0 || clickedSlotId == 1 || this.isHopper && clickedSlotId == 2) {
                if (!this.method_7616(clickedStack, firstSlot, lastSlot, false)) {
                    return class_1799.field_8037;
                }
            } else if (clickedSlotId >= firstSlot && clickedSlotId <= lastSlot) {
                class_1735 toolSlot = (class_1735)this.field_7761.get(2);
                if (!toolSlot.method_7681() && clickedStack.method_31573(HARVEST_ITEM)) {
                    toolSlot.method_7673(clickedStack.method_7971(1));
                    clickedSlot.method_7673(clickedStack);
                    return class_1799.field_8037;
                }
                class_1735 soilSlot = (class_1735)this.field_7761.get(0);
                if (!soilSlot.method_7681() && Objects.requireNonNull((RecipeCache)Soil.CACHE.apply(this.level)).lookup(clickedStack, context, player.method_37908()) != null) {
                    soilSlot.method_7673(clickedStack.method_7971(1));
                    clickedSlot.method_7673(clickedStack);
                    return class_1799.field_8037;
                }
                class_1735 cropSlot = (class_1735)this.field_7761.get(1);
                if (!cropSlot.method_7681() && Objects.requireNonNull((RecipeCache)Crop.CACHE.apply(this.level)).lookup(clickedStack, context, player.method_37908()) != null) {
                    cropSlot.method_7673(clickedStack.method_7971(1));
                    clickedSlot.method_7673(clickedStack);
                    return class_1799.field_8037;
                }
                if (!this.method_7616(clickedStack, lastSlot - 9, lastSlot, false)) {
                    return class_1799.field_8037;
                }
            }
            if (clickedStack.method_7960()) {
                clickedSlot.method_7673(class_1799.field_8037);
            } else {
                clickedSlot.method_7668();
            }
            if (clickedStack.method_7947() == unplacedItems.method_7947()) {
                return class_1799.field_8037;
            }
            clickedSlot.method_7667(player, clickedStack);
        }
        return unplacedItems;
    }

    public boolean method_7597(@NotNull class_1657 player) {
        return this.potContainer.method_5443(player);
    }

    @Nullable
    public BlockEntityContext getContext() {
        BlockEntityContext blockEntityContext;
        class_2338 class_23382;
        class_3913 class_39132 = this.blockPos;
        if (class_39132 instanceof BlockPosData) {
            BlockPosData posData = (BlockPosData)class_39132;
            class_23382 = posData.getPos();
        } else {
            class_23382 = BlockPosData.readPos((class_3913)this.blockPos);
        }
        class_2338 pos = class_23382;
        class_39132 = this.playerInv.field_7546.method_37908().method_8321(pos);
        if (class_39132 instanceof BotanyPotBlockEntity) {
            BotanyPotBlockEntity pot = (BotanyPotBlockEntity)class_39132;
            blockEntityContext = pot.getRecipeContext();
        } else {
            blockEntityContext = null;
        }
        return blockEntityContext;
    }
}

