package net.darkhax.botanypots.common.api.data.recipes.fertilizer;

import net.darkhax.bookshelf.common.api.function.CachedSupplier;
import net.darkhax.bookshelf.common.api.function.SidedReloadableCache;
import net.darkhax.botanypots.common.api.context.BotanyPotContext;
import net.darkhax.botanypots.common.api.data.recipes.BotanyPotRecipe;
import net.darkhax.botanypots.common.api.data.recipes.RecipeCache;
import net.darkhax.botanypots.common.impl.BotanyPotsMod;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2960;
import net.minecraft.class_3956;
import net.minecraft.class_7923;
import net.minecraft.class_8786;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

import java.util.Map;
import java.util.function.Supplier;

/**
 * Represents a fertilizer interaction with a crop.
 */
public abstract class Fertilizer extends BotanyPotRecipe {

    public static final Supplier<class_3956<Fertilizer>> TYPE = CachedSupplier.of(class_7923.field_41188, BotanyPotsMod.id("fertilizer")).cast();
    public static final SidedReloadableCache<Map<class_2960, class_8786<Fertilizer>>> RECIPES = SidedReloadableCache.recipes(TYPE);
    public static final SidedReloadableCache<RecipeCache<Fertilizer>> CACHE = RecipeCache.of(TYPE);

    /**
     * Applies the fertilizer to the crop.
     *
     * @param context The context that the fertilizer is being used in.
     * @param level   The current game level.
     */
    public abstract void apply(@NotNull BotanyPotContext context, @NotNull class_1937 level);

    @NotNull
    @Override
    public class_3956<?> method_17716() {
        return TYPE.get();
    }

    @Nullable
    public static class_8786<Fertilizer> getFertilizer(class_1937 level, BotanyPotContext context, class_1799 stack) {
        final RecipeCache<Fertilizer> cache = CACHE.apply(level);
        return cache != null ? cache.lookup(stack, context, level) : null;
    }
}