package net.darkhax.botanypots.common.impl.block.menu;

import net.darkhax.bookshelf.common.api.function.CachedSupplier;
import net.darkhax.bookshelf.common.api.menu.data.BlockPosData;
import net.darkhax.bookshelf.common.api.menu.slot.InputSlot;
import net.darkhax.bookshelf.common.api.menu.slot.OutputSlot;
import net.darkhax.botanypots.common.api.context.BlockEntityContext;
import net.darkhax.botanypots.common.api.data.recipes.crop.Crop;
import net.darkhax.botanypots.common.api.data.recipes.soil.Soil;
import net.darkhax.botanypots.common.impl.BotanyPotsMod;
import net.darkhax.botanypots.common.impl.block.entity.AbstractBotanyPotBlockEntity;
import net.darkhax.botanypots.common.impl.block.entity.BotanyPotBlockEntity;
import net.minecraft.class_1263;
import net.minecraft.class_1277;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1735;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2960;
import net.minecraft.class_3913;
import net.minecraft.class_3917;
import net.minecraft.class_3919;
import net.minecraft.class_6862;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

import java.util.Objects;

public class BotanyPotMenu extends class_1703 {

    public static final class_2960 EMPTY_SLOT_SOIL = BotanyPotsMod.id("item/empty_slot_soil");
    public static final class_2960 EMPTY_SLOT_SEED = BotanyPotsMod.id("item/empty_slot_seed");
    public static final class_2960 EMPTY_SLOT_HOE = class_2960.method_60656("item/empty_slot_hoe");
    public static final CachedSupplier<class_3917<BotanyPotMenu>> BASIC_MENU = CachedSupplier.cache(() -> class_7923.field_41187.method_10223(BotanyPotsMod.id("basic_pot_menu"))).cast();
    public static final CachedSupplier<class_3917<BotanyPotMenu>> HOPPER_MENU = CachedSupplier.cache(() -> class_7923.field_41187.method_10223(BotanyPotsMod.id("hopper_pot_menu"))).cast();
    public static final class_6862<class_1792> HARVEST_ITEM = class_6862.method_40092(class_7924.field_41197, BotanyPotsMod.id("harvest_items"));

    public static BotanyPotMenu basicMenuClient(int containerId, class_1661 playerInv) {
        return new BotanyPotMenu(BASIC_MENU.get(), containerId, playerInv, new class_1277(2), false, new class_3919(3));
    }

    public static BotanyPotMenu hopperMenuClient(int containerId, class_1661 playerInv) {
        return new BotanyPotMenu(HOPPER_MENU.get(), containerId, playerInv, new class_1277(AbstractBotanyPotBlockEntity.SLOT_COUNT), true, new class_3919(3));
    }

    public static BotanyPotMenu potMenuServer(int containerId, class_1661 playerInv, BotanyPotBlockEntity pot) {
        return new BotanyPotMenu(pot.isHopper() ? HOPPER_MENU.get() : BASIC_MENU.get(), containerId, playerInv, pot, pot.isHopper(), new BlockPosData(pot.method_11016()));
    }

    private final class_1937 level;
    private final class_1263 potContainer;
    private final class_1661 playerInv;
    private final class_3913 blockPos;
    protected final boolean isHopper;

    public BotanyPotMenu(class_3917<?> menuType, int id, class_1661 playerInv, class_1263 potContainer, boolean isHopper, class_3913 data) {
        super(menuType, id);
        this.level = playerInv.field_7546.method_37908();
        this.playerInv = playerInv;
        this.potContainer = potContainer;
        this.isHopper = isHopper;
        this.blockPos = data;
        this.method_17360(this.blockPos);

        // Add the pot's Soil and Crop slot.
        final int slotXOffset = isHopper ? 44 : 80;
        this.method_7621(new InputSlot(potContainer, BotanyPotBlockEntity.SOIL_SLOT, slotXOffset, 48, EMPTY_SLOT_SOIL));
        this.method_7621(new InputSlot(potContainer, BotanyPotBlockEntity.SEED_SLOT, slotXOffset, 22, EMPTY_SLOT_SEED));

        // Hoe item only works on hoppers
        if (isHopper) {
            this.method_7621(new InputSlot(potContainer, BotanyPotBlockEntity.TOOL_SLOT, 18, 35, EMPTY_SLOT_HOE, stack -> stack.method_31573(HARVEST_ITEM)));
        }

        // Add the hopper pot's 4x3 output slots.
        if (isHopper) {
            for (int potOutputY = 0; potOutputY < 3; potOutputY++) {
                for (int potOutputX = 0; potOutputX < 4; potOutputX++) {
                    final int slotId = 3 + (potOutputX + potOutputY * 4);
                    final int slotX = 80 + potOutputX * 18;
                    final int slotY = 17 + potOutputY * 18;
                    this.method_7621(new OutputSlot(potContainer, slotId, slotX, slotY));
                }
            }
        }

        // Add the player's 3 rows of inventory
        for (int playerInvY = 0; playerInvY < 3; playerInvY++) {
            for (int playerInvX = 0; playerInvX < 9; playerInvX++) {
                this.method_7621(new class_1735(playerInv, playerInvX + playerInvY * 9 + 9, 8 + playerInvX * 18, 84 + playerInvY * 18));
            }
        }

        // Add the player's 9 hotbar slots.
        for (int hotbarX = 0; hotbarX < 9; hotbarX++) {
            this.method_7621(new class_1735(playerInv, hotbarX, 8 + hotbarX * 18, 142));
        }
    }

    @NotNull
    @Override
    public class_1799 method_7601(@NotNull class_1657 player, int clickedSlotId) {
        final BlockEntityContext context = this.getContext();
        final class_1735 clickedSlot = this.field_7761.get(clickedSlotId);

        if (context == null) {
            return class_1799.field_8037;
        }

        final int firstSlot = isHopper ? 14 : 2;
        final int lastSlot = isHopper ? 51 : 38;
        class_1799 unplacedItems = class_1799.field_8037;

        if (clickedSlot.method_7681()) {
            final class_1799 clickedStack = clickedSlot.method_7677();
            unplacedItems = clickedStack.method_7972();

            // Attempt to move an output to the player inventory.
            if (isHopper && clickedSlotId > AbstractBotanyPotBlockEntity.TOOL_SLOT && clickedSlotId <= firstSlot) {
                if (!this.method_7616(clickedStack, firstSlot, lastSlot, false)) {
                    return class_1799.field_8037;
                }
                clickedSlot.method_7670(clickedStack, unplacedItems);
            }

            // Attempt moving the soil or seed slot to the player inventory.
            else if (clickedSlotId == BotanyPotBlockEntity.SOIL_SLOT || clickedSlotId == BotanyPotBlockEntity.SEED_SLOT || (isHopper && clickedSlotId == BotanyPotBlockEntity.TOOL_SLOT)) {
                if (!this.method_7616(clickedStack, firstSlot, lastSlot, false)) {
                    return class_1799.field_8037;
                }
            }

            // Move items from player inventory
            else if (clickedSlotId >= firstSlot && clickedSlotId <= lastSlot) {
                // Try to insert a tool
                final class_1735 toolSlot = this.field_7761.get(BotanyPotBlockEntity.TOOL_SLOT);
                if (!toolSlot.method_7681() && clickedStack.method_31573(HARVEST_ITEM)) {
                    toolSlot.method_7673(clickedStack.method_7971(1));
                    clickedSlot.method_7673(clickedStack);
                    return class_1799.field_8037;
                }
                // Try to insert a soil
                final class_1735 soilSlot = this.field_7761.get(BotanyPotBlockEntity.SOIL_SLOT);
                if (!soilSlot.method_7681() && Objects.requireNonNull(Soil.CACHE.apply(level)).lookup(clickedStack, context, player.method_37908()) != null) {
                    soilSlot.method_7673(clickedStack.method_7971(1));
                    clickedSlot.method_7673(clickedStack);
                    return class_1799.field_8037;
                }

                // Try to insert a seed
                final class_1735 cropSlot = this.field_7761.get(BotanyPotBlockEntity.SEED_SLOT);
                if (!cropSlot.method_7681() && Objects.requireNonNull(Crop.CACHE.apply(level)).lookup(clickedStack, context, player.method_37908()) != null) {
                    cropSlot.method_7673(clickedStack.method_7971(1));
                    clickedSlot.method_7673(clickedStack);
                    return class_1799.field_8037;
                }

                // Inventory to hotbar
                if (!this.method_7616(clickedStack, lastSlot - 9, lastSlot, false)) {
                    return class_1799.field_8037;
                }
            }

            if (clickedStack.method_7960()) {
                clickedSlot.method_7673(class_1799.field_8037);
            }
            else {
                clickedSlot.method_7668();
            }
            // Stop when no items left to move
            if (clickedStack.method_7947() == unplacedItems.method_7947()) {
                return class_1799.field_8037;
            }
            clickedSlot.method_7667(player, clickedStack);
        }
        return unplacedItems;
    }

    @Override
    public boolean method_7597(@NotNull class_1657 player) {
        return this.potContainer.method_5443(player);
    }

    @Nullable
    public BlockEntityContext getContext() {
        final class_2338 pos = this.blockPos instanceof BlockPosData posData ? posData.getPos() : BlockPosData.readPos(this.blockPos);
        return this.playerInv.field_7546.method_37908().method_8321(pos) instanceof BotanyPotBlockEntity pot ? pot.getRecipeContext() : null;
    }
}