/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.botanypots.common.api.data.itemdrops;

import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import io.netty.buffer.ByteBuf;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.darkhax.bookshelf.common.api.data.codecs.map.MapCodecs;
import net.darkhax.botanypots.common.api.data.itemdrops.ItemDropProvider;
import net.darkhax.botanypots.common.impl.BotanyPotsMod;
import net.darkhax.botanypots.common.impl.data.itemdrops.BlockDrops;
import net.darkhax.botanypots.common.impl.data.itemdrops.BlockStateDrops;
import net.darkhax.botanypots.common.impl.data.itemdrops.EntityDrops;
import net.darkhax.botanypots.common.impl.data.itemdrops.LootTableDrops;
import net.darkhax.botanypots.common.impl.data.itemdrops.SimpleDropProvider;
import net.minecraft.class_2960;
import net.minecraft.class_9129;
import net.minecraft.class_9139;
import org.jetbrains.annotations.NotNull;

public record ItemDropProviderType<T extends ItemDropProvider>(class_2960 typeID, MapCodec<T> codec, class_9139<class_9129, T> stream) {
    private static final Map<class_2960, ItemDropProviderType<?>> REGISTRY = new HashMap();
    public static final Codec<ItemDropProviderType<?>> TYPE_CODEC = class_2960.field_25139.xmap(REGISTRY::get, ItemDropProviderType::typeID);
    public static final class_9139<ByteBuf, ? extends ItemDropProviderType<?>> TYPE_STREAM = class_2960.field_48267.method_56432(REGISTRY::get, ItemDropProviderType::typeID);
    public static final ItemDropProviderType<LootTableDrops> LOOT_TABLE = ItemDropProviderType.register(BotanyPotsMod.id("loot_table"), LootTableDrops.CODEC, LootTableDrops.STREAM);
    public static final ItemDropProviderType<SimpleDropProvider> SIMPLE_DROPS = ItemDropProviderType.register(BotanyPotsMod.id("items"), SimpleDropProvider.CODEC, SimpleDropProvider.STREAM);
    public static final ItemDropProviderType<BlockDrops> BLOCK_DROPS = ItemDropProviderType.register(BotanyPotsMod.id("block"), BlockDrops.CODEC, BlockDrops.STREAM);
    public static final ItemDropProviderType<BlockStateDrops> BLOCK_STATE_DROPS = ItemDropProviderType.register(BotanyPotsMod.id("block_state"), BlockStateDrops.CODEC, BlockStateDrops.STREAM);
    public static final ItemDropProviderType<EntityDrops> ENTITY_DROPS = ItemDropProviderType.register(BotanyPotsMod.id("entity"), EntityDrops.CODEC, EntityDrops.STREAM);
    public static final Codec<ItemDropProvider> DROP_PROVIDER_CODEC = TYPE_CODEC.dispatch(ItemDropProvider::getType, ItemDropProviderType::codec);
    public static final class_9139<class_9129, ItemDropProvider> DROP_PROVIDER_STREAM = new class_9139<class_9129, ItemDropProvider>(){

        public void encode(@NotNull class_9129 buf, @NotNull ItemDropProvider dropProvider) {
            buf.method_10812(dropProvider.getType().typeID());
            dropProvider.getType().stream.encode((Object)buf, (Object)dropProvider);
        }

        @NotNull
        public ItemDropProvider decode(@NotNull class_9129 buf) {
            class_2960 id = buf.method_10810();
            if (!REGISTRY.containsKey(id)) {
                BotanyPotsMod.LOG.error("Drop provider {} does not exist!", (Object)id);
                throw new IllegalStateException("Drop provider " + String.valueOf(id) + " does not exist.");
            }
            return (ItemDropProvider)ItemDropProviderType.REGISTRY.get((Object)id).stream.decode((Object)buf);
        }
    };
    public static final Codec<List<ItemDropProvider>> LIST_CODEC = MapCodecs.flexibleList(DROP_PROVIDER_CODEC);

    public static <T extends ItemDropProvider> ItemDropProviderType<T> register(class_2960 id, MapCodec<T> codec, class_9139<class_9129, T> stream) {
        ItemDropProviderType<T> type = new ItemDropProviderType<T>(id, codec, stream);
        if (REGISTRY.containsKey(id)) {
            BotanyPotsMod.LOG.warn("Item drop provider {} has already been assigned to {}. Replacing it with {}.", new Object[]{id, REGISTRY.get(id), type});
        }
        REGISTRY.put(id, type);
        return type;
    }
}

